/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;

public class SWDownloadSet {
    private SWDownloadFile downloadFile;
    private SWDownloadSegment downloadSegment;
    private SWDownloadCandidate downloadCandidate;

    public SWDownloadSet(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) {
        this.downloadFile = sWDownloadFile;
        this.downloadCandidate = sWDownloadCandidate;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public SWDownloadCandidate getDownloadCandidate() {
        return this.downloadCandidate;
    }

    public void setDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        this.downloadSegment = sWDownloadSegment;
    }

    public SWDownloadSegment allocateDownloadSegment(SWDownloadWorker sWDownloadWorker) {
        if (this.downloadSegment == null) {
            this.downloadSegment = this.downloadFile.allocateDownloadSegment(sWDownloadWorker, this.downloadCandidate.getAvailableRangeSet());
            this.downloadCandidate.associateDownloadSegment(this.downloadSegment);
        }
        return this.downloadSegment;
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            this.downloadFile.releaseDownloadSegment(this.downloadSegment);
            this.downloadSegment = null;
        }
        this.downloadCandidate.releaseDownloadSegment();
    }

    public void releaseDownloadSet() {
        if (this.downloadSegment != null) {
            this.downloadFile.releaseDownloadSegment(this.downloadSegment);
        }
        this.downloadCandidate.releaseDownloadSegment();
        this.downloadFile.releaseDownloadCandidate(this.downloadCandidate);
        this.downloadFile.decrementWorkerCount();
    }

    public String toString() {
        return "[DownloadSet: (Segment: " + this.downloadSegment + " - Candidate: " + this.downloadCandidate + " - File: " + this.downloadFile + ")]";
    }
}

