/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeStatus;
import phex.connection.handshake.LeafHandshakeHandler;
import phex.connection.handshake.PeerHandshakeHandler;
import phex.connection.handshake.UltrapeerHandshakeHandler;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;

public abstract class HandshakeHandler
implements ConnectionConstants {
    protected Host connectedHost;

    public HandshakeHandler(Host host) {
        this.connectedHost = host;
    }

    public HTTPHeaders createAcceptHandshakeHeaders() {
        HTTPHeaders hTTPHeaders = new HTTPHeaders(HTTPHeaders.ACCEPT_HANDSHAKE_HEADERS);
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        hTTPHeaders.addHeader(new HTTPHeader("Listen-IP", hostAddress.getFullHostName()));
        hTTPHeaders.addHeader(new HTTPHeader("Remote-IP", this.connectedHost.getHostAddress().getFullHostName()));
        return hTTPHeaders;
    }

    public HTTPHeaders createRejectHandshakeHeaders() {
        HTTPHeaders hTTPHeaders = new HTTPHeaders(HTTPHeaders.COMMON_HANDSHAKE_HEADERS);
        hTTPHeaders.addHeader(new HTTPHeader("Remote-IP", this.connectedHost.getHostAddress().getFullHostName()));
        return hTTPHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus handshakeStatus, boolean bl) {
        if (bl) {
            return new HandshakeStatus(200, "OK");
        }
        if (HostManager.getInstance().getNetworkHostsContainer().hasPeerSlotsAvailable()) {
            return new HandshakeStatus(200, "OK", this.createAcceptHandshakeHeaders());
        }
        return new HandshakeStatus(503, "I am busy.", this.createRejectHandshakeHeaders());
    }

    public static HandshakeHandler createHandshakeHandler(Host host) {
        if (HostManager.getInstance().isAbleToBecomeUltrapeer() && !HostManager.getInstance().isShieldedLeafNode()) {
            return new UltrapeerHandshakeHandler(host);
        }
        if (ServiceManager.sCfg.allowToBecomeLeaf) {
            return new LeafHandshakeHandler(host);
        }
        return new PeerHandshakeHandler(host);
    }
}

