/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.connection.ConnectionClosedException;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.connection.SocketProvider;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;
import phex.http.HTTPProcessor;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgManager;
import phex.msg.MsgPing;
import phex.msg.MsgPong;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.msg.RouteTableUpdateMsg;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.statistic.MessageCountStatistic;
import phex.upload.PushWorker;
import phex.utils.GnutellaInputStream;
import phex.utils.HexConverter;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class ConnectionEngine
implements ConnectionConstants {
    private HostManager hostMgr;
    private ShareManager shareMgr;
    private QueryHistoryMonitor queryHistory;
    private FileAdministration fileAdministration;
    private MsgManager messageMgr;
    private NetworkManager networkMgr;
    private PhexSecurityManager securityManager;
    private byte[] headerBuffer;
    private Host connectedHost;
    private HTTPHeaders headersRead;
    private HTTPHeaders headersSend;
    private GnutellaInputStream inputStream;

    public ConnectionEngine(Host host) throws IOException {
        this.connectedHost = host;
        this.shareMgr = ShareManager.getInstance();
        this.fileAdministration = this.shareMgr.getFileAdministration();
        this.queryHistory = QueryManager.getInstance().getQueryHistoryMonitor();
        this.messageMgr = MsgManager.getInstance();
        this.hostMgr = HostManager.getInstance();
        this.networkMgr = NetworkManager.getInstance();
        this.securityManager = PhexSecurityManager.getInstance();
    }

    public void processIncomingData() throws IOException {
        this.headerBuffer = new byte[23];
        try {
            while (true) {
                Message message;
                MsgHeader msgHeader;
                block22: {
                    msgHeader = this.readHeader();
                    byte[] byArray = MessageProcessor.readMessageBody(this.inputStream, msgHeader.getDataLen());
                    this.connectedHost.incReceivedCount();
                    byte by = msgHeader.getTTL();
                    byte by2 = msgHeader.getHopsTaken();
                    if (by < 0 || by2 < 0) {
                        this.dropMessage(msgHeader, byArray, "TTL or hops below 0");
                        continue;
                    }
                    if (by2 >= ServiceManager.sCfg.maxTTL) {
                        this.dropMessage(msgHeader, byArray, "Hops larger then maxTTL");
                        continue;
                    }
                    if (by >= ServiceManager.sCfg.maxTTL) {
                        msgHeader.setTTL((byte)(ServiceManager.sCfg.maxTTL - by2));
                    }
                    try {
                        message = MessageProcessor.createMessageFromBody(msgHeader, byArray);
                        if (message == null) {
                            this.dropMessage(msgHeader, byArray, "Unknown message type");
                        }
                        break block22;
                    }
                    catch (InvalidMessageException invalidMessageException) {
                        this.dropMessage(msgHeader, byArray, "Invalid message: " + invalidMessageException.getMessage());
                        Logger.logWarning(invalidMessageException);
                    }
                    continue;
                }
                msgHeader.countHop();
                switch (msgHeader.getPayload()) {
                    case 0: {
                        this.handlePing((MsgPing)message);
                        break;
                    }
                    case 1: {
                        this.handlePong((MsgPong)message);
                        break;
                    }
                    case 64: {
                        this.handlePushRequest((MsgPushRequest)message);
                        break;
                    }
                    case -128: {
                        this.handleQuery((MsgQuery)message);
                        break;
                    }
                    case -127: {
                        this.handleQueryResponse((MsgQueryResponse)message);
                        break;
                    }
                    case 48: {
                        this.handleRouteTableUpdate((RouteTableUpdateMsg)message);
                    }
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage(Logger.WARNING, (short)16, unknownHostException);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, unknownHostException.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw new IOException("Exception occured: " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINEST, (short)16, iOException);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, iOException.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw iOException;
        }
        catch (Exception exception) {
            Logger.logMessage(Logger.WARNING, (short)16, exception);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, exception.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw new IOException("Exception occured: " + exception.getMessage());
        }
    }

    private void handlePing(MsgPing msgPing) {
        MessageCountStatistic.pingMsgInCounter.increment(1);
        MsgHeader msgHeader = msgPing.getHeader();
        if (!this.messageMgr.checkAndAddToPingRoutingTable(msgHeader.getMsgID(), this.connectedHost)) {
            this.dropMessage(msgPing, "Dropping already seen ping");
            return;
        }
        if (msgPing.getHeader().getTTL() > 0) {
            this.messageMgr.forwardPing(msgPing, this.connectedHost);
        }
        this.respondToPing(msgPing);
    }

    private void respondToPing(MsgPing msgPing) {
        byte by;
        MsgHeader msgHeader = msgPing.getHeader();
        byte by2 = msgHeader.getTTL();
        if (by2 + (by = msgHeader.getHopsTaken()) > 2 && !this.hostMgr.areIncommingSlotsAdvertised()) {
            return;
        }
        byte by3 = by;
        by = (byte)(by + 1);
        byte by4 = by3;
        if (by + by2 <= 2) {
            by4 = 1;
        }
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID(), 1, by4, 0, 0);
        try {
            HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
            MsgPong msgPong = new MsgPong(msgHeader2, hostAddress.getHostIP(), (short)hostAddress.getPort(), this.fileAdministration.getFileCount(), this.fileAdministration.getTotalFileSizeInKb());
            this.connectedHost.queueMessageToSend(msgPong);
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logError(unknownHostException);
        }
    }

    private void handlePong(MsgPong msgPong) {
        Host host;
        MessageCountStatistic.pongMsgInCounter.increment(1);
        MsgHeader msgHeader = msgPong.getHeader();
        byte[] byArray = msgPong.getIP();
        byte by = this.securityManager.controlHostIPAccess(byArray);
        if (by == 3) {
            this.dropMessage(msgPong, "IP access strongly denied.");
            return;
        }
        int n = msgPong.getPort();
        HostAddress hostAddress = null;
        if (by == 1) {
            hostAddress = new HostAddress(byArray, n);
            int n2 = msgPong.isUltrapeerMarked() ? 2 : 0;
            this.hostMgr.getCaughtHostsContainer().addCaughtHost(hostAddress, n2);
        }
        if ((host = this.messageMgr.getPingRouting(msgHeader.getMsgID())) == null) {
            return;
        }
        if (hostAddress == null) {
            hostAddress = new HostAddress(byArray, n);
        }
        if (host == Host.LOCAL_HOST) {
            HostAddress hostAddress2 = this.connectedHost.getHostAddress();
            if (hostAddress.equals(hostAddress2)) {
                this.connectedHost.setFileCount(msgPong.getFileCount());
                this.connectedHost.setTotalFileSize(msgPong.getFileSizeInKB());
                return;
            }
            try {
                byte[] byArray2 = hostAddress2.getHostIP();
                if (msgPong.getHeader().getHopsTaken() == 1 && Arrays.equals(byArray2, byArray)) {
                    this.connectedHost.setFileCount(msgPong.getFileCount());
                    this.connectedHost.setTotalFileSize(msgPong.getFileSizeInKB());
                    hostAddress2.updateAddress(byArray2, n);
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (msgPong.getHeader().getTTL() > 0) {
            host.queueMessageToSend(msgPong);
        }
    }

    private void handleQuery(MsgQuery msgQuery) throws UnknownHostException {
        MessageCountStatistic.queryMsgInCounter.increment(1);
        MsgHeader msgHeader = msgQuery.getHeader();
        if (!this.messageMgr.checkAndAddToQueryRoutingTable(msgHeader.getMsgID(), this.connectedHost)) {
            this.dropMessage(msgQuery, "Dropping already seen query");
            return;
        }
        this.queryHistory.addSearchQuery(msgQuery);
        this.messageMgr.forwardQuery(msgQuery, this.connectedHost);
        ShareFile[] shareFileArray = this.shareMgr.handleQuery(msgQuery);
        if (shareFileArray.length == 0) {
            return;
        }
        this.replyToQuery(msgHeader, shareFileArray);
    }

    private void replyToQuery(MsgHeader msgHeader, ShareFile[] shareFileArray) throws UnknownHostException {
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID(), 1, (byte)(msgHeader.getHopsTaken() + 1), 0, 0);
        int n = shareFileArray.length;
        if (n > 255) {
            n = 255;
        }
        ShareFile shareFile = null;
        MsgResRecord[] msgResRecordArray = new MsgResRecord[n];
        int n2 = 0;
        while (n2 < n) {
            MsgResRecord msgResRecord;
            shareFile = shareFileArray[n2];
            msgResRecordArray[n2] = msgResRecord = new MsgResRecord(shareFile.getFileIndex(), shareFile.getURN(), (int)shareFile.getFileSize(), shareFile.getFileName());
            ++n2;
        }
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader2, ServiceManager.sCfg.mProgramClientID, hostAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L), msgResRecordArray);
        this.connectedHost.queueMessageToSend(msgQueryResponse);
    }

    private void handleQueryResponse(MsgQueryResponse msgQueryResponse) {
        MessageCountStatistic.queryHitMsgInCounter.increment(1);
        byte[] byArray = msgQueryResponse.getHostIP();
        byte by = this.securityManager.controlHostIPAccess(byArray);
        if (by == 3) {
            this.dropMessage(msgQueryResponse, "IP access strongly denied.");
            return;
        }
        if (by == 1) {
            this.messageMgr.processQueryResponse(this.connectedHost, msgQueryResponse);
        }
        this.messageMgr.addToPushRoutingTable(msgQueryResponse.getRemoteClientID(), this.connectedHost);
        Host host = this.messageMgr.getQueryRouting(msgQueryResponse.getHeader().getMsgID());
        if (host == null) {
            return;
        }
        if (msgQueryResponse.getHeader().getTTL() > 0) {
            host.queueMessageToSend(msgQueryResponse);
        }
    }

    private void handleRouteTableUpdate(RouteTableUpdateMsg routeTableUpdateMsg) {
        MessageCountStatistic.totalInMsgCounter.increment(1);
        if (!this.connectedHost.isQueryRoutingSupported() && !this.connectedHost.isUPQueryRoutingSupported()) {
            this.dropMessage(routeTableUpdateMsg, "QRP not supported from host.");
            return;
        }
        QueryRoutingTable queryRoutingTable = this.connectedHost.getLastReceivedRoutingTable();
        if (queryRoutingTable == null) {
            queryRoutingTable = new QueryRoutingTable();
            this.connectedHost.setLastReceivedRoutingTable(queryRoutingTable);
        }
        try {
            queryRoutingTable.updateRouteTable(routeTableUpdateMsg);
        }
        catch (InvalidMessageException invalidMessageException) {
            this.dropMessage(routeTableUpdateMsg, "Invalid QRT update message.");
        }
    }

    private void handlePushRequest(MsgPushRequest msgPushRequest) throws UnknownHostException {
        MessageCountStatistic.pushMsgInCounter.increment(1);
        byte by = this.securityManager.controlHostAddressAccess(msgPushRequest.getRequestAddress());
        if (by == 3) {
            this.dropMessage(msgPushRequest, "IP access strongly denied.");
            return;
        }
        if (ServiceManager.sCfg.mProgramClientID.equals(msgPushRequest.getClientGUID())) {
            if (by == 1) {
                new PushWorker(msgPushRequest);
            }
            return;
        }
        Host host = this.messageMgr.getPushRouting(msgPushRequest.getClientGUID());
        if (host == null) {
            return;
        }
        if (msgPushRequest.getHeader().getTTL() > 0) {
            host.queueMessageToSend(msgPushRequest);
        }
    }

    private void dropMessage(MsgHeader msgHeader, byte[] byArray, String string) {
        this.connectedHost.log(Logger.FINER, "Dropping message: " + string);
        if (Logger.isLevelLogged(Logger.FINEST)) {
            this.connectedHost.log(Logger.FINEST, "Header: " + msgHeader.getDebugString() + " Body: " + " (" + HexConverter.toHexString(byArray, 0, msgHeader.getDataLen()) + ").");
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private void dropMessage(Message message, String string) {
        this.connectedHost.log(Logger.FINER, "Dropping message: " + string);
        if (Logger.isLevelLogged(Logger.FINEST)) {
            this.connectedHost.log(Logger.FINEST, "Header: [" + message.getHeader().getDebugString() + "] - Message: [" + message.toDebugString() + "].");
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private MsgHeader readHeader() throws IOException {
        MsgHeader msgHeader = MessageProcessor.parseMessageHeader(this.inputStream, this.headerBuffer);
        if (msgHeader == null) {
            throw new ConnectionClosedException("Connection closed by remote host");
        }
        int n = msgHeader.getDataLen();
        if (n < 0) {
            throw new IOException("Negative body size. Disconnecting the remote host.");
        }
        if (n > ServiceManager.sCfg.maxMessageLength) {
            if (Logger.isLevelLogged(Logger.WARNING)) {
                byte[] byArray = MessageProcessor.readMessageBody(this.inputStream, 262144);
                String string = HexConverter.toHexString(byArray);
                this.connectedHost.log(Logger.WARNING, "Body too big. Header: " + msgHeader + "\nBody(256KB): " + string);
            }
            throw new IOException("Packet too big. Disconnecting the remote host.");
        }
        msgHeader.setArrivalTime(System.currentTimeMillis());
        msgHeader.setFromHost(this.connectedHost);
        return msgHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeOutgoingConnection() throws IOException {
        this.connectedHost.setStatus(2);
        Socket socket = SocketProvider.connect(this.connectedHost.getHostAddress(), ServiceManager.sCfg.mNetConnectionTimeout);
        this.connectedHost.setSocket(socket);
        this.inputStream = this.connectedHost.getInputStream();
        try {
            this.initializeOutgoingWith06();
            this.configureConnectionType(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addConnectedHost(this.connectedHost);
        MsgPing msgPing = new MsgPing();
        this.messageMgr.checkAndAddToPingRoutingTable(msgPing.getHeader().getMsgID(), Host.LOCAL_HOST);
        this.connectedHost.queueMessageToSend(msgPing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeIncomingConnection(String string) throws IOException {
        this.inputStream = this.connectedHost.getInputStream();
        HostManager hostManager = HostManager.getInstance();
        int n = string.lastIndexOf(47) + 1;
        String string2 = string.substring(n, string.length());
        try {
            if (string2.equals("0.4")) {
                this.initializeIncomingWith04();
            } else if (this.is06orHigher(string2)) {
                this.initializeIncomingWith06();
            }
            this.configureConnectionType(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(4);
        hostManager.addIncomingHost(this.connectedHost);
        MsgPing msgPing = new MsgPing();
        this.messageMgr.checkAndAddToPingRoutingTable(msgPing.getHeader().getMsgID(), Host.LOCAL_HOST);
        this.connectedHost.queueMessageToSend(msgPing);
    }

    private void initializeIncomingWith04() throws IOException {
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus handshakeStatus = handshakeHandler.createHandshakeResponse(new HandshakeStatus(200, "OK"), false);
        if (handshakeStatus.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
        }
        this.sendStringToHost("GNUTELLA OK\n\n");
        this.headersRead = HTTPHeaders.EMPTY_HTTPHEADERS;
        this.headersSend = HTTPHeaders.EMPTY_HTTPHEADERS;
    }

    private void initializeIncomingWith06() throws IOException {
        this.headersRead = HTTPProcessor.parseHTTPHeaders(this.connectedHost.getInputStream());
        if (Logger.isLevelLogged(Logger.FINER)) {
            this.connectedHost.log(Logger.FINER, "Connect headers: " + this.headersRead.buildHTTPHeaderString());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus handshakeStatus = handshakeHandler.createHandshakeResponse(new HandshakeStatus(this.headersRead), false);
        this.headersSend = handshakeStatus.getResponseHeaders();
        this.sendStringToHost("GNUTELLA/0.6 " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage() + "\r\n");
        String string = handshakeStatus.getResponseHeaders().buildHTTPHeaderString();
        this.sendStringToHost(string);
        this.sendStringToHost("\r\n");
        if (handshakeStatus.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
        }
        HandshakeStatus handshakeStatus2 = HandshakeStatus.parseHandshakeResponse(this.inputStream);
        if (Logger.isLevelLogged(Logger.FINER)) {
            this.connectedHost.log(Logger.FINER, "Response Code: '" + handshakeStatus2.getStatusCode() + "'.");
            this.connectedHost.log(Logger.FINER, "Response Message: '" + handshakeStatus2.getStatusMessage() + "'.");
            this.connectedHost.log(Logger.FINER, "Response Headers: " + handshakeStatus2.getResponseHeaders().buildHTTPHeaderString());
        }
        if (handshakeStatus2.getStatusCode() != 200) {
            throw new IOException("Host rejected connection: " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage());
        }
        this.headersRead.replaceHeaders(handshakeStatus2.getResponseHeaders());
    }

    private void initializeOutgoingWith06() throws IOException {
        this.connectedHost.setStatus(2, Localizer.getString("Negotiate0_6Handshake"));
        String string = this.networkMgr.getNetworkGreeting();
        String string2 = string + '/' + "0.6" + "\r\n";
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string2);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HTTPHeaders hTTPHeaders = handshakeHandler.createAcceptHandshakeHeaders();
        stringBuffer.append(hTTPHeaders.buildHTTPHeaderString());
        stringBuffer.append("\r\n");
        this.headersSend = hTTPHeaders;
        String string3 = stringBuffer.toString();
        this.sendStringToHost(string3);
        HandshakeStatus handshakeStatus = HandshakeStatus.parseHandshakeResponse(this.connectedHost.getInputStream());
        this.headersRead = handshakeStatus.getResponseHeaders();
        if (Logger.isLevelLogged(Logger.FINER)) {
            this.connectedHost.log(Logger.FINER, "Response Code: '" + handshakeStatus.getStatusCode() + "'.");
            this.connectedHost.log(Logger.FINER, "Response Message: '" + handshakeStatus.getStatusMessage() + "'.");
            this.connectedHost.log(Logger.FINER, "Response Headers: " + this.headersRead.buildHTTPHeaderString());
        }
        if (handshakeStatus.getStatusCode() != 200) {
            throw new ConnectionRejectedException("Gnutella 0.6 connection rejected. Status: " + handshakeStatus.getStatusCode() + " - " + handshakeStatus.getStatusMessage());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeStatus handshakeStatus2 = handshakeHandler.createHandshakeResponse(handshakeStatus, true);
        HTTPHeaders hTTPHeaders2 = handshakeStatus2.getResponseHeaders();
        this.headersSend.replaceHeaders(hTTPHeaders2);
        this.sendStringToHost("GNUTELLA/0.6 " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage() + "\r\n");
        String string4 = hTTPHeaders2.buildHTTPHeaderString();
        this.sendStringToHost(string4);
        this.sendStringToHost("\r\n");
        if (handshakeStatus2.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage());
        }
    }

    private void configureConnectionType(HTTPHeaders hTTPHeaders, HTTPHeaders hTTPHeaders2) {
        HTTPHeader hTTPHeader = hTTPHeaders.getHeader("X-Ultrapeer");
        HTTPHeader hTTPHeader2 = hTTPHeaders2.getHeader("X-Ultrapeer");
        if (hTTPHeader == null || hTTPHeader2 == null) {
            this.connectedHost.setConnectionType((byte)0);
        } else if (hTTPHeader.booleanValue()) {
            if (hTTPHeader2.booleanValue()) {
                this.connectedHost.setConnectionType((byte)2);
            } else {
                this.connectedHost.setConnectionType((byte)3);
            }
        } else if (hTTPHeader2.booleanValue()) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
        }
    }

    private void handleXTryHeaders(HTTPHeaders hTTPHeaders) {
        HTTPHeader[] hTTPHeaderArray = hTTPHeaders.getHeaders("X-Try");
        if (hTTPHeaderArray != null) {
            this.handleXTryHosts(hTTPHeaderArray, true);
        }
        if ((hTTPHeaderArray = hTTPHeaders.getHeaders("X-Try-Ultrapeers")) != null) {
            this.handleXTryHosts(hTTPHeaderArray, false);
        }
    }

    private void handleXTryHosts(HTTPHeader[] hTTPHeaderArray, boolean bl) {
        int n = bl ? 2 : 1;
        CaughtHostsContainer caughtHostsContainer = HostManager.getInstance().getCaughtHostsContainer();
        int n2 = 0;
        while (n2 < hTTPHeaderArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeaderArray[n2].getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                byte[] byArray = HostAddress.parseIP(string);
                if (byArray == null) continue;
                byte by = this.securityManager.controlHostIPAccess(byArray);
                switch (by) {
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        HostAddress hostAddress = new HostAddress(byArray, HostAddress.parsePort(string));
                        if (!bl && hostAddress.isPrivateIP()) {
                            n = 0;
                        }
                        caughtHostsContainer.addCaughtHost(hostAddress, n);
                    }
                }
            }
            ++n2;
        }
    }

    private void configureRemoteHost(HTTPHeaders hTTPHeaders) {
        block15: {
            Object object;
            HTTPHeader hTTPHeader = hTTPHeaders.getHeader("User-Agent");
            if (hTTPHeader != null) {
                this.connectedHost.setVendor(hTTPHeader.getValue());
            }
            if (this.connectedHost.isIncomming()) {
                hTTPHeader = hTTPHeaders.getHeader("Listen-IP");
                if (hTTPHeader == null) {
                    hTTPHeader = hTTPHeaders.getHeader("X-My-Address");
                }
                if (hTTPHeader != null) {
                    object = this.connectedHost.getHostAddress();
                    int n = HostAddress.parsePort(hTTPHeader.getValue());
                    if (n > 0) {
                        ((HostAddress)object).updateAddress(((HostAddress)object).getHostName(), n);
                    }
                }
            }
            try {
                HostAddress hostAddress;
                hTTPHeader = hTTPHeaders.getHeader("Remote-IP");
                if (hTTPHeader != null && (object = HostAddress.parseIP(hTTPHeader.getValue())) != null && !Arrays.equals((byte[])object, (hostAddress = NetworkManager.getInstance().getLocalAddress()).getHostIP())) {
                    NetworkManager.getInstance().updateLocalAddress((byte[])object);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            hTTPHeader = hTTPHeaders.getHeader("X-Query-Routing");
            if (hTTPHeader != null) {
                try {
                    float f2 = Float.parseFloat(hTTPHeader.getValue());
                    if (f2 >= 0.1f) {
                        this.connectedHost.setQueryRoutingSupported(true);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((hTTPHeader = hTTPHeaders.getHeader("X-Ultrapeer-Query-Routing")) == null) break block15;
            try {
                float f3 = Float.parseFloat(hTTPHeader.getValue());
                if (f3 >= 0.1f) {
                    this.connectedHost.setUPQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private boolean is06orHigher(String string) {
        int n = VersionUtils.compare(string, "0.6");
        return n >= 0;
    }

    private void sendStringToHost(String string) throws IOException {
        this.connectedHost.log(Logger.FINER, "Send: " + string);
        byte[] byArray = string.getBytes();
        OutputStream outputStream = this.connectedHost.getOutputStream();
        outputStream.write(byArray, 0, byArray.length);
        outputStream.flush();
    }
}

