/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.net.Socket;
import phex.common.ServiceManager;
import phex.connection.BrowseHostException;
import phex.connection.SocketProvider;
import phex.download.PushHandler;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgQueryResponse;
import phex.query.BrowseHostResults;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;

public class BrowseHostConnection {
    private BrowseHostResults results;
    private HostAddress address;
    private GUID hostGUID;

    public BrowseHostConnection(HostAddress hostAddress, GUID gUID, BrowseHostResults browseHostResults) {
        this.address = hostAddress;
        this.hostGUID = gUID;
        this.results = browseHostResults;
    }

    public void sendBrowseHostRequest() throws IOException, BrowseHostException {
        HTTPResponse hTTPResponse;
        Socket socket;
        block13: {
            Logger.logMessage(Logger.INFO, (short)8, "Connection for Browse Host to " + this.address.getFullHostName());
            try {
                socket = SocketProvider.connect(this.address, ServiceManager.sCfg.mNetConnectionTimeout);
            }
            catch (IOException iOException) {
                if (this.hostGUID == null) {
                    throw iOException;
                }
                socket = PushHandler.requestSocketViaPush(this.hostGUID, 50484558L, "/");
                if (socket != null) break block13;
                throw new IOException("Push request failed");
            }
        }
        HTTPRequest hTTPRequest = new HTTPRequest("GET", "/", true);
        hTTPRequest.addHeader(new HTTPHeader("Host", this.address.getFullHostName()));
        hTTPRequest.addHeader(new HTTPHeader("Accept", "application/x-gnutella-packets"));
        hTTPRequest.addHeader(new HTTPHeader("Content-Length", "0"));
        hTTPRequest.addHeader(new HTTPHeader("Connection", "close"));
        String string = hTTPRequest.buildHTTPRequestString();
        Logger.logMessage(Logger.INFO, (short)8, "Sending Browse Host request: " + string);
        socket.getOutputStream().write(string.toString().getBytes());
        GnutellaInputStream gnutellaInputStream = new GnutellaInputStream(socket.getInputStream(), ServiceManager.getInstance().getNetworkBandwidthController());
        try {
            hTTPResponse = HTTPProcessor.parseHTTPResponse(gnutellaInputStream);
        }
        catch (HTTPMessageException hTTPMessageException) {
            throw new BrowseHostException("Invalid HTTP Response: " + hTTPMessageException.getMessage());
        }
        Logger.logMessage(Logger.INFO, (short)8, "Received Browse Host response: " + hTTPResponse.buildHTTPResponseString());
        if (hTTPResponse.getStatusCode() < 200 || hTTPResponse.getStatusCode() > 299) {
            throw new BrowseHostException("Browse host request not successfull. StatusCode: " + hTTPResponse.getStatusCode() + " " + hTTPResponse.getStatusReason());
        }
        HTTPHeader hTTPHeader = hTTPResponse.getHeader("Content-Type");
        if (hTTPHeader == null) {
            throw new BrowseHostException("Unknwon content-type.");
        }
        if (hTTPHeader.getValue().equals("application/x-gnutella-packets")) {
            MsgHeader msgHeader;
            HostManager hostManager = HostManager.getInstance();
            SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
            byte[] byArray = new byte[23];
            while ((msgHeader = MessageProcessor.parseMessageHeader(gnutellaInputStream, byArray)) != null) {
                if (msgHeader.getPayload() != -127) {
                    throw new BrowseHostException("Wrong header payload. Expecting query hit.");
                }
                MsgQueryResponse msgQueryResponse = null;
                try {
                    msgQueryResponse = (MsgQueryResponse)MessageProcessor.parseMessage(msgHeader, gnutellaInputStream);
                }
                catch (InvalidMessageException invalidMessageException) {
                    Logger.logMessage(Logger.FINE, (short)16, invalidMessageException);
                    throw new IOException("Invalid message returned: " + invalidMessageException.getMessage());
                }
                this.results.processResponse(msgQueryResponse);
            }
        } else {
            throw new BrowseHostException("Not supported content-type. " + hTTPHeader.getValue());
        }
    }
}

