/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.bandwidth.BandwidthWindow;
import phex.common.bandwidth.ControllerWindowTimer;
import phex.common.bandwidth.SlidingWindow;
import phex.statistic.StatisticProvider;
import phex.utils.StrUtil;

public class BandwidthController
implements StatisticProvider {
    private ControllerWindowTimer timer = ControllerWindowTimer.instance;
    private long throttlingRate;
    private SlidingWindow slidingWindow = new SlidingWindow(2);
    private BandwidthWindow bandwidthWindow = new BandwidthWindow();
    private final String controllerName;
    private BandwidthController nextContollerInChain = null;

    private BandwidthController(String string) {
        this.controllerName = string + " " + Integer.toHexString(this.hashCode());
        this.setThrottlingRate(0L);
        this.timer.registerThrottleController(this);
    }

    public synchronized BandwidthController linkControllerIntoChain(BandwidthController bandwidthController) {
        BandwidthController bandwidthController2 = this.nextContollerInChain;
        this.nextContollerInChain = bandwidthController;
        return bandwidthController2;
    }

    public synchronized void setThrottlingRate(long l) {
        this.throttlingRate = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean controlBandwidth(int n) {
        boolean bl;
        BandwidthController bandwidthController = this;
        synchronized (bandwidthController) {
            bl = this.slidingWindow.addBytesTransfered(n);
            this.bandwidthWindow.countBytesTransfered(n);
        }
        if (bl) {
            long l = this.timer.getRemainingTimeThisPeriod() + 3L;
            if (l <= 0L) {
                l = 1L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.nextContollerInChain != null) {
            return this.nextContollerInChain.controlBandwidth(n);
        }
        return bl;
    }

    public void newRatePeriod() {
        this.slidingWindow.slideWindow(this.throttlingRate);
        this.bandwidthWindow.slideWindow();
    }

    public void dispose() {
        this.timer.deregisterThrottleController(this);
        this.nextContollerInChain = null;
    }

    public String getName() {
        return this.controllerName;
    }

    public String toDebugString() {
        return "ThrottleController[Name:" + this.controllerName + ",test:" + this.bandwidthWindow.getCurrentTransferRate() + " " + this.bandwidthWindow.getAvgTransferRate();
    }

    public static BandwidthController acquireBandwidthController(String string) {
        return new BandwidthController(string);
    }

    public static void releaseController(BandwidthController bandwidthController) {
        bandwidthController.dispose();
    }

    public Object getValue() {
        return this.bandwidthWindow.getCurrentTransferRate();
    }

    public Object getAverageValue() {
        return this.bandwidthWindow.getAvgTransferRate();
    }

    public Object getMaxValue() {
        return this.bandwidthWindow.getMaxTransferRate();
    }

    public String toStatisticString(Object object) {
        return StrUtil.formatSizeBytes((Number)object) + " / sec.";
    }
}

