/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import phex.JobsRunner;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.TransferRateService;
import phex.common.bandwidth.BandwidthController;
import phex.utils.FileUtils;
import phex.utils.Logger;

public class ServiceManager {
    private static ServiceManager sTheManager = null;
    private static Object sInitLocker = new Object();
    public static Cfg sCfg = new Cfg(Environment.getInstance().getPhexConfigFile("phex.cfg"));
    private JobsRunner mJobsRunner;
    private TransferRateService transferRateService;
    private BandwidthController phexBandwidthController;
    private BandwidthController networkBandwidthController;
    private BandwidthController downloadBandwidthController;
    private BandwidthController uploadBandwidthController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceManager getInstance() {
        if (sTheManager == null) {
            Object object = sInitLocker;
            synchronized (object) {
                if (sTheManager == null) {
                    sTheManager = new ServiceManager();
                    sTheManager.init();
                }
            }
        }
        return sTheManager;
    }

    private ServiceManager() {
    }

    private void init() {
        Logger.logMessage(Logger.FINE, (short)255, "Init ServiceManager");
        this.transferRateService = new TransferRateService();
        Logger.logMessage(Logger.FINER, (short)255, "Started TransferRateService");
        this.mJobsRunner = new JobsRunner();
        Logger.logMessage(Logger.FINER, (short)255, "Started JobsRunner");
        this.phexBandwidthController = BandwidthController.acquireBandwidthController("PhexThrottle");
        this.phexBandwidthController.setThrottlingRate(ServiceManager.sCfg.maxTotalBandwidth);
        this.networkBandwidthController = BandwidthController.acquireBandwidthController("NetworkThrottle");
        this.networkBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.networkBandwidthController.setThrottlingRate(ServiceManager.sCfg.mNetMaxRate);
        this.downloadBandwidthController = BandwidthController.acquireBandwidthController("DownloadThrottle");
        this.downloadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.downloadBandwidthController.setThrottlingRate(ServiceManager.sCfg.mDownloadMaxBandwidth);
        this.uploadBandwidthController = BandwidthController.acquireBandwidthController("UploadThrottle");
        this.uploadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.uploadBandwidthController.setThrottlingRate(ServiceManager.sCfg.mUploadMaxBandwidth);
        Logger.logMessage(Logger.FINE, (short)255, "ServiceManager is ready");
    }

    public synchronized void shutdown() {
        this.mJobsRunner.shutdown(true);
        BandwidthController.releaseController(this.downloadBandwidthController);
        BandwidthController.releaseController(this.uploadBandwidthController);
        BandwidthController.releaseController(this.networkBandwidthController);
        BandwidthController.releaseController(this.phexBandwidthController);
    }

    public void startJobsRunner() {
        this.mJobsRunner.startup();
    }

    public static TransferRateService getTransferRateService() {
        return ServiceManager.getInstance().transferRateService;
    }

    public static File getHostsFile() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            return Environment.getInstance().getPhexConfigFile("phex.hosts");
        }
        String string = "phex_" + ServiceManager.sCfg.mCurrentNetwork + ".hosts";
        string = FileUtils.convertToLocalSystemFilename(string);
        return Environment.getInstance().getPhexConfigFile(string);
    }

    public static String envSubstitution(String string) {
        String string2 = string.toLowerCase();
        String string3 = "$user.home";
        String string4 = "$(user.home)";
        if (string2.startsWith(string3)) {
            string = System.getProperty("user.home") + string.substring(string3.length());
        } else if (string2.startsWith(string4)) {
            string = System.getProperty("user.home") + string.substring(string4.length());
        }
        return string;
    }

    public static void setUploadBandwidth(int n) {
        ServiceManager.sCfg.mUploadMaxBandwidth = n;
        ServiceManager.sTheManager.uploadBandwidthController.setThrottlingRate(n);
    }

    public static void setDownloadBandwidth(int n) {
        ServiceManager.sCfg.mDownloadMaxBandwidth = n;
        ServiceManager.sTheManager.downloadBandwidthController.setThrottlingRate(n);
    }

    public static void setNetworkBandwidth(int n) {
        ServiceManager.sCfg.mNetMaxRate = n;
        ServiceManager.sTheManager.networkBandwidthController.setThrottlingRate(n);
    }

    public static void setPhexTotalBandwidth(int n) {
        ServiceManager.sCfg.maxTotalBandwidth = n;
        ServiceManager.sTheManager.phexBandwidthController.setThrottlingRate(n);
    }

    public BandwidthController getPhexBandwidthController() {
        return this.phexBandwidthController;
    }

    public BandwidthController getNetworkBandwidthController() {
        return this.networkBandwidthController;
    }

    public BandwidthController getDownloadBandwidthController() {
        return this.downloadBandwidthController;
    }

    public BandwidthController getUploadBandwidthController() {
        return this.uploadBandwidthController;
    }

    static {
        sCfg.load();
    }
}

