/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import phex.common.Manager;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class Environment {
    private static final Class[] MANAGER_CLASSES = new Class[]{class$phex$download$swarming$SwarmingManager == null ? (class$phex$download$swarming$SwarmingManager = Environment.class$("phex.download.swarming.SwarmingManager")) : class$phex$download$swarming$SwarmingManager, class$phex$connection$NetworkManager == null ? (class$phex$connection$NetworkManager = Environment.class$("phex.connection.NetworkManager")) : class$phex$connection$NetworkManager, class$phex$upload$UploadManager == null ? (class$phex$upload$UploadManager = Environment.class$("phex.upload.UploadManager")) : class$phex$upload$UploadManager, class$phex$share$ShareManager == null ? (class$phex$share$ShareManager = Environment.class$("phex.share.ShareManager")) : class$phex$share$ShareManager, class$phex$query$QueryManager == null ? (class$phex$query$QueryManager = Environment.class$("phex.query.QueryManager")) : class$phex$query$QueryManager, class$phex$chat$ChatManager == null ? (class$phex$chat$ChatManager = Environment.class$("phex.chat.ChatManager")) : class$phex$chat$ChatManager, class$phex$host$HostManager == null ? (class$phex$host$HostManager = Environment.class$("phex.host.HostManager")) : class$phex$host$HostManager, class$phex$security$PhexSecurityManager == null ? (class$phex$security$PhexSecurityManager = Environment.class$("phex.security.PhexSecurityManager")) : class$phex$security$PhexSecurityManager, class$phex$msg$MsgManager == null ? (class$phex$msg$MsgManager = Environment.class$("phex.msg.MsgManager")) : class$phex$msg$MsgManager, class$phex$statistic$StatisticsManager == null ? (class$phex$statistic$StatisticsManager = Environment.class$("phex.statistic.StatisticsManager")) : class$phex$statistic$StatisticsManager};
    private static Environment environment;
    private Properties properties;
    private File configurationRoot;
    private Timer timerService;
    private boolean isWindowsOS;
    private boolean isWin2000orXpOS;
    private boolean isMacOSX;
    static /* synthetic */ Class class$phex$download$swarming$SwarmingManager;
    static /* synthetic */ Class class$phex$connection$NetworkManager;
    static /* synthetic */ Class class$phex$upload$UploadManager;
    static /* synthetic */ Class class$phex$share$ShareManager;
    static /* synthetic */ Class class$phex$query$QueryManager;
    static /* synthetic */ Class class$phex$chat$ChatManager;
    static /* synthetic */ Class class$phex$host$HostManager;
    static /* synthetic */ Class class$phex$security$PhexSecurityManager;
    static /* synthetic */ Class class$phex$msg$MsgManager;
    static /* synthetic */ Class class$phex$statistic$StatisticsManager;
    static /* synthetic */ Class class$phex$common$Environment;

    private Environment() {
        try {
            this.properties = new Properties();
            this.properties.load((class$phex$common$Environment == null ? (class$phex$common$Environment = Environment.class$("phex.common.Environment")) : class$phex$common$Environment).getResourceAsStream("/phex/resources/version.properties"));
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
            throw new RuntimeException();
        }
        this.initializeOS();
        this.timerService = new Timer(true);
    }

    public static Environment getInstance() {
        if (environment == null) {
            environment = new Environment();
        }
        return environment;
    }

    public void initializeManagers() {
        int n;
        Manager manager;
        ArrayList<Manager> arrayList = new ArrayList<Manager>(MANAGER_CLASSES.length);
        int n2 = 0;
        while (n2 < MANAGER_CLASSES.length) {
            try {
                Logger.logMessage(Logger.FINER, (short)255, "Initializing " + MANAGER_CLASSES[n2].getName());
                Method method = MANAGER_CLASSES[n2].getMethod("getInstance", new Class[0]);
                manager = (Manager)method.invoke(null, new Object[0]);
                n = manager.initialize() ? 1 : 0;
                if (n == 0) {
                    Logger.logError((short)255, "Failed to initialize " + manager.getClass().getName());
                    throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
                }
                arrayList.add(manager);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.logError(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.logError(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            ++n2;
        }
        n = arrayList.size();
        int n3 = 0;
        while (n3 < n) {
            manager = (Manager)arrayList.get(n3);
            Logger.logMessage(Logger.FINER, (short)255, "On post initialization " + manager.getClass().getName());
            boolean bl = manager.onPostInitialization();
            if (!bl) {
                Logger.logError((short)255, "Failed to initialize " + manager.getClass().getName());
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            ++n3;
        }
    }

    public void shutdownManagers() {
        int n = 0;
        while (n < MANAGER_CLASSES.length) {
            try {
                Logger.logMessage(Logger.FINER, (short)255, "Shutdown " + MANAGER_CLASSES[n].getName());
                Method method = MANAGER_CLASSES[n].getMethod("getInstance", new Class[0]);
                Manager manager = (Manager)method.invoke(null, new Object[0]);
                manager.shutdown();
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.logError(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Logger.logError(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
            ++n;
        }
    }

    public void setPhexConfigRoot(File file) throws IOException {
        boolean bl;
        if (file == null) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(System.getProperty("user.home"));
            stringBuffer.append(File.separator);
            if (File.separatorChar == '/') {
                stringBuffer.append('.');
            }
            stringBuffer.append("phex");
            file = new File(stringBuffer.toString());
        }
        if (!file.isDirectory() && !(bl = file.mkdirs())) {
            throw new IOException("Cant create directory: " + file.getAbsolutePath());
        }
        this.configurationRoot = file;
    }

    public File getPhexConfigFile(String string) {
        if (this.configurationRoot == null) {
            try {
                this.setPhexConfigRoot(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new File(this.configurationRoot, string);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public static String getPhexVendor() {
        return "Phex " + VersionUtils.getProgramVersion();
    }

    public void scheduleTimerTask(TimerTask timerTask, long l, long l2) {
        this.timerService.schedule(timerTask, l, l2);
    }

    public boolean isWindowsOS() {
        return this.isWindowsOS;
    }

    public boolean isMacOSX() {
        return this.isMacOSX;
    }

    public boolean isUltrapeerOS() {
        return !this.isWindowsOS || this.isWin2000orXpOS;
    }

    private void initializeOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os")) {
            this.isMacOSX = string.endsWith("x");
            return;
        }
        if (string.indexOf("windows") != -1) {
            this.isWindowsOS = true;
            if (string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
                this.isWin2000orXpOS = true;
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

