/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import phex.common.URN;
import phex.host.HostAddress;
import phex.security.PhexSecurityManager;
import phex.utils.Logger;
import phex.utils.StrUtil;

public class AlternateLocation {
    public static final Short DEFAULT_HOST_RATING = new Short(6);
    private URL url;
    private URN urn;
    private long timestamp;
    private String dateTimeStr;

    public AlternateLocation(URL uRL, URN uRN, long l, String string) {
        this.url = uRL;
        this.urn = uRN;
        this.timestamp = l;
        this.dateTimeStr = string;
    }

    public AlternateLocation(URL uRL, URN uRN, long l) {
        this.url = uRL;
        this.urn = uRN;
        if (l > 0L) {
            this.timestamp = l;
            this.dateTimeStr = AlternateLocation.buildDateTimeString(l);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public URN getURN() {
        return this.urn;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getHTTPString() {
        if (this.dateTimeStr != null) {
            return this.url.toExternalForm() + " " + this.dateTimeStr;
        }
        return this.url.toExternalForm();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlternateLocation)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        return this.timestamp == alternateLocation.timestamp && this.url.equals(alternateLocation.url);
    }

    public int hashCode() {
        int n = 0;
        n = 127 * n + (this.url != null ? this.url.hashCode() : 0);
        n = 31 * n + (int)(this.timestamp ^ this.timestamp >> 32);
        return n;
    }

    public static AlternateLocation parse(String string) {
        URL uRL;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f\"");
        String string2 = null;
        String string3 = null;
        long l = 0L;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            l = AlternateLocation.parseTimestamp(string3);
        }
        if ((uRL = AlternateLocation.parseURL(string2)) == null) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location path: " + string);
            return null;
        }
        URN uRN = URN.parseURNFromUriRes(uRL.getFile());
        if (uRN == null) {
            Logger.logMessage(Logger.FINE, (short)2, "Alt-location path without URN: " + string);
            return null;
        }
        AlternateLocation alternateLocation = new AlternateLocation(uRL, uRN, l, string3);
        return alternateLocation;
    }

    private static URL parseURL(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (!"http".equals(string2)) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Not a http URL): " + string);
                return null;
            }
            String string3 = uRL.getHost();
            int n = uRL.getPort();
            HostAddress hostAddress = new HostAddress(string3, n);
            byte by = PhexSecurityManager.getInstance().controlHostIPAccess(hostAddress.getHostIP());
            switch (by) {
                case 2: 
                case 3: {
                    Logger.logMessage(Logger.FINE, (short)2, "Alt-Location host denied: " + string);
                    return null;
                }
            }
            if (!hostAddress.isValidIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Invalid IP used): " + string);
                return null;
            }
            if (hostAddress.isPrivateIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Private IP used): " + string);
                return null;
            }
            if (n == -1) {
                uRL = new URL("http", uRL.getHost(), 80, uRL.getFile());
                n = uRL.getPort();
            }
            if (!HostAddress.isPortInRange(n)) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Port out of range): " + string);
                return null;
            }
            return uRL;
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (UnknownHost: " + unknownHostException.getMessage() + " ): " + string);
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Malformed: " + malformedURLException.getMessage() + " ): " + string);
            return null;
        }
    }

    private static long parseTimestamp(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf(84);
        String string2 = null;
        if (n4 == -1) {
            n4 = string.length() - 1;
        } else {
            string2 = string.substring(n4 + 1);
            if (!string2.endsWith("Z")) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid time in alt-location: " + string);
                return 0L;
            }
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = string.substring(0, n4);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
        if (stringTokenizer.countTokens() != 3) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid token count in alt-location: " + string);
            return 0L;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (string2 != null) {
                stringTokenizer = new StringTokenizer(string2, ":");
                if (stringTokenizer.hasMoreElements()) {
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreElements()) {
                    n6 = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreElements()) {
                    n7 = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logMessage(Logger.FINEST, (short)2, numberFormatException);
            Logger.logMessage(Logger.FINE, (short)2, "Invalid number format in alt-location: " + string);
            return 0L;
        }
        if (n3 < 2001 || n3 > 2100 || n2 < 0 || n2 > 11 || n < 1 || n > 31 || n5 < 0 || n5 > 23 || n6 < 0 || n6 > 59 || n7 < 0 || n7 > 59) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid DateTime range in alt-location: " + string);
            return 0L;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(n3, n6, n, n5, n6, n7);
        return calendar.getTime().getTime();
    }

    private static String buildDateTimeString(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date(l));
        String string = String.valueOf(calendar.get(1)) + "-" + StrUtil.padDigits(String.valueOf(calendar.get(2) + 1), 2) + "-" + StrUtil.padDigits(String.valueOf(calendar.get(5)), 2) + "T" + StrUtil.padDigits(String.valueOf(calendar.get(11)), 2) + ":" + StrUtil.padDigits(String.valueOf(calendar.get(12)), 2) + ":" + StrUtil.padDigits(String.valueOf(calendar.get(13)), 2) + "Z";
        return string;
    }
}

