/*
 * Decompiled with CFR 0.152.
 */
public final class regexp {
    public boolean ignoreCase;
    private String[] elements;
    private String prefix;
    private String suffix;
    private int prefixlen;
    private int suffixlen;
    private boolean exact;

    regexp(String exp, boolean ign) {
        int pos;
        this.ignoreCase = ign;
        this.exact = false;
        if (exp.indexOf(42, 0) == -1) {
            this.exact = true;
            this.prefix = exp;
            this.prefixlen = exp.length();
            if (ign) {
                this.prefix = this.prefix.toLowerCase();
            }
            return;
        }
        int i = 1;
        if (!exp.startsWith("*")) {
            this.prefix = exp.substring(0, exp.indexOf(42, 0));
            if (ign) {
                this.prefix = this.prefix.toLowerCase();
            }
            this.prefixlen = this.prefix.length();
            i = this.prefixlen + 1;
        }
        do {
            if ((pos = exp.indexOf(42, i)) == -1) {
                if (i == exp.length()) {
                    return;
                }
                this.suffix = exp.substring(i);
                if (ign) {
                    this.suffix = this.suffix.toLowerCase();
                }
                this.suffixlen = this.suffix.length();
                return;
            }
            String part = exp.substring(i, pos);
            if (ign) {
                part = part.toLowerCase();
            }
            if (part.equals("")) continue;
            if (this.elements == null) {
                this.elements = new String[1];
            } else {
                String[] tmp = new String[this.elements.length + 1];
                System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
                this.elements = tmp;
            }
            this.elements[this.elements.length - 1] = part;
        } while ((i = pos + 1) < exp.length());
    }

    public String dump() {
        String result = "exact=" + this.exact + " prefix=" + this.prefix + " suffix=" + this.suffix + "  elements=";
        if (this.elements == null) {
            result = result + "null";
            return result;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            result = result + this.elements[i] + ",";
        }
        return result;
    }

    public final String toString() {
        if (this.exact) {
            return this.prefix;
        }
        String result = this.prefix == null ? "*" : this.prefix + "*";
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                result = result + this.elements[i] + "*";
            }
        }
        if (this.suffix != null) {
            result = result + this.suffix;
        }
        return result;
    }

    public final boolean matches(String str) {
        int pos = 0;
        if (this.ignoreCase) {
            str = str.toLowerCase();
        }
        if (this.exact) {
            return str.equals(this.prefix);
        }
        if (this.prefix != null) {
            if (!str.startsWith(this.prefix)) {
                return false;
            }
            pos = this.prefixlen;
        }
        if (this.elements != null) {
            int j = this.elements.length;
            for (int i = 0; i < j; ++i) {
                if ((pos = str.indexOf(this.elements[i], pos)) == -1) {
                    return false;
                }
                pos += this.elements[i].length();
            }
        }
        if (this.suffix == null) {
            return true;
        }
        if (str.length() - pos < this.suffixlen) {
            return false;
        }
        return str.endsWith(this.suffix);
    }

    public final String[] search(String str) {
        int pos = 0;
        int rsize = 1;
        int rpos = 0;
        String origstr = str;
        if (this.ignoreCase) {
            str = str.toLowerCase();
        }
        if (this.exact) {
            if (str.equals(this.prefix)) {
                return new String[0];
            }
            return null;
        }
        if (this.prefix != null) {
            if (!str.startsWith(this.prefix)) {
                return null;
            }
            pos = this.prefixlen;
        }
        if (this.elements != null) {
            rsize += this.elements.length;
        }
        String[] result = new String[rsize];
        if (this.elements != null) {
            int j = this.elements.length;
            for (int i = 0; i < j; ++i) {
                int npos = str.indexOf(this.elements[i], pos);
                if (npos == -1) {
                    return null;
                }
                result[rpos++] = origstr.substring(pos, npos);
                pos = npos + this.elements[i].length();
            }
        }
        if (this.suffix == null) {
            result[rpos] = origstr.substring(pos);
            return result;
        }
        if (str.length() - pos < this.suffixlen) {
            return null;
        }
        if (!str.endsWith(this.suffix)) {
            return null;
        }
        result[rpos] = origstr.substring(pos, str.length() - this.suffixlen);
        return result;
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            return;
        }
        regexp r = new regexp(argv[0], false);
        System.out.println("Regexp: " + r + " compiled: " + r.dump());
        System.out.println("Matches: " + argv[1] + " : " + r.matches(argv[1]));
        String[] res = r.search(argv[1]);
        System.out.println("Search: " + argv[1] + " : " + res);
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                System.out.println("  Substring[" + i + "] = " + res[i]);
            }
        }
    }
}

