/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fsp.fsplib;

import java.io.IOException;
import java.io.InputStream;
import net.sf.fsp.fsplib.FSPpacket;
import net.sf.fsp.fsplib.FSPsession;
import net.sf.fsp.fsplib.FSPutil;

public class FSPInputStream
extends InputStream {
    private long mark = 0L;
    private long pos = 0L;
    private byte[] buf = new byte[1024];
    private int bufpos = 1024;
    private boolean eof = false;
    private FSPsession ses;
    private byte[] fname;

    public FSPInputStream(FSPsession session, String filename) {
        this.ses = session;
        this.fname = FSPutil.stringToASCIIZ(filename);
    }

    public int available() {
        return 1024 - this.bufpos;
    }

    public void close() {
        this.eof = true;
        this.buf = null;
        this.ses = null;
        this.bufpos = 1024;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos - (long)(1024 - this.bufpos);
    }

    public synchronized void reset() {
        this.bufpos = 1024;
        this.pos = this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.bufpos < 1024) {
            return this.buf[this.bufpos++] & 0xFF;
        }
        this.fillbuffer();
        return this.read();
    }

    private void fillbuffer() throws IOException {
        FSPpacket pkt = this.ses.interact((byte)66, this.pos, this.fname, 0, this.fname.length, null, 0, 0);
        pkt.expect((byte)66);
        if (pkt.bb_len == 0) {
            this.eof = true;
        }
        this.bufpos = 1024 - pkt.bb_len;
        this.pos += (long)pkt.bb_len;
        System.arraycopy(pkt.buf, 0, this.buf, this.bufpos, pkt.bb_len);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.bufpos >= 1024) {
            this.fillbuffer();
        }
        int read = Math.min(len, 1024 - this.bufpos);
        System.arraycopy(this.buf, this.bufpos, b, off, read);
        this.bufpos += read;
        return read;
    }

    public long skip(long bytes) throws IOException {
        if (this.eof) {
            return 0L;
        }
        this.pos = this.pos - (long)(1024 - this.bufpos) + bytes;
        this.bufpos = 1024;
        return bytes;
    }
}

