/*
 * $Id$
 *
 * Examples for KEIL MCB 900.
 *
 * @author Mario Viara
 * @version 1.00
 *
 * @since 1.04
 */
#include <p89lpc932.h>


#define	CCLK	7373000L
#define MCLK	2
#define	PCLK	(CCLK/MCLK)
#define	TICK_MS	1

#define	T0MS		(PCLK/1000)

#define	T0RELOAD	(0x10000L - (T0MS)/TICK_MS + 40)
#define	T0RELOADL	(T0RELOAD & 0xff)
#define	T0RELOADH	(T0RELOAD >> 8)

unsigned char timer8;
unsigned short timer16;

void InterruptTimer(void) __interrupt(1) 
{
	TR0	= 0;
	TH0	= T0RELOADH;
	TL0	= T0RELOADL;
	TR0	= 1;

	if (timer8)
		timer8--;
	if (timer16)
		timer16--;

}

void IOInit()
{
	// P2
	P3M1 &= ~(0xFF);
	P3M2 |= (0xFF);
}

void TimerInit()
{
	// Timer 0 mode1, timer 1 mode 1
	TR0	= 0;
	TMOD	= 0x11;
	TH0	= T0RELOADH;
	TL0	= T0RELOADL;
	TF0	= 0;
	ET0	= 1;
	TR0	= 1;

}



void main()
{
	unsigned char mask = 0;
	IEN0 = 0;
	IEN1 = 0;

	TimerInit();
	IOInit();

	EA = 1;

	for (;;)
	{
		if (!timer16)
		{
			timer16 = 1000;
			mask <<= 1;
			if (!mask)
				mask = 0x01;
			P2 = mask;
		}

	}
}
