/*
 * Decompiled with CFR 0.152.
 */
package j51.util;

public class FastArray<E> {
    private int growSize;
    private Object[] objects;
    private int currentSize;

    public FastArray(int n, int n2) {
        this.objects = new Object[n];
        this.currentSize = 0;
        this.growSize = n2;
    }

    public FastArray(int n) {
        this(n, 10);
    }

    public FastArray() {
        this(0);
    }

    public final void setGrowSize(int n) {
        this.growSize = n;
    }

    public final int getGrowSize() {
        return this.growSize;
    }

    public final int size() {
        return this.currentSize;
    }

    private final void checkSize() {
        if (this.currentSize >= this.objects.length) {
            Object[] objectArray = new Object[this.objects.length + this.growSize];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            this.objects = objectArray;
        }
    }

    public final void clear() {
        this.currentSize = 0;
    }

    public final void add(E e) {
        this.checkSize();
        this.objects[this.currentSize++] = e;
    }

    public final void add(int n, Object object) {
        this.checkSize();
        System.arraycopy(this.objects, n, this.objects, n + 1, this.currentSize - n);
        this.objects[n] = object;
        ++this.currentSize;
    }

    public final int indexOf(Object object) {
        int n = this.currentSize;
        while (--n >= 0) {
            if (this.objects[n] != object) continue;
            return n;
        }
        return -1;
    }

    public final void remove(int n) {
        if (n < this.currentSize && n >= 0) {
            this.objects[n] = null;
            int n2 = this.currentSize - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.objects, n + 1, this.objects, n, n2);
            }
            --this.currentSize;
        }
    }

    public final void remove(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.remove(n);
        }
    }

    public final void set(int n, E e) {
        this.objects[n] = e;
    }

    public final E get(int n) {
        return (E)this.objects[n];
    }

    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }
}

