/*
 * Decompiled with CFR 0.152.
 */
package j51.swing;

import j51.swing.JFactory;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class JFixedField
extends JTextField
implements FocusListener {
    protected int len;
    private boolean selected = false;

    public JFixedField(int n) {
        this(n, false);
    }

    public JFixedField(int n, boolean bl) {
        this.len = n;
        Font font = this.getFont();
        int n2 = font.getStyle();
        if (bl) {
            n2 = 1;
        }
        font = new Font("Monospaced", n2, font.getSize());
        this.setEditable(false);
        this.setFont(font);
        this.setSelected(false);
        this.setText("");
        this.addFocusListener(this);
    }

    @Override
    public void setText(String string) {
        while (string.length() < this.len) {
            if (this.getHorizontalAlignment() == 4) {
                string = " " + string;
                continue;
            }
            string = string + " ";
        }
        string = string.substring(0, this.len);
        String string2 = this.getText();
        if (string2 == null) {
            string2 = "";
        }
        if (!string.equals(string2)) {
            super.setText(string);
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.setForeground(bl ? JFactory.getColorSelected() : JFactory.getColorNormal());
    }

    public boolean getSelected() {
        return this.selected;
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.setFocusable(bl);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.isEditable() && this.isEnabled()) {
            this.selectAll();
        }
    }
}

