/*
 * Decompiled with CFR 0.152.
 */
package j51.philips;

import j51.intel.AbstractInterruptSource;
import j51.intel.AsyncTimerListener;
import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.ResetListener;
import j51.intel.SfrWriteListener;
import j51.philips.LPC900;
import j51.philips.LPC900Constants;

public class LPC900WDT
extends AbstractInterruptSource
implements MCS51Peripheral,
LPC900Constants,
ResetListener,
SfrWriteListener,
AsyncTimerListener {
    private int wdl;
    private LPC900 cpu;
    private boolean running = false;
    private boolean feed = false;
    private int wdClock;

    public LPC900WDT() {
        super(83);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = (LPC900)mCS51;
        this.cpu.setSfrName(167, "WDCON");
        this.cpu.setSfrName(194, "WDFEED1");
        this.cpu.setSfrName(195, "WDFEED2");
        this.cpu.setSfrName(193, "WDL");
        this.cpu.addSfrWriteListener(167, this);
        this.cpu.addSfrWriteListener(194, this);
        this.cpu.addSfrWriteListener(195, this);
        this.cpu.addInterruptSource(168, this);
        this.cpu.addInterruptSource(167, this);
        this.cpu.addResetListener(this);
    }

    @Override
    public void reset(MCS51 mCS51) {
        this.feed = false;
        this.running = false;
        this.cpu.sfr(193, 255);
        this.cpu.sfr(167, 231);
        this.wdl = 255;
        this.sfrWrite(167, 231);
    }

    @Override
    public void sfrWrite(int n, int n2) {
        switch (n) {
            case 194: {
                if (n2 == 165) {
                    this.feed = true;
                    break;
                }
                this.feed = false;
                break;
            }
            case 195: {
                if (n2 == 90 && this.feed) {
                    this.cpu.sfrReset(167, 2);
                    this.wdl = this.cpu.sfr(193);
                }
                this.feed = false;
                break;
            }
            case 167: {
                if ((this.cpu.miscRead(0) & 0x90) == 144) {
                    this.cpu.sfr(167, n2 |= 5);
                }
                this.wdClock = (n2 &= 0xFF) >> 5;
                this.wdClock = 32 << this.wdClock;
                this.addTimer();
            }
        }
    }

    @Override
    public boolean interruptCondition() {
        return (this.cpu.sfr(168) & 0x40) != 0 && (this.cpu.sfr(167) & 2) != 0;
    }

    private void addTimer() {
        int n = 0;
        if (this.running) {
            return;
        }
        if ((this.cpu.sfr(167) & 4) == 0) {
            return;
        }
        this.running = true;
        if ((this.cpu.sfr(167) & 1) != 0) {
            n = this.cpu.getOscillator() / 400000;
            n /= this.cpu.machineCycle();
        } else {
            n = 1;
        }
        this.cpu.addAsyncTimerListener(n *= this.wdClock, this);
    }

    @Override
    public void expired(MCS51 mCS51) throws Exception {
        this.running = false;
        this.wdl = this.wdl - 1 & 0xFF;
        if (this.wdl == 0) {
            this.cpu.sfrSet(167, 2);
            this.wdl = this.cpu.sfr(193);
            if ((this.cpu.miscRead(0) & 0x80) == 128) {
                throw new Exception("Watch Dog reset");
            }
        }
        this.addTimer();
    }
}

