/*
 * Decompiled with CFR 0.152.
 */
package j51.atmel;

import j51.i2c.I2cSlave;
import j51.intel.PersistentMemory;
import j51.util.Hex;
import j51.util.Logger;

public class Atmel24C16
extends PersistentMemory
implements I2cSlave {
    private static Logger log = Logger.getLogger(Atmel24C16.class);
    private int address;

    public Atmel24C16() {
        super("AT24C16", "eeprom", 2048);
    }

    @Override
    public boolean i2cAddress(int n) {
        return (n & 0xF0) == 160;
    }

    @Override
    public boolean i2cWrite(int n, int n2) {
        switch (n) {
            default: {
                log.fine("Write " + Hex.bin2byte(n2) + " at " + Hex.bin2word(this.address));
                this.write(this.address++, n2);
                break;
            }
            case 0: {
                this.address = (n2 >> 1 & 7) * 256 | this.address & 0xFF;
                break;
            }
            case 1: {
                this.address = this.address & 0xFF00 | n2;
            }
        }
        return true;
    }

    @Override
    public int i2cRead(int n) {
        int n2 = this.read(this.address);
        log.fine("Read " + Hex.bin2byte(n2) + " at " + Hex.bin2word(this.address));
        ++this.address;
        return n2;
    }
}

