/*
 * Decompiled with CFR 0.152.
 */
package de.mud.terminal;

import de.mud.terminal.SoftFont;
import de.mud.terminal.VDUBuffer;
import de.mud.terminal.VDUDisplay;
import de.mud.terminal.VDUInput;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollBar;

public class SwingTerminal
extends Component
implements VDUDisplay,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final int debug = 0;
    private VDUBuffer buffer;
    private static final long VDU_EVENTS = 188L;
    private Insets insets;
    private boolean raised;
    private Font normalFont;
    private FontMetrics fm;
    private int charWidth;
    private int charHeight;
    private int charDescent;
    private int resizeStrategy;
    private Point selectBegin;
    private Point selectEnd;
    private String selection;
    private JScrollBar scrollBar;
    private SoftFont sf = new SoftFont();
    private boolean colorPrinting = false;
    private Image backingStore = null;
    private Color[] color = new Color[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white, null, null};
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_FONT = 1;
    public static final int RESIZE_SCREEN = 2;
    public static final int COLOR_BOLD = 8;
    public static final int COLOR_INVERT = 9;
    private static final int COLOR_FG_STD = 0;
    private static final int COLOR_BG_STD = 7;
    private Color cursorColorFG = null;
    private Color cursorColorBG = null;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private KeyListener keyListener;
    FocusListener focusListener;

    private Color brighten(Color color) {
        int n = (int)this.min((double)color.getRed() * 1.2, 255.0);
        int n2 = (int)this.min((double)color.getGreen() * 1.2, 255.0);
        int n3 = (int)this.min((double)color.getBlue() * 1.2, 255.0);
        return new Color(n, n2, n3);
    }

    private Color darken(Color color) {
        int n = (int)this.max((double)color.getRed() * 0.8, 0.0);
        int n2 = (int)this.max((double)color.getGreen() * 0.8, 0.0);
        int n3 = (int)this.max((double)color.getBlue() * 0.8, 0.0);
        return new Color(n, n2, n3);
    }

    protected double max(double d, double d2) {
        return d < d2 ? d2 : d;
    }

    protected double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public SwingTerminal(VDUBuffer vDUBuffer, Font font) {
        this.setVDUBuffer(vDUBuffer);
        this.addKeyListener(this);
        String string = System.getProperty("java.version");
        String string2 = string.substring(0, 3);
        double d = Double.parseDouble(string2);
        if (d >= 1.4) {
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                SwingTerminal.class.getMethod("setFocusable", classArray).invoke((Object)this, new Boolean(true));
                SwingTerminal.class.getMethod("setFocusTraversalKeysEnabled", classArray).invoke((Object)this, new Boolean(false));
            }
            catch (Exception exception) {
                System.err.println("vt320: unable to reset focus handling for java version " + string);
                exception.printStackTrace();
            }
        }
        this.enableEvents(188L);
        this.setFont(font);
        this.setResizeStrategy(1);
        this.setForeground(Color.green);
        this.setBackground(Color.black);
        this.cursorColorFG = Color.green;
        this.cursorColorBG = Color.black;
        this.clearSelection();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.selection = null;
    }

    public SwingTerminal(VDUBuffer vDUBuffer) {
        this(vDUBuffer, new Font("Monospaced", 0, 11));
    }

    @Override
    public void setVDUBuffer(VDUBuffer vDUBuffer) {
        this.buffer = vDUBuffer;
        vDUBuffer.setDisplay(this);
    }

    @Override
    public VDUBuffer getVDUBuffer() {
        return this.buffer;
    }

    public void setColorSet(Color[] colorArray) {
        System.arraycopy(colorArray, 0, this.color, 0, 10);
        this.buffer.update[0] = true;
        this.redraw();
    }

    public Color[] getColorSet() {
        return this.color;
    }

    @Override
    public void setFont(Font font) {
        this.normalFont = font;
        super.setFont(this.normalFont);
        this.fm = this.getFontMetrics(font);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
            this.charDescent = this.fm.getDescent();
        }
        if (this.buffer.update != null) {
            this.buffer.update[0] = true;
        }
        this.redraw();
    }

    public void setResizeStrategy(int n) {
        this.resizeStrategy = n;
    }

    public void setBorder(int n, boolean bl) {
        this.insets = n == 0 ? null : new Insets(n + 1, n + 1, n + 1, n + 1);
        this.raised = bl;
    }

    public void setScrollbar(JScrollBar jScrollBar) {
        if (jScrollBar == null) {
            return;
        }
        this.scrollBar = jScrollBar;
        this.scrollBar.setValues(this.buffer.windowBase, this.buffer.height, 0, this.buffer.bufSize - this.buffer.height);
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SwingTerminal.this.buffer.setWindowBase(adjustmentEvent.getValue());
            }
        });
    }

    @Override
    public void redraw() {
        if (this.backingStore != null) {
            this.redraw(this.backingStore.getGraphics());
            this.repaint();
        }
    }

    @Override
    public void updateScrollBar() {
        if (this.scrollBar == null) {
            return;
        }
        this.scrollBar.setValues(this.buffer.windowBase, this.buffer.height, 0, this.buffer.bufSize);
    }

    protected void redraw(Graphics graphics) {
        int n;
        int n2 = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n3 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        int n4 = this.selectBegin.y - this.buffer.windowBase;
        int n5 = this.selectEnd.y - this.buffer.windowBase;
        Color color = this.darken(this.color[0]);
        Color color2 = this.darken(this.color[7]);
        graphics.setFont(this.normalFont);
        for (n = 0; n < this.buffer.height; ++n) {
            int n6;
            int n7;
            if (!this.buffer.update[0] && !this.buffer.update[n + 1]) continue;
            this.buffer.update[n + 1] = false;
            for (n7 = 0; n7 < this.buffer.width; ++n7) {
                n6 = 0;
                int n8 = this.buffer.charAttributes[this.buffer.windowBase + n][n7];
                color = this.darken(this.getForeground());
                color2 = this.darken(this.getBackground());
                if ((n8 & 0x1E0) != 0) {
                    color = this.darken(this.color[((n8 & 0x1E0) >> 5) - 1]);
                }
                if ((n8 & 0x1E00) != 0) {
                    color2 = this.darken(this.darken(this.color[((n8 & 0x1E00) >> 9) - 1]));
                }
                if ((n8 & 1) != 0) {
                    graphics.setFont(new Font(this.normalFont.getName(), 1, this.normalFont.getSize()));
                    if (null != this.color[8]) {
                        color = this.color[8];
                    }
                } else {
                    graphics.setFont(this.normalFont);
                }
                if ((n8 & 8) != 0) {
                    color = this.darken(color);
                }
                if ((n8 & 4) != 0) {
                    if (null == this.color[9]) {
                        Color color3 = color2;
                        color2 = color;
                        color = color3;
                    } else {
                        color = null == this.color[8] ? color2 : this.color[8];
                        color2 = this.color[9];
                    }
                }
                if (this.sf.inSoftFont(this.buffer.charArray[this.buffer.windowBase + n][n7])) {
                    graphics.setColor(color2);
                    graphics.fillRect(n7 * this.charWidth + n2, n * this.charHeight + n3, this.charWidth, this.charHeight);
                    graphics.setColor(color);
                    if ((n8 & 0x10) == 0) {
                        this.sf.drawChar(graphics, this.buffer.charArray[this.buffer.windowBase + n][n7], n2 + n7 * this.charWidth, n * this.charHeight + n3, this.charWidth, this.charHeight);
                    }
                    if ((n8 & 2) == 0) continue;
                    graphics.drawLine(n7 * this.charWidth + n2, (n + 1) * this.charHeight - this.charDescent / 2 + n3, n7 * this.charWidth + this.charWidth + n2, (n + 1) * this.charHeight - this.charDescent / 2 + n3);
                    continue;
                }
                while (!(n7 + n6 >= this.buffer.width || this.buffer.charArray[this.buffer.windowBase + n][n7 + n6] >= ' ' && this.buffer.charAttributes[this.buffer.windowBase + n][n7 + n6] != n8 || this.sf.inSoftFont(this.buffer.charArray[this.buffer.windowBase + n][n7 + n6]))) {
                    if (this.buffer.charArray[this.buffer.windowBase + n][n7 + n6] < ' ') {
                        this.buffer.charArray[this.buffer.windowBase + n][n7 + n6] = 32;
                        this.buffer.charAttributes[this.buffer.windowBase + n][n7 + n6] = 0;
                        continue;
                    }
                    ++n6;
                }
                graphics.setColor(color2);
                graphics.fillRect(n7 * this.charWidth + n2, n * this.charHeight + n3, n6 * this.charWidth, this.charHeight);
                graphics.setColor(color);
                if ((n8 & 0x10) == 0) {
                    graphics.drawChars(this.buffer.charArray[this.buffer.windowBase + n], n7, n6, n7 * this.charWidth + n2, (n + 1) * this.charHeight - this.charDescent + n3);
                }
                if ((n8 & 2) != 0) {
                    graphics.drawLine(n7 * this.charWidth + n2, (n + 1) * this.charHeight - this.charDescent / 2 + n3, n7 * this.charWidth + n6 * this.charWidth + n2, (n + 1) * this.charHeight - this.charDescent / 2 + n3);
                }
                n7 += n6 - 1;
            }
            if (n < n4 || n > n5) continue;
            int n9 = n7 = n == n4 ? this.selectBegin.x : 0;
            int n10 = n == n5 ? (n == n4 ? this.selectEnd.x - n7 : this.selectEnd.x) : (n6 = this.buffer.width);
            if (n7 == n6) continue;
            graphics.setXORMode(color2);
            graphics.fillRect(n7 * this.charWidth + n2, n * this.charHeight + n3, n6 * this.charWidth, this.charHeight);
            graphics.setPaintMode();
        }
        if (this.buffer.showcursor && this.buffer.screenBase + this.buffer.cursorY >= this.buffer.windowBase && this.buffer.screenBase + this.buffer.cursorY < this.buffer.windowBase + this.buffer.height) {
            graphics.setColor(this.cursorColorFG);
            graphics.setXORMode(this.cursorColorBG);
            graphics.fillRect(this.buffer.cursorX * this.charWidth + n2, (this.buffer.cursorY + this.buffer.screenBase - this.buffer.windowBase) * this.charHeight + n3, this.charWidth, this.charHeight);
            graphics.setPaintMode();
            graphics.setColor(this.color[0]);
        }
        if (this.insets != null) {
            graphics.setColor(this.getBackground());
            --n2;
            --n3;
            for (n = this.insets.top - 1; n >= 0; --n) {
                graphics.draw3DRect(n2 - n, n3 - n, this.charWidth * this.buffer.width + 1 + n * 2, this.charHeight * this.buffer.height + 1 + n * 2, this.raised);
            }
        }
        this.buffer.update[0] = false;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.backingStore == null) {
            Dimension dimension = super.getSize();
            this.backingStore = this.createImage(dimension.width, dimension.height);
            this.buffer.update[0] = true;
            this.redraw();
        }
        graphics.drawImage(this.backingStore, 0, 0, this);
    }

    public void setColorPrinting(boolean bl) {
        this.colorPrinting = bl;
    }

    @Override
    public void print(Graphics graphics) {
        for (int i = 0; i <= this.buffer.height; ++i) {
            this.buffer.update[i] = true;
        }
        Color color = null;
        Color color2 = null;
        Color[] colorArray = null;
        if (!this.colorPrinting) {
            color = this.getForeground();
            color2 = this.getBackground();
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            colorArray = this.color;
            this.color = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.white, null, null};
        }
        this.redraw(graphics);
        if (!this.colorPrinting) {
            this.color = colorArray;
            this.setForeground(color);
            this.setBackground(color2);
        }
    }

    public Point mouseGetPos(Point point) {
        Point point2 = new Point(0, 0);
        int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        point2.x = (point.x - n) / this.charWidth;
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.x >= this.buffer.width) {
            point2.x = this.buffer.width - 1;
        }
        point2.y = (point.y - n2) / this.charHeight;
        if (point2.y < 0) {
            point2.y = 0;
        }
        if (point2.y >= this.buffer.height) {
            point2.y = this.buffer.height - 1;
        }
        return point2;
    }

    public void setCursorColors(Color color, Color color2) {
        this.cursorColorFG = color == null ? this.color[0] : color;
        this.cursorColorBG = color2 == null ? this.color[7] : color2;
        this.repaint();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        if (this.insets != null) {
            n3 -= this.insets.left + this.insets.right;
            n4 -= this.insets.top + this.insets.bottom;
        }
        Font font = this.normalFont;
        String string = font.getName();
        int n5 = font.getStyle();
        this.fm = this.getFontMetrics(this.normalFont);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
        }
        switch (this.resizeStrategy) {
            case 2: {
                this.buffer.height = n4 / this.charHeight;
                this.buffer.setScreenSize(n3 / this.charWidth, this.buffer.height, true);
                break;
            }
            case 1: {
                int n6 = n4 / this.buffer.height;
                int n7 = n3 / this.buffer.width;
                this.normalFont = new Font(string, n5, this.charHeight);
                this.fm = this.getFontMetrics(this.normalFont);
                if (this.fm.getHeight() < n6 || this.fm.charWidth('@') < n7) {
                    do {
                        this.normalFont = new Font(string, n5, ++this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.fm.getHeight() < n6 || this.fm.charWidth('@') < n7);
                }
                if (this.fm.getHeight() > n6 || this.fm.charWidth('@') > n7) {
                    do {
                        this.normalFont = new Font(string, n5, --this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.charHeight > 1 && (this.fm.getHeight() > n6 || this.fm.charWidth('@') > n7));
                }
                if (this.charHeight <= 1) {
                    System.err.println("VDU: error during resize, resetting");
                    this.normalFont = font;
                    System.err.println("VDU: disabling font/screen resize");
                    this.resizeStrategy = 0;
                }
                this.setFont(this.normalFont);
                this.fm = this.getFontMetrics(this.normalFont);
                this.charWidth = this.fm.charWidth('@');
                this.charHeight = this.fm.getHeight();
                this.charDescent = this.fm.getDescent();
                break;
            }
        }
        this.backingStore = null;
        this.buffer.markLine(0, this.buffer.height);
    }

    @Override
    public Dimension getSize() {
        int n = 0;
        int n2 = 0;
        if (this.insets != null) {
            n = this.insets.left + this.insets.right;
            n2 = this.insets.top + this.insets.bottom;
        }
        return new Dimension(this.buffer.width * this.charWidth + n, this.buffer.height * this.charHeight + n2);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void clearSelection() {
        this.selectBegin = new Point(0, 0);
        this.selectEnd = new Point(0, 0);
        this.selection = null;
    }

    public String getSelection() {
        return this.selection;
    }

    private boolean buttonCheck(int n, int n2) {
        return (n & n2) == n2;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.buttonCheck(mouseEvent.getModifiers(), 16) || mouseEvent.getModifiers() == 0) {
            int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
            int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
            int n3 = (mouseEvent.getX() - n) / this.charWidth;
            int n4 = (mouseEvent.getY() - n2) / this.charHeight + this.buffer.windowBase;
            int n5 = this.selectEnd.x;
            int n6 = this.selectEnd.y;
            if (n3 <= this.selectBegin.x && n4 <= this.selectBegin.y) {
                this.selectBegin.x = n3;
                this.selectBegin.y = n4;
            } else {
                this.selectEnd.x = n3;
                this.selectEnd.y = n4;
            }
            if (n5 != n3 || n6 != n4) {
                this.buffer.update[0] = true;
                this.redraw();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        if (this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).mousePressed(n, n2, mouseEvent.getModifiers());
        }
        if (this.buttonCheck(mouseEvent.getModifiers(), 16)) {
            this.selectBegin.x = (mouseEvent.getX() - n) / this.charWidth;
            this.selectBegin.y = (mouseEvent.getY() - n2) / this.charHeight + this.buffer.windowBase;
            this.selectEnd.x = this.selectBegin.x;
            this.selectEnd.y = this.selectBegin.y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = (super.getSize().width - this.buffer.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.buffer.height * this.charHeight) / 2;
        if (this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).mousePressed(n, n2, mouseEvent.getModifiers());
        }
        if (this.buttonCheck(mouseEvent.getModifiers(), 16)) {
            this.mouseDragged(mouseEvent);
            if (this.selectBegin.x == this.selectEnd.x && this.selectBegin.y == this.selectEnd.y) {
                this.buffer.update[0] = true;
                this.redraw();
                return;
            }
            this.selection = "";
            if (this.selectEnd.x < 0) {
                this.selectEnd.x = 0;
            }
            if (this.selectEnd.y < 0) {
                this.selectEnd.y = 0;
            }
            if (this.selectEnd.y >= this.buffer.charArray.length) {
                this.selectEnd.y = this.buffer.charArray.length - 1;
            }
            if (this.selectEnd.x > this.buffer.charArray[0].length) {
                this.selectEnd.x = this.buffer.charArray[0].length;
            }
            StringBuffer stringBuffer = new StringBuffer(this.buffer.charArray[0].length * (this.selectEnd.y - this.selectBegin.y + 1));
            for (int i = this.selectBegin.y; i <= this.selectEnd.y; ++i) {
                int n3;
                int n4;
                n4 = i == this.selectBegin.y ? (n4 = this.selectBegin.x) : 0;
                n3 = i == this.selectEnd.y ? (n3 = this.selectEnd.x) : this.buffer.charArray[i].length;
                boolean bl = false;
                char c = ' ';
                for (int j = n4; j < n3; ++j) {
                    c = (this.buffer.charAttributes[i][j] & 0x10) != 0 ? (char)' ' : this.buffer.charArray[i][j];
                    if (c == '\n') {
                        bl = true;
                    }
                    stringBuffer.append(c);
                }
                if (!bl) {
                    stringBuffer.append('\n');
                }
                this.selection = this.selection + ("-" + stringBuffer.toString()).trim().substring(1);
                if (n3 != this.buffer.charArray[i].length) continue;
                this.selection = this.selection + "\n";
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.buffer != null && this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).keyTyped(keyEvent.getKeyCode(), keyEvent.getKeyChar(), this.getModifiers(keyEvent));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.buffer != null && this.buffer instanceof VDUInput) {
            ((VDUInput)((Object)this.buffer)).keyPressed(keyEvent.getKeyCode(), keyEvent.getKeyChar(), this.getModifiers(keyEvent));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.enableEvents(16L);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.enableEvents(16L);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this.mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 501: {
                    this.mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(mouseEvent);
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener != null) {
            switch (mouseEvent.getID()) {
                case 506: {
                    this.mouseMotionListener.mouseDragged(mouseEvent);
                    break;
                }
                case 503: {
                    this.mouseMotionListener.mouseMoved(mouseEvent);
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.enableEvents(8L);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            switch (keyEvent.getID()) {
                case 401: {
                    this.keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    this.keyListener.keyTyped(keyEvent);
                }
            }
        }
        if (keyEvent.getKeyCode() == 9 && keyEvent.getSource() == this) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener != null) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(focusEvent);
                }
            }
        }
        super.processFocusEvent(focusEvent);
    }

    private int getModifiers(KeyEvent keyEvent) {
        return (keyEvent.isControlDown() ? 1 : 0) | (keyEvent.isShiftDown() ? 2 : 0) | (keyEvent.isAltDown() ? 4 : 0) | (keyEvent.isActionKey() ? 8 : 0);
    }
}

