/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private int duration;

    public SplashScreen(int d) {
        this.setAlwaysOnTop(true);
        this.duration = d;
        this.showSplashAndExit();
    }

    public void showSplash() {
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Color.white);
        int width = 300;
        int height = 50;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        JLabel label = new JLabel("Jubin's 8085 Simulator", 0);
        label.setForeground(new Color(255, 215, 0, 255));
        this.getContentPane().setBackground(Color.BLACK);
        label.setFont(new Font("Tahoma", 1, 21));
        JLabel copyrt = new JLabel("Loading....................................", 0);
        content.add((Component)label, "North");
        Color oraRed = new Color(156, 20, 220, 255);
        content.setBorder(BorderFactory.createLineBorder(oraRed, 10));
        JProgressBar p = new JProgressBar();
        p.setForeground(new Color(156, 210, 220, 255));
        p.setIndeterminate(true);
        p.setVisible(true);
        content.add((Component)p, "After");
        this.setVisible(true);
        try {
            Thread.sleep(this.duration);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
    }

    public void showSplashAndExit() {
        this.showSplash();
        this.dispose();
    }

    public static void main(String[] args) {
        SplashScreen splash = new SplashScreen(1000);
        Assembler.main(args);
    }
}

