/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.pop;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public abstract class MessageDigest {
    public byte[] digestBits;
    public boolean digestValid;

    public abstract void init();

    public abstract void update(byte var1);

    public synchronized void update(boolean aValue) {
        byte b = aValue ? (byte)1 : 0;
        this.update(b);
    }

    public synchronized void update(short aValue) {
        byte b1 = (byte)(aValue >>> 8 & 0xFF);
        byte b2 = (byte)(aValue & 0xFF);
        this.update(b1);
        this.update(b2);
    }

    public synchronized void update(int aValue) {
        int i = 3;
        while (i >= 0) {
            byte b = (byte)(aValue >>> i * 8 & 0xFF);
            this.update(b);
            --i;
        }
    }

    public synchronized void update(long aValue) {
        int i = 7;
        while (i >= 0) {
            byte b = (byte)(aValue >>> i * 8 & 0xFFL);
            this.update(b);
            --i;
        }
    }

    public synchronized void update(byte[] input) {
        int i = 0;
        while (i < input.length) {
            this.update(input[i]);
            ++i;
        }
    }

    public synchronized void update(short[] input) {
        int i = 0;
        while (i < input.length) {
            this.update(input[i]);
            ++i;
        }
    }

    public synchronized void update(int[] input) {
        int i = 0;
        while (i < input.length) {
            this.update(input[i]);
            ++i;
        }
    }

    public synchronized void update(long[] input) {
        int i = 0;
        while (i < input.length) {
            this.update(input[i]);
            ++i;
        }
    }

    public void update(String input) {
        int len = input.length();
        int i = 0;
        while (i < len) {
            short x = (short)input.charAt(i);
            this.update(x);
            ++i;
        }
    }

    public void updateASCII(String input) {
        int len = input.length();
        int i = 0;
        while (i < len) {
            byte x = (byte)(input.charAt(i) & 0xFF);
            this.update(x);
            ++i;
        }
    }

    public abstract void finish();

    public void computeDigest(byte[] source) {
        this.init();
        this.update(source);
        this.finish();
    }

    private void hexDigit(PrintStream p, byte x) {
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        p.write(c);
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        p.write(c);
    }

    public String toString() {
        ByteArrayOutputStream ou = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(ou);
        if (this.digestValid) {
            int i = 0;
            while (i < this.digestBits.length) {
                this.hexDigit(p, this.digestBits[i]);
                ++i;
            }
        } else {
            p.print("<incomplete>");
        }
        return ou.toString();
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        if (digesta.length != digestb.length) {
            return false;
        }
        int i = 0;
        while (i < digesta.length) {
            if (digesta[i] != digestb[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqual(byte[] otherDigest) {
        return MessageDigest.isEqual(this.digestBits, otherDigest);
    }
}

