/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceBoard;
import com.jthomas.javafaces.FaceCache;
import com.jthomas.javafaces.FaceEvent;
import com.jthomas.javafaces.FaceEventListener;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceResolver;
import com.jthomas.javafaces.FaceStatusLabel;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.javafaces.PiconDBServer;
import com.jthomas.util.Debug;
import com.jthomas.util.Queue;
import java.io.IOException;
import java.util.StringTokenizer;

public class PiconDB
implements Runnable {
    private PiconDBServer[] _DBServerList;
    private int _DBServerCount;
    private String[] _PiconDeferList;
    private String[] _PiconIgnoreList;
    private JavaFaces _JavaFaces;
    private FaceOptions _Options;
    private FaceResolver _Resolver;
    private FaceBoard _FaceBoard;
    private FaceCache _Cache;
    private boolean _PIconDBDomainOnly = false;
    private Queue _Queue;

    public PiconDB() {
        Debug.out("PiconDB constructor");
        this._JavaFaces = JavaFaces.getRef();
        this._Options = FaceOptions.getRef();
        this.refreshOptions();
        this._JavaFaces.addFaceEventListener(new 1());
        this._Queue = new Queue();
        String[] list = this._Options.getList("PIconDB");
        if (list.length == 0) {
            Debug.out("No PiconDB Servers found. Use defaults");
            this._DBServerList = new PiconDBServer[1];
            this._DBServerList[0] = new PiconDBServer();
            this._DBServerCount = 1;
        } else {
            this._DBServerCount = list.length;
            this._DBServerList = new PiconDBServer[this._DBServerCount];
            int i = 0;
            while (i < this._DBServerCount) {
                StringTokenizer st = new StringTokenizer(list[i], " ");
                int n = st.countTokens();
                String[] tokens = new String[n];
                int j = 0;
                while (st.hasMoreTokens()) {
                    tokens[j] = st.nextToken().trim();
                    Debug.out(String.valueOf(j) + ": " + tokens[j]);
                    ++j;
                }
                switch (n) {
                    case 2: {
                        this._DBServerList[i] = new PiconDBServer(tokens[0], tokens[1]);
                        break;
                    }
                    case 5: {
                        int port = 0;
                        if (tokens[2].toUpperCase().equals("PROXY")) {
                            try {
                                port = Integer.parseInt(tokens[4]);
                            }
                            catch (Exception exception) {
                                MsgDialog.create("PIconDB option - Proxy port was invalid.");
                            }
                            this._DBServerList[i] = new PiconDBServer(tokens[0], tokens[1], tokens[3], port);
                            break;
                        }
                        MsgDialog.create("PIconDB option - Invalid Proxy statement.");
                        break;
                    }
                    default: {
                        MsgDialog.create("Invalid PIconDB statement: " + list[i]);
                    }
                }
                ++i;
            }
        }
        Debug.out("PiconDB constructor done");
    }

    public void queuePut(Object obj) {
        this._Queue.put(obj);
    }

    public void refreshOptions() {
        this._PIconDBDomainOnly = this._Options.getBoolean("PIconDBDomainOnly", true);
        this._PiconDeferList = this._Options.getList("PiconDefer");
        this._PiconIgnoreList = this._Options.getList("PiconIgnore");
    }

    public PiconDBServer[] getList() {
        return this._DBServerList;
    }

    public int getCount() {
        return this._DBServerCount;
    }

    public void run() {
        Debug.out("PiconDB.run()");
        this._FaceBoard = this._JavaFaces.getFaceBoardRef();
        this._Cache = this._JavaFaces.getCacheRef();
        this._Resolver = this._JavaFaces.getResolverRef();
        block3: while (true) {
            try {
                while (true) {
                    Mailmsg mailmsg = (Mailmsg)this._Queue.get();
                    Debug.out("PiconDB.run() dequeued mailmsg " + mailmsg.getKey());
                    boolean resolved = false;
                    resolved = this.resolvePiconDB(mailmsg, true, this._PIconDBDomainOnly);
                    if (this._JavaFaces._FlagQuitMail) break block3;
                    if (resolved) continue;
                    mailmsg.setAction(6);
                    Debug.out("PiconDB.run() queued mailmsg " + mailmsg.getKey() + " for ResolveAfter");
                    this._Resolver.queuePut(mailmsg);
                }
            }
            catch (Exception e) {
                Debug.out("PiconDB: Exception in run(); ", e);
                continue;
            }
            catch (Throwable e) {
                Debug.out("PiconDB Error", e);
                Debug.assert(false);
                continue;
            }
            break;
        }
    }

    public boolean resolvePiconDB(Mailmsg mailmsg, boolean usecache, boolean domainonly) {
        boolean exceptionflag = false;
        String imageurl = null;
        String from = mailmsg.getHeader("from");
        if (from.length() == 0) {
            Debug.out("Invalid: No From: Header. Cannot use PIconDB");
            return false;
        }
        String[] address = Mailmsg.parseNetworkAddress(from);
        String user = address[0];
        String host = address[1];
        String replyto = mailmsg.getHeader("reply-to");
        if (replyto.length() > 0) {
            address = Mailmsg.parseNetworkAddress(replyto);
            if (!user.equalsIgnoreCase(address[0])) {
                user = String.valueOf(address[0]) + "+" + user;
            }
            if (!host.equalsIgnoreCase(address[1])) {
                host = String.valueOf(address[1]) + "+" + host;
            }
        }
        Debug.out(String.valueOf(user) + " @ " + host);
        if (usecache && this._Cache != null) {
            imageurl = this._Cache.getUser(user, host);
            if (imageurl == null || imageurl.length() == 0) {
                if (domainonly) {
                    imageurl = this._Cache.getHost(host);
                    Debug.out("Cache Found " + imageurl + " for host " + host);
                } else {
                    Debug.out("Cache Found " + imageurl + " for " + user + "@" + host);
                }
            }
            if (imageurl != null && imageurl.length() == 0) {
                return false;
            }
        }
        if (imageurl == null) {
            String searchfor = domainonly ? host : String.valueOf(user) + "@" + host;
            String searchUser = user;
            FaceStatusLabel.setStatus("PiconDB", "Search for " + searchfor);
            if (domainonly) {
                searchUser = "unknown";
            }
            int i = 0;
            while (i < this._DBServerList.length && imageurl == null) {
                try {
                    imageurl = this._DBServerList[i].search(host, searchUser);
                }
                catch (IOException iOException) {
                    exceptionflag = true;
                }
                ++i;
            }
            FaceStatusLabel.clearStatus("PiconDB");
            if (imageurl != null && mailmsg.getAction() == 7) {
                if (this.checkDeferList(imageurl, host)) {
                    Debug.out("checkDeferList returned true for " + imageurl);
                    mailmsg.setPiconImageURL(imageurl);
                    imageurl = null;
                }
                if (this.checkIgnoreList(imageurl, host)) {
                    Debug.out("checkIgnoreList returned true for " + imageurl);
                    imageurl = null;
                }
            }
        }
        if (imageurl != null) {
            this.processURL(mailmsg, imageurl, user, host, usecache);
            return true;
        }
        if (this._Cache != null && !exceptionflag) {
            this._Cache.cacheImage(null, user, host);
        }
        return false;
    }

    private void processURL(Mailmsg mailmsg, String imageurl, String user, String host, boolean usecache) {
        String newurl;
        if (this._Cache == null || imageurl.startsWith("file:")) {
            mailmsg.setImageURL(imageurl);
            Debug.out("Use " + imageurl + " for " + user + "@" + host);
            Debug.out("PiconDB queued mailmsg " + mailmsg.getKey() + " for FaceBoard");
            this._FaceBoard.queuePut(mailmsg);
            return;
        }
        if (usecache && (newurl = this._Cache.getURL(imageurl)) != null) {
            this._Cache.indexImage(newurl, user, host, newurl);
            mailmsg.setImageURL(newurl);
            Debug.out("Use " + imageurl + " for " + user + "@" + host);
            Debug.out("PiconDB queued mailmsg " + mailmsg.getKey() + " for FaceBoard");
            this._FaceBoard.queuePut(mailmsg);
            return;
        }
        String f_imageurl = imageurl;
        String f_user = user;
        String f_host = host;
        Mailmsg f_mailmsg = mailmsg;
        Thread inner = new Thread((Runnable)new 2(f_host, f_imageurl, f_mailmsg, f_user, this), "CacheURLThread");
        inner.start();
    }

    public boolean checkDeferList(String imageurl, String host) {
        if (this._PiconDeferList.length > 0) {
            String urlhost = this.getHostFromPiconURL(imageurl, host);
            if (urlhost == null) {
                return false;
            }
            int i = 0;
            while (i < this._PiconDeferList.length) {
                if (urlhost.equalsIgnoreCase(this._PiconDeferList[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean checkIgnoreList(String imageurl, String host) {
        if (this._PiconIgnoreList.length > 0) {
            String urlhost = this.getHostFromPiconURL(imageurl, host);
            if (urlhost == null) {
                return false;
            }
            int i = 0;
            while (i < this._PiconIgnoreList.length) {
                if (urlhost.equalsIgnoreCase(this._PiconIgnoreList[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String getHostFromPiconURL(String imageurl, String hostInput) {
        Debug.out("getHostFromPiconURL: " + imageurl + " " + hostInput);
        int x = imageurl.indexOf("//");
        int y = imageurl.lastIndexOf("/unknown/");
        String searcharg = "." + hostInput.replace('+', '.');
        if (x > 0 && y > x) {
            String list = imageurl.substring(x + 9, y);
            StringTokenizer t = new StringTokenizer(list, "/");
            int n = t.countTokens();
            String[] tokens = new String[n];
            int i = 0;
            while (i < n) {
                tokens[n - i - 1] = t.nextToken();
                ++i;
            }
            String host = "";
            int i2 = 0;
            while (i2 < n) {
                String check = "." + tokens[i2];
                if (searcharg.indexOf(check) >= 0) {
                    if (host.length() > 0) {
                        host = String.valueOf(host) + ".";
                    }
                    host = String.valueOf(host) + tokens[i2];
                }
                ++i2;
            }
            Debug.out(host);
            return host;
        }
        return null;
    }

    public static void main(String[] args) {
        Debug.setDebugOn(true);
        if (args.length < 2) {
            Debug.out("syntax: java PiconDB hostname userid");
            System.exit(0);
        }
        PiconDBServer db = new PiconDBServer();
        try {
            String url = db.search(args[0], args[1]);
            Debug.out("URL=" + url);
        }
        catch (IOException iOException) {}
        System.exit(0);
    }

    private final class 1
    implements FaceEventListener {
        public void actionPerformed(FaceEvent e) {
            if (e.getID() == 20) {
                PiconDB.this.refreshOptions();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements Runnable {
        private final /* synthetic */ Mailmsg val$f_mailmsg;
        private final /* synthetic */ String val$f_host;
        private final /* synthetic */ String val$f_user;
        private final /* synthetic */ PiconDB this$0;
        private final /* synthetic */ String val$f_imageurl;

        public void run() {
            Debug.out("Cache image: " + this.val$f_imageurl);
            String cacheURL = this.this$0._Cache.cacheImage(this.val$f_imageurl, this.val$f_user, this.val$f_host);
            if (cacheURL != null) {
                this.val$f_mailmsg.setImageURL(cacheURL);
            } else {
                this.val$f_mailmsg.setImageURL(this.val$f_imageurl);
            }
            Debug.out("Use " + cacheURL + " for " + this.val$f_user + "@" + this.val$f_host);
            Debug.out("PiconDB queued mailmsg " + this.val$f_mailmsg.getKey() + " for FaceBoard");
            this.this$0._FaceBoard.queuePut(this.val$f_mailmsg);
        }

        /* synthetic */ 2(String val$f_host, String val$f_imageurl, Mailmsg val$f_mailmsg, String val$f_user, PiconDB this$0) {
            this.val$f_host = val$f_host;
            this.val$f_imageurl = val$f_imageurl;
            this.val$f_mailmsg = val$f_mailmsg;
            this.val$f_user = val$f_user;
            this.this$0 = this$0;
        }
    }
}

