/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.Face;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.MailListEntry;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.util.Debug;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MailList
extends Frame {
    static final int NUMSHOW = 10;
    private MailListEntry[] _MailListEntries;
    private ScrollPane _ScrollPanel;

    private MailList() {
    }

    public MailList(Mailmsg[] mailmsgs) {
        super("List of all Mail");
        this.setup(mailmsgs);
        ((Component)this).setLocation(10, 10);
        this.show();
    }

    public MailList(Face face) {
        super("Mail Contents");
        this.setup(face.getMailmsgs());
        Point p = face.getButton().getLocation();
        ((Component)this).setLocation(p.x + 30, p.y + 30);
        this.show();
    }

    private void setup(Mailmsg[] mailmsgs) {
        this.addWindowListener(new 1());
        Panel main = new Panel();
        main.setBackground(Color.lightGray);
        main.setLayout(new GridLayout(0, 1, 10, 10));
        int num = mailmsgs.length;
        this._MailListEntries = new MailListEntry[num];
        int maxwidth = 0;
        Dimension entrySize = null;
        int i = 0;
        while (i < num) {
            this._MailListEntries[i] = new MailListEntry(mailmsgs[i]);
            entrySize = this._MailListEntries[i].getPreferredSize();
            maxwidth = Math.max(maxwidth, entrySize.width);
            main.add(this._MailListEntries[i]);
            ++i;
        }
        main.setSize(maxwidth, num * entrySize.height);
        int winheight = Math.min(num, 10) * (entrySize.height + 10);
        this._ScrollPanel = new ScrollPane();
        this._ScrollPanel.setSize(maxwidth + 8, winheight);
        this._ScrollPanel.add(main);
        this.add("Center", this._ScrollPanel);
        this.pack();
        Panel bottom = this.setupBottomButtons();
        this.add("South", bottom);
        this.pack();
        this.validate();
    }

    private void deleteChecked() {
        int i = 0;
        while (i < this._MailListEntries.length) {
            if (this._MailListEntries[i].getState()) {
                this._MailListEntries[i].markDeleted();
            }
            ++i;
        }
        JavaFaces.getRef()._FlagWakeup = true;
        JavaFaces.getRef()._FlagCheckMail = true;
    }

    private void deleteAll() {
        int i = 0;
        while (i < this._MailListEntries.length) {
            this._MailListEntries[i].markDeleted();
            ++i;
        }
        JavaFaces.getRef()._FlagWakeup = true;
        JavaFaces.getRef()._FlagCheckMail = true;
    }

    private Panel setupBottomButtons() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 15, 15));
        ((Component)this).setFont(new Font("Dialog", 1, 15));
        Button delete = new Button("Delete Checked Mail");
        panel.add(delete);
        delete.addActionListener(new 2());
        Button deleteAll = new Button("Delete Listed Mail");
        panel.add(deleteAll);
        deleteAll.addActionListener(new 3());
        Button close = new Button("Cancel");
        panel.add(close);
        close.addActionListener(new 4());
        return panel;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            Debug.out("Window Closing Event");
            MailList.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MailList.this.deleteChecked();
            ((Component)MailList.this).setVisible(false);
            MailList.this.dispose();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MailList.this.deleteAll();
            ((Component)MailList.this).setVisible(false);
            MailList.this.dispose();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ((Component)MailList.this).setVisible(false);
            MailList.this.dispose();
        }

        /* synthetic */ 4() {
        }
    }
}

