/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceMailbox;
import com.jthomas.javafaces.FaceMailboxException;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceServer;
import com.jthomas.javafaces.FaceStatusLabel;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.pop.apop;
import com.jthomas.pop.pop3;
import com.jthomas.pop.popStatus;
import com.jthomas.util.Debug;
import com.jthomas.util.Log;
import java.util.StringTokenizer;

public class FaceMailboxPop
extends FaceMailbox {
    private pop3 _PopServer;
    private boolean _Opened = false;
    private int _OldCount;
    private String[] _ListSize;
    private String[] _ListUidl;
    private boolean _TestedCmds;
    private boolean _UidlCmdOK = false;
    private boolean _TopCmdOK = false;

    FaceMailboxPop(FaceServer server) {
        if (this._Options == null) {
            this._Options = FaceOptions.getRef();
        }
        this._Server = server;
        Debug.out(this._Server.toString());
        Debug.out(String.valueOf(this._Type) + " " + this._Host + " " + this._User + " " + (this._Password == null ? "null" : "suppressed"));
    }

    private FaceMailboxPop(String host, String user, String pass) {
        this._Type = "POP3";
        this._Host = host;
        this._User = user;
        this._Password = pass;
    }

    public boolean open() {
        FaceStatusLabel.setStatus("Mailbox", "Contact server " + this._User + "@" + this._Host);
        this._PopServer = this._Type.equals("POP3") ? new pop3(this._Host, this._User, this._Password) : new apop(this._Host, this._User, this._Password);
        popStatus status = this._PopServer.connect();
        if (status.OK()) {
            Debug.out("Connect successfull");
            Debug.out(">>'" + status.Response() + "'");
            status = this._PopServer.login();
            if (!status.OK()) {
                System.out.println("POP3 Login failed: response='" + status.Response() + "'");
                status = this._PopServer.quit();
                this._PopServer.close();
                this._Count = 0;
                return false;
            }
        } else {
            System.out.println("POP3 Connect failed");
            System.out.println(">>'" + status.Response() + "'");
            return false;
        }
        Debug.out("Login sucessfull");
        Debug.out(">>'" + status.Response() + "'");
        FaceStatusLabel.clearStatus("Mailbox");
        this._Count = this._PopServer.get_TotalMsgs();
        Debug.out("FaceMailboxPop has " + this._Count + " messages");
        return true;
    }

    public void read() {
        Debug.out("FaceMailboxPop.read()");
        super.resetMailmsgs();
        if (this._OldCount == this._Count) {
            this.setModified(false);
        } else {
            this.setModified(true);
        }
        this._ListSize = null;
        this.getListUIDL();
        Debug.out("_Count=" + this._Count);
        this.readnew_pop();
        this._OldCount = this._Count;
    }

    public void close() {
        Debug.out("FaceMailboxPop.close()");
        popStatus status = this._PopServer.quit();
    }

    public void terminate() {
        Debug.out("FaceMailboxPop.terminate()");
    }

    private void readnew_pop() {
        String uidl = "";
        int i = 0;
        while (i < this._Count) {
            if (JavaFaces.getRef()._FlagQuitMail) {
                return;
            }
            String key = this._ListUidl[i];
            if (key.equals("")) {
                Debug.out("Ignore invalid message");
            } else {
                Mailmsg msg = super.getMailmsg(key);
                if (msg != null) {
                    msg.setServerStatus(1);
                    Debug.out("Msg " + (i + 1) + " key=" + key + " already processed");
                } else {
                    FaceStatusLabel.setStatus("Mailbox", "Check message " + (i + 1) + " of " + this._Count);
                    if (this._ListSize == null) {
                        this.getListSize();
                    }
                    msg = new Mailmsg(i + 1);
                    msg.setSize(Integer.parseInt(this._ListSize[i]));
                    if (this._UidlCmdOK) {
                        uidl = this._ListUidl[i];
                        msg.setUidl(uidl);
                    }
                    msg.setServerStatus(2);
                    String[] tops = null;
                    popStatus status = this._PopServer.top(i + 1, 1);
                    if (!status.OK()) {
                        Debug.out("TOP: response='" + status.Response() + "'");
                        MsgDialog.create("Error while reading Mail Header information");
                        return;
                    }
                    tops = status.Responses();
                    this._TopCmdOK = true;
                    msg.setHeaderLines(tops);
                    key = msg.getKey();
                    Debug.out("Msg " + i + " size=" + msg.getSize() + " uidl=" + msg.getKey() + " key=" + key);
                    Mailmsg oldMsg = super.getMailmsg(key);
                    if (oldMsg != null) {
                        oldMsg.setServerStatus(1);
                        Debug.out("Msg " + (i + 1) + " key=" + key + " already processed");
                    } else {
                        Debug.out("New msg=" + key);
                        this.setModified(true);
                        super.addMailmsg(key, msg);
                    }
                }
            }
            ++i;
        }
    }

    public boolean delete(Mailmsg[] mailmsgs) throws FaceMailboxException {
        boolean deleted = false;
        if (mailmsgs != null) {
            int i = 0;
            while (i < mailmsgs.length) {
                if (mailmsgs[i].getDeleteFlag()) {
                    int delnum = 0;
                    if (this._UidlCmdOK) {
                        String uidl = mailmsgs[i].getKey();
                        int j = 0;
                        while (j < this._ListUidl.length) {
                            if (this._ListUidl[j].equals(uidl)) {
                                delnum = j + 1;
                                break;
                            }
                            ++j;
                        }
                    } else {
                        delnum = mailmsgs[i].getMsgNum();
                    }
                    if (delnum > 0) {
                        if (this.verifyMsg(mailmsgs[i], delnum)) {
                            FaceStatusLabel.setStatus("Mailbox", "Delete message " + delnum);
                            Debug.out("Delete Msg " + delnum + " " + mailmsgs[i].getKey());
                            Log.out("DeleteMsg", "From: " + mailmsgs[i].getHeader("from") + ";  Subject: " + mailmsgs[i].getHeader("subject"));
                            this._PopServer.dele(delnum);
                            --this._Count;
                            deleted = true;
                            this.removeMailmsg(mailmsgs[i]);
                        } else {
                            Debug.out("Delete Failed " + mailmsgs[i].getKey());
                            mailmsgs[i].setDeleteFlag(false);
                        }
                    } else {
                        Debug.out("Delete Failed " + mailmsgs[i].getKey() + " not found.");
                        mailmsgs[i].setDeleteFlag(false);
                    }
                }
                ++i;
            }
        }
        if (deleted) {
            this.setModified(true);
            this.close();
            if (!this.open()) {
                throw new FaceMailboxException("Failure opening Mailbox after delete action");
            }
        }
        return deleted;
    }

    private void getListSize() {
        popStatus status = this._PopServer.list();
        String[] responses = status.Responses();
        int newcnt = responses.length;
        this._ListSize = new String[newcnt];
        int i = 0;
        while (i < newcnt) {
            StringTokenizer st = new StringTokenizer(responses[i]);
            String[] listinfo = new String[2];
            int j = 0;
            while (st.hasMoreTokens() && j < 2) {
                listinfo[j] = st.nextToken();
                ++j;
            }
            this._ListSize[i] = listinfo[1];
            ++i;
        }
    }

    private void getListUIDL() {
        if (this._UidlCmdOK || !this._TestedCmds) {
            popStatus status;
            if (!this._TestedCmds) {
                status = this.testCmds();
                this._TestedCmds = true;
            } else {
                status = this._PopServer.uidl();
            }
            if (status.OK()) {
                String[] responses = status.Responses();
                int newcnt = responses.length;
                this._ListUidl = new String[newcnt];
                int i = 0;
                while (i < newcnt) {
                    StringTokenizer st = new StringTokenizer(responses[i]);
                    String[] listinfo = new String[2];
                    int j = 0;
                    while (st.hasMoreTokens() && j < 2) {
                        listinfo[j] = st.nextToken();
                        ++j;
                    }
                    if (listinfo[1] != null) {
                        this._ListUidl[i] = listinfo[1];
                    } else {
                        int j2 = 0;
                        while (j2 < newcnt) {
                            Debug.out(" " + j2 + ":'" + responses[j2] + "'");
                            ++j2;
                        }
                        Debug.out("Entry " + i + " is not correct??");
                        this._ListUidl[i] = "";
                    }
                    ++i;
                }
                return;
            }
            Debug.out("UIDL Command failed. " + status.Response());
        }
        if (this._ListSize == null) {
            this.getListSize();
        }
        this._ListUidl = new String[this._ListSize.length];
        int i = 0;
        while (i < this._ListSize.length) {
            this._ListUidl[i] = i + 1 + "+" + this._ListSize[i];
            Debug.out("Msg " + i + " Uidl=" + this._ListUidl[i]);
            ++i;
        }
    }

    private boolean verifyMsg(Mailmsg mailmsg, int msgnum) {
        String uidl = null;
        if (this._UidlCmdOK) {
            String uidloutput = this._PopServer.uidl(msgnum).Response();
            if (uidloutput.startsWith("+OK")) {
                StringTokenizer st = new StringTokenizer(uidloutput);
                String[] uidlinfo = new String[3];
                int j = 0;
                while (st.hasMoreTokens() && j < 3) {
                    uidlinfo[j] = st.nextToken();
                    ++j;
                }
                uidl = uidlinfo[2];
                if (uidl.equals(mailmsg.getKey())) {
                    return true;
                }
            }
            return false;
        }
        Mailmsg msg = new Mailmsg(msgnum);
        popStatus status = this._PopServer.top(msgnum, 1);
        if (!status.OK()) {
            Debug.out("TOP: response='" + status.Response() + "'");
            return false;
        }
        String[] tops = status.Responses();
        msg.setHeaderLines(tops);
        uidl = msg.getKey();
        return uidl.equals(mailmsg.getKey());
    }

    private popStatus testCmds() {
        popStatus status = this._PopServer.uidl();
        if (status.OK()) {
            this._UidlCmdOK = true;
        } else {
            Debug.out("Warning: This Server does not support UIDL commands");
        }
        popStatus topstatus = this._PopServer.top(1, 1);
        if (topstatus.OK()) {
            this._TopCmdOK = true;
        } else {
            Debug.out("TOP: response='" + status.Response() + "'");
            MsgDialog.create("Mail Server TOP command failed to read the Mail Header information\nJavaFaces may not be abble to support this server");
        }
        return status;
    }

    public static void main(String[] args) {
        Debug.setDebugOn(true);
        if (args.length < 3) {
            Debug.out("java FaceMailboxPop host user password");
            System.exit(0);
        }
        FaceMailboxPop mailbox = new FaceMailboxPop(args[0], args[1], args[2]);
        mailbox.open();
        mailbox.close();
        System.exit(0);
    }
}

