/*
 * Decompiled with CFR 0.152.
 */
package jspell.spellchecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import jspell.spellchecker.Node_D;
import jspell.spellchecker.Node_R;
import jspell.spellchecker.Node_S;
import jspell.spellchecker.j_util;

public class SpellIndex {
    boolean locked = false;
    File indexFile;
    RandomAccessFile jdx;
    boolean indexReady = false;
    public static final String version = "sndspell1.0\u001a";
    public static final String defaultName = "SNDSPELL.JDX";
    String indexName;
    byte[] nullNode = new byte[28];
    public static int baseOffset = "sndspell1.0\u001a".length() + 4;
    int logicalOffset;
    Hashtable nodeBuffer;
    Hashtable dataBuffer;
    int bufferCapacity = 5;
    int dataBufferCap = 3;
    int dataBufferLimit = 1;
    float totalhits;
    float buffertime;
    int bufferNumber = 0;
    Node_R root;
    boolean verbose = true;

    public SpellIndex() {
        this(defaultName);
    }

    public SpellIndex(String name) {
        for (int i = 0; i < 28; ++i) {
            this.nullNode[i] = 0;
        }
        this.nodeBuffer = new Hashtable(this.bufferCapacity);
        this.dataBuffer = new Hashtable(this.dataBufferCap);
        this.totalhits = 0.0f;
        this.buffertime = 0.0f;
        this.indexFile = new File(defaultName);
        if (this.indexFile.exists()) {
            try {
                this.jdx = new RandomAccessFile(this.indexFile, "rw");
                this.jdx.seek(baseOffset - 4);
                this.logicalOffset = this.jdx.readInt();
                this.root = new Node_R();
                this.root.nodeOffset = 0;
                try {
                    this.jdx.seek(baseOffset);
                    for (int i = 0; i < 26; ++i) {
                        this.root.child[i] = this.jdx.readInt();
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            this.indexReady = true;
        } else {
            System.out.println("Spell Checker Index File [SNDSPELL.JDX] was not found.");
            this.indexReady = false;
        }
        if (this.indexReady) {
            this.indexName = defaultName;
        }
    }

    public final boolean isIndexReady() {
        return this.indexReady;
    }

    public final void setVerbose(boolean newValue) {
        this.verbose = newValue;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final boolean add(String origWord, String word, Node_S baseNode) {
        if (word.length() > 0) {
            char curchar = word.charAt(0);
            int charval = curchar - 48;
            if (baseNode.child[charval] == 0) {
                baseNode.child[charval] = this.logicalOffset;
                this.newNode(baseNode.child[charval]);
                this.updateNode(baseNode, charval);
            }
            this.add(origWord, word.substring(1), this.readNode(baseNode.child[charval]));
        } else {
            this.addDataNode(baseNode, origWord);
        }
        return true;
    }

    public final boolean add(String origWord, String word, Node_R baseNode) {
        if (word.length() > 0) {
            char curchar = word.charAt(0);
            int charval = curchar - 65;
            if (baseNode.child[charval] == 0) {
                baseNode.child[charval] = this.logicalOffset;
                this.newNode(baseNode.child[charval]);
                this.updateNode(baseNode, charval);
            }
            this.add(origWord, word.substring(1), this.readNode(baseNode.child[charval]));
        } else {
            this.updateNode(baseNode);
        }
        return true;
    }

    private final void addNode_D(Node_D node) throws IOException {
        ++this.bufferNumber;
        node.lastAccess = this.bufferNumber;
        this.addNode_DBuffer(node);
        this.jdx.seek(baseOffset + node.nodeOffset);
        this.jdx.writeUTF(node.dataElement);
        this.jdx.writeInt(node.nextNodeOffset);
    }

    private final Node_D getNode_D(int offset) throws IOException {
        Node_D resultNode = new Node_D();
        if (this.dataBuffer.containsKey(new Integer(offset))) {
            resultNode = (Node_D)this.dataBuffer.get(new Integer(offset));
        } else {
            this.jdx.seek(baseOffset + offset);
            resultNode = new Node_D();
            resultNode.nodeOffset = offset;
            resultNode.dataElement = this.jdx.readUTF();
            resultNode.nextNodeOffset = this.jdx.readInt();
            ++this.bufferNumber;
            resultNode.lastAccess = this.bufferNumber;
            this.addNode_DBuffer(resultNode);
        }
        return resultNode;
    }

    private final void addNode_DBuffer(Node_D node) {
        if (this.dataBuffer.size() < this.dataBufferCap) {
            this.dataBuffer.put(new Integer(node.nodeOffset), node);
        } else {
            Enumeration enumeration = this.dataBuffer.keys();
            int newBufferNumber = 0;
            int removed = 0;
            while (enumeration.hasMoreElements()) {
                Integer offsetkey = (Integer)enumeration.nextElement();
                Node_D bufferNode = (Node_D)this.dataBuffer.get(offsetkey);
                if (bufferNode.lastAccess < (long)(this.bufferNumber - this.dataBufferLimit)) {
                    this.dataBuffer.remove(offsetkey);
                    ++removed;
                    continue;
                }
                bufferNode.lastAccess = ++newBufferNumber;
            }
            this.bufferNumber = newBufferNumber;
        }
    }

    public final boolean addDataNode(Node_S node, String origWord) {
        try {
            Node_D resultNode = null;
            int nextOffset = node.dataOffset;
            boolean found = false;
            while (nextOffset != 0 && !found) {
                resultNode = this.getNode_D(nextOffset);
                if (resultNode.dataElement.equals(origWord)) {
                    found = true;
                    continue;
                }
                nextOffset = resultNode.nextNodeOffset;
            }
            if (!found) {
                if (node.dataOffset == 0) {
                    node.dataOffset = this.logicalOffset;
                    node.lastAccess = System.currentTimeMillis();
                    this.updateNode(node);
                } else {
                    resultNode.nextNodeOffset = this.logicalOffset;
                    this.addNode_D(resultNode);
                }
                Node_D newNode_D = new Node_D();
                newNode_D.nodeOffset = this.logicalOffset;
                newNode_D.dataElement = origWord;
                newNode_D.nextNodeOffset = 0;
                this.addNode_D(newNode_D);
                this.logicalOffset = (int)(this.jdx.getFilePointer() - (long)baseOffset);
                this.writeOffset();
            }
        }
        catch (IOException i) {
            System.out.println(i);
        }
        return true;
    }

    public boolean remove(String word) {
        return true;
    }

    public boolean search(String soundex, String original, String[] suggestions) throws IOException {
        char curchar = soundex.charAt(0);
        int charval = curchar - 65;
        boolean foundFlag = false;
        if (this.root != null && this.root.child[charval] != 0) {
            Node_S phonNode = this.readNode(this.root.child[charval]);
            for (int index = 1; index < soundex.length() && phonNode.child[soundex.charAt(index) - 48] != 0; ++index) {
                phonNode = this.readNode(phonNode.child[soundex.charAt(index) - 48]);
            }
            if (phonNode.dataOffset != 0) {
                int found = 0;
                Node_D dataNode = this.getNode_D(phonNode.dataOffset);
                if (dataNode.dataElement.toUpperCase().equals(original.toUpperCase())) {
                    foundFlag = true;
                } else if (j_util.eqscore(dataNode.dataElement, original) >= 0.6) {
                    suggestions[0] = dataNode.dataElement;
                }
                while (dataNode.nextNodeOffset != 0 && !foundFlag) {
                    dataNode = this.getNode_D(dataNode.nextNodeOffset);
                    if (dataNode.dataElement.toUpperCase().equals(original.toUpperCase())) {
                        foundFlag = true;
                        continue;
                    }
                    if (!(j_util.eqscore(dataNode.dataElement, original) >= 0.6) || found >= suggestions.length) continue;
                    suggestions[found] = dataNode.dataElement;
                    ++found;
                }
            }
        }
        return foundFlag;
    }

    public final boolean build(String dict) {
        this.indexFile.delete();
        int i = 0;
        int j = 0;
        this.initIndex();
        try {
            String word = "";
            BufferedReader d = new BufferedReader(new FileReader(dict));
            while (word != null) {
                word = d.readLine();
                if (word == null) continue;
                this.add(word, j_util.soundex(word), this.root);
                if (!this.verbose) continue;
                ++j;
                if (++i != 100) continue;
                System.out.println(String.valueOf(String.valueOf(String.valueOf("Word ").concat(String.valueOf(j))).concat(String.valueOf(" "))).concat(String.valueOf(word)));
                i = 0;
            }
            d.close();
            this.indexReady = true;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.exit(0);
        }
        return true;
    }

    public final void initIndex() {
        try {
            this.jdx = new RandomAccessFile(this.indexFile, "rw");
            this.jdx.seek(0L);
            this.jdx.writeBytes(version);
            this.logicalOffset = 0;
            this.writeOffset();
            this.root = new Node_R();
            this.root.nodeOffset = 0;
            try {
                this.jdx.seek(baseOffset);
                for (int i = 0; i < 26; ++i) {
                    this.jdx.writeInt(0);
                }
                this.logicalOffset += 104;
                this.writeOffset();
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public final boolean updateNode(Node_R node, int charval) {
        try {
            this.jdx.seek(baseOffset + node.nodeOffset + charval * 4);
            this.jdx.writeInt(node.child[charval]);
        }
        catch (Exception e) {
            System.out.println(String.valueOf("updateNode: ").concat(String.valueOf(e)));
            System.out.println(node.toString());
            e.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean updateNode(Node_R node) {
        try {
            this.jdx.seek(baseOffset + node.nodeOffset);
            for (int i = 0; i < 26; ++i) {
                this.jdx.writeInt(node.child[i]);
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf("updateNode: ").concat(String.valueOf(e)));
            System.out.println(node.toString());
            e.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean updateNode(Node_S node, int charval) {
        try {
            this.jdx.seek(baseOffset + node.nodeOffset + charval * 4);
            this.jdx.writeInt(node.child[charval]);
        }
        catch (Exception e) {
            System.out.println(String.valueOf("updateNode: ").concat(String.valueOf(e)));
            System.out.println(node.toString());
            e.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean updateNode(Node_S node) {
        try {
            this.jdx.seek(baseOffset + node.nodeOffset);
            for (int i = 0; i < 7; ++i) {
                this.jdx.writeInt(node.child[i]);
            }
            this.jdx.writeInt(node.dataOffset);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public final boolean newNode(int offset) {
        try {
            this.jdx.seek(baseOffset + offset);
            this.jdx.write(this.nullNode);
            this.jdx.writeInt(0);
            this.logicalOffset += 32;
            this.writeOffset();
        }
        catch (Exception e) {
            System.out.println(String.valueOf("NEW NODE: ").concat(String.valueOf(e)));
            e.printStackTrace();
            System.exit(-1);
        }
        return true;
    }

    public Node_S readNode(int offset) {
        Node_S resultNode;
        if (this.nodeBuffer.containsKey(new Integer(offset))) {
            resultNode = (Node_S)this.nodeBuffer.get(new Integer(offset));
            this.totalhits += 1.0f;
            this.buffertime += (float)(System.currentTimeMillis() - resultNode.lastAccess);
            resultNode.lastAccess = System.currentTimeMillis();
        } else {
            resultNode = new Node_S();
            try {
                this.jdx.seek(baseOffset + offset);
                for (int i = 0; i < 7; ++i) {
                    resultNode.child[i] = this.jdx.readInt();
                }
                resultNode.dataOffset = this.jdx.readInt();
                resultNode.nodeOffset = offset;
            }
            catch (IOException e) {
                System.out.println(String.valueOf("READ NODE: ").concat(String.valueOf(e)));
                System.out.println(String.valueOf("Trying to read logical offset ").concat(String.valueOf(Integer.toHexString(offset))));
                System.out.println(String.valueOf("Trying to read actual offset ").concat(String.valueOf(Integer.toHexString(baseOffset + offset))));
                e.printStackTrace();
                System.exit(-1);
            }
            resultNode.lastAccess = System.currentTimeMillis();
            if (this.nodeBuffer.size() < this.bufferCapacity) {
                this.nodeBuffer.put(new Integer(offset), resultNode);
            } else {
                Enumeration enumeration = this.nodeBuffer.keys();
                int removed = 0;
                while (enumeration.hasMoreElements()) {
                    Integer offsetkey = (Integer)enumeration.nextElement();
                    if (!((float)(System.currentTimeMillis() - ((Node_S)this.nodeBuffer.get((Object)offsetkey)).lastAccess) > this.buffertime / this.totalhits * (float)2)) continue;
                    this.nodeBuffer.remove(offsetkey);
                    ++removed;
                }
                this.buffertime = 0.0f;
                this.totalhits = 0.0f;
            }
        }
        return resultNode;
    }

    public final void writeOffset() {
        try {
            this.jdx.seek(baseOffset - 4);
            this.jdx.writeInt(this.logicalOffset);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

