/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.TabsetPanel;
import innoval.mailer.AudioFileFilter;
import innoval.mailer.FocusThread;
import innoval.mailer.JBevelPanel;
import innoval.mailer.JstreetAudioClip;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.IOException;

public class SettingsGeneral
extends Dialog
implements FocusListener,
KeyListener,
ActionListener,
ItemListener {
    public static final String SAVEGENERAL = new String("GeneralSettings");
    public static final String POPSERVER = new String("Pop3Server");
    public static final String POPUSERID = new String("Pop3Userid");
    public static final String POPPASSWORD = new String("Pop3Password");
    public static final String POPPORT = new String("Pop3Port");
    public static final String POPTIMEOUT = new String("Pop3TimeOut");
    public static final String MAILSTYLE = new String("MailStyle");
    public static final String MAILFOLDER = new String("MailFolder");
    public static final String MAILBOXNAME = new String("MailBoxName");
    public static final String SMTPSERVER1 = new String("SmtpServer");
    public static final String SMTPSERVER2 = new String("SmtpServerAlt");
    public static final String SMTPPORT1 = new String("SmtpPort");
    public static final String SMTPPORT2 = new String("SmtpPortAlt");
    public static final String SMTPSEND = new String("SmtpSend");
    public static final String SMTPTIMEOUT = new String("SmtpTimeOut");
    public static final String PROMPTDELETE = new String("PromptDelete");
    public static final String PROMPTADDR = new String("PromptAddress");
    public static final String FORWARDHDRS = new String("ForwardHeaders");
    public static final String WORDWRAP = new String("WordWrapSetting");
    public static final String ENCODING = new String("AttachmentEncoding");
    public static final String RETRNEW = new String("RetrieveNewMail");
    public static final String UIDLCMD = new String("UIDLCommand");
    public static final String LASTMESSAGE = new String("LastMessage");
    public static final String RETRDELETE = new String("DeleteRetrievedMail");
    public static final String RETRAUTO = new String("RetrieveAuto");
    public static final String AUTOMINUTES = new String("AutoMinutes");
    public static final String NOTIFYLARGE = new String("NotifyLargeMessage");
    public static final String NOTIFYBYTES = new String("NotifyBytes");
    public static final String PLAYTUNE = new String("PlayTune");
    public static final String TUNEFILE = new String("TuneFile");
    public static final String CLEANLOGSTYLE = new String("CleanLogStyle");
    public static final String CLEANLOGMAX = new String("CleanLogMax");
    public static final String CLEANTRASHSTYLE = new String("CleanTrashStyle");
    public static final String CLEANTRASHMAX = new String("CleanTrashMax");
    public static final String USETRASH = new String("UseTrashFolder");
    public static final String NEWS_SERVER = new String("NewsServer");
    public static final String NEWS_PORT = new String("NewsPort");
    public static final String NEWS_GROUPS = new String("NewsGroups");
    public static final int WORDWRAPON = 1;
    public static final int WORDWRAPOFF = 0;
    public static final int MIME = 1;
    public static final int UUENCODE = 0;
    public static final int DEFPOPTIMEOUT = 60;
    public static final int DEFSMTPTIMEOUT = 60;
    public static final int DEFLOGMAX = 200;
    public static final int DEFTRASHMAX = 100;
    public static final int POP3 = 0;
    public static final int IMAP = 1;
    public boolean ret_code;
    public boolean advanced;
    private Profile profile;
    private jstreet parent;
    private TabsetPanel tabPanel;
    private Panel popPanel;
    private Panel smtpPanel;
    private CheckboxGroup wordwrapGroup;
    private CheckboxGroup encodeGroup;
    private Checkbox checkPop;
    private Checkbox checkImap;
    private Checkbox smtpSend;
    private Checkbox promptDelete;
    private Checkbox promptAddr;
    private Checkbox forwardHdrs;
    private Checkbox checkNewmail;
    private Checkbox checkUIDL;
    private Checkbox checkDelmail;
    private Checkbox checkAutomail;
    private Checkbox checkNotifysize;
    private Checkbox checkTune;
    private Checkbox wordwrapOn;
    private Checkbox wordwrapOff;
    private Checkbox encodeUuencode;
    private Checkbox encodeMime;
    private Checkbox checkCleanlog;
    private Checkbox checkCleantrash;
    private Checkbox checkTrash;
    private Checkbox checkNewsGroups;
    public TextField popServer;
    public TextField popUser;
    public TextField popPass;
    public TextField popPort;
    public TextField popTimeout;
    public TextField newsServer;
    public TextField newsPort;
    public TextField mailFolder;
    public TextField mailboxName;
    public TextField smtpServer1;
    public TextField smtpServer2;
    public TextField smtpPort1;
    public TextField smtpPort2;
    public TextField smtpTimeout;
    public TextField textAutominutes;
    public TextField textMsgsize;
    public TextField textTune;
    public TextField textLastmessage;
    public TextField logMax;
    public TextField trashMax;
    private Label logLabel;
    private Label trashLabel;
    private Label labelMsgnum;
    private Button okButton;
    private Button cancelButton;
    private Button okAdvanced;
    private Button helpButton;
    private Button buttonTune;
    private FocusThread focusThread;

    SettingsGeneral(jstreet parent, Profile profile) {
        super(parent, "General Settings", true);
        this.parent = parent;
        this.profile = profile;
        this.ret_code = false;
        this.initDialog();
        this.focusThread = new FocusThread(this);
        this.focusThread.start();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{220, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 120, 220, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.tabPanel = new TabsetPanel();
        this.add(this.tabPanel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 9;
        con.gridheight = 1;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.tabPanel, con);
        this.setupNotebook();
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.cancelButton, con);
        this.okAdvanced = new Button("OK-Goto Advanced");
        this.okAdvanced.addActionListener(this);
        this.okAdvanced.addKeyListener(this);
        this.add(this.okAdvanced);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.okAdvanced, con);
        this.helpButton = new Button("Help");
        this.helpButton.addActionListener(this);
        this.helpButton.addKeyListener(this);
        this.add(this.helpButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 2;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.helpButton, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, this.parent);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton || e.getSource() == this.okAdvanced) {
            if (this.saveGeneral() && this.saveRetrieve() && this.saveMessage() && this.saveCleanupPage() && this.saveNews()) {
                this.profile.Save();
                if (e.getSource() == this.okAdvanced) {
                    this.advanced = true;
                }
                this.ret_code = true;
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.helpButton) {
            this.parent.showHelpWindow();
        } else if (e.getSource() == this.buttonTune) {
            FileDialog filedialog = new FileDialog((Frame)this.parent, "Select an Audio File", 0);
            filedialog.setFilenameFilter(new AudioFileFilter());
            filedialog.show();
            String file = filedialog.getFile();
            if (file != null) {
                this.checkTune.setState(true);
                try {
                    JstreetAudioClip clip = new JstreetAudioClip(String.valueOf(filedialog.getDirectory()).concat(String.valueOf(file)));
                    clip.play();
                }
                catch (IOException er) {
                    System.out.println(String.valueOf("Error: ").concat(String.valueOf(er)));
                }
                ((TextComponent)this.textTune).setText(new String(String.valueOf(filedialog.getDirectory()).concat(String.valueOf(file))));
            }
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void setupNotebook() {
        this.setupServerPage();
        this.setupRetrievePage();
        this.setupMessagePage();
        this.setupCleanupPage();
        this.setupNewsPage();
        this.tabPanel.setSelectedIndex(0);
    }

    private void setupServerPage() {
        Panel panel = new Panel();
        this.tabPanel.add((Component)panel, "Mail Servers");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{100, 10, 100};
        int[] columnWidths = new int[]{300};
        double[] rowWeights = new double[]{0.0, 10.0, 0.0};
        double[] columnWeights = new double[]{10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.popPanel = this.setupPopPanel();
        panel.add(this.popPanel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        grid.setConstraints(this.popPanel, con);
        this.smtpPanel = this.setupSmtpPanel();
        panel.add(this.smtpPanel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 2;
        grid.setConstraints(this.smtpPanel, con);
        panel.setLayout(grid);
        if (Integer.valueOf(this.profile.ReadString(SAVEGENERAL, MAILSTYLE, "0")) == 0) {
            this.checkPop.setState(true);
        } else {
            this.checkImap.setState(true);
        }
        this.mailboxName.setEnabled(this.checkImap.getState());
        this.mailFolder.setEnabled(this.checkImap.getState());
        ((TextComponent)this.popServer).setText(this.profile.ReadString(SAVEGENERAL, POPSERVER, ""));
        ((TextComponent)this.mailFolder).setText(this.profile.ReadString(SAVEGENERAL, MAILFOLDER, ""));
        ((TextComponent)this.mailboxName).setText(this.profile.ReadString(SAVEGENERAL, MAILBOXNAME, "INBOX"));
        ((TextComponent)this.popUser).setText(this.profile.ReadString(SAVEGENERAL, POPUSERID, ""));
        ((TextComponent)this.popPass).setText(this.profile.ReadString(SAVEGENERAL, POPPASSWORD, "", 1));
        ((TextComponent)this.popPort).setText(this.profile.ReadString(SAVEGENERAL, POPPORT, "110"));
        ((TextComponent)this.popTimeout).setText(this.profile.ReadString(SAVEGENERAL, POPTIMEOUT, "60"));
        this.smtpSend.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, SMTPSEND, "true")));
        ((TextComponent)this.smtpServer1).setText(this.profile.ReadString(SAVEGENERAL, SMTPSERVER1, ""));
        ((TextComponent)this.smtpPort1).setText(this.profile.ReadString(SAVEGENERAL, SMTPPORT1, "25"));
        ((TextComponent)this.smtpServer2).setText(this.profile.ReadString(SAVEGENERAL, SMTPSERVER2, ""));
        ((TextComponent)this.smtpPort2).setText(this.profile.ReadString(SAVEGENERAL, SMTPPORT2, "25"));
        ((TextComponent)this.smtpTimeout).setText(this.profile.ReadString(SAVEGENERAL, SMTPTIMEOUT, "60"));
    }

    private Panel setupPopPanel() {
        Panel panel = new Panel();
        CheckboxGroup group = new CheckboxGroup();
        this.checkPop = new Checkbox("POP3", group, true);
        this.checkPop.addItemListener(this);
        this.checkImap = new Checkbox("IMAP4", group, false);
        this.checkImap.addItemListener(this);
        this.popServer = new TextField();
        this.popServer.addFocusListener(this);
        this.popPort = new TextField();
        this.mailboxName = new TextField();
        this.mailFolder = new TextField();
        this.popUser = new TextField();
        this.popPass = new TextField();
        this.popPass.setEchoChar('*');
        this.popTimeout = new TextField();
        if (Integer.valueOf(this.profile.ReadString(SAVEGENERAL, MAILSTYLE, "0")) == 0) {
            this.setupPopGrid(panel);
        } else {
            this.setupImapGrid(panel);
        }
        return panel;
    }

    private Panel setupPopGrid(Panel panel) {
        panel.removeAll();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 15, 5, 15, 5, 15, 5, 15, 5, 15, 5};
        int[] columnWidths = new int[]{5, 130, 5, 60, 210, 50, 5, 50, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Mail Server");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        panel.add(this.checkPop);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.checkPop, con);
        panel.add(this.checkImap);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 1;
        grid.setConstraints(this.checkImap, con);
        label = new Label("Server", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("User Name", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Password", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(label, con);
        label = new Label("Port", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("Usually 110", 1);
        label.setFont(new Font("Dialog", 2, 10));
        label.setForeground(Color.black);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Connection Timeout", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        grid.setConstraints(label, con);
        label = new Label("(seconds)");
        label.setFont(new Font("Dialog", 2, 10));
        label.setForeground(Color.black);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 9;
        grid.setConstraints(label, con);
        panel.add(this.popServer);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 2;
        grid.setConstraints(this.popServer, con);
        panel.add(this.popPort);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 3;
        grid.setConstraints(this.popPort, con);
        panel.add(this.popUser);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        con.gridwidth = 2;
        grid.setConstraints(this.popUser, con);
        panel.add(this.popPass);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        con.gridwidth = 2;
        grid.setConstraints(this.popPass, con);
        panel.add(this.popTimeout);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 9;
        grid.setConstraints(this.popTimeout, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        rect.setPreferredSize(60, 30);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 9;
        con.gridheight = 11;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        return panel;
    }

    private Panel setupImapGrid(Panel panel) {
        panel.removeAll();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 15, 5, 15, 5, 15, 5, 15, 5, 15, 5};
        int[] columnWidths = new int[]{5, 130, 5, 60, 5, 60, 5, 110, 30, 5, 50, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Mail Server");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        panel.add(this.checkPop);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.checkPop, con);
        panel.add(this.checkImap);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.checkImap, con);
        label = new Label("Server", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("User Name", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Mail Folder", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Password", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(label, con);
        label = new Label("Mailbox Name", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 7;
        grid.setConstraints(label, con);
        label = new Label("Port", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 8;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("Usually 143", 1);
        label.setFont(new Font("Dialog", 2, 10));
        label.setForeground(Color.black);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 10;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Connection Timeout", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        grid.setConstraints(label, con);
        label = new Label("(seconds)");
        label.setFont(new Font("Dialog", 2, 10));
        label.setForeground(Color.black);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 9;
        grid.setConstraints(label, con);
        panel.add(this.popServer);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 5;
        grid.setConstraints(this.popServer, con);
        panel.add(this.popPort);
        jstreet.reset(con);
        con.gridx = 10;
        con.gridy = 3;
        grid.setConstraints(this.popPort, con);
        panel.add(this.popUser);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.popUser, con);
        panel.add(this.mailFolder);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(this.mailFolder, con);
        panel.add(this.popPass);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.popPass, con);
        panel.add(this.mailboxName);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 7;
        grid.setConstraints(this.mailboxName, con);
        panel.add(this.popTimeout);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 9;
        grid.setConstraints(this.popTimeout, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        rect.setPreferredSize(60, 30);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 12;
        con.gridheight = 11;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        return panel;
    }

    private Panel setupSmtpPanel() {
        Panel panel = new Panel();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 15, 5, 15, 5, 15, 5, 15, 5};
        int[] columnWidths = new int[]{5, 130, 5, 60, 210, 50, 5, 50, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("SMTP Server");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label("Server", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("Alternate", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Port", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("Port", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Usually 25");
        label.setFont(new Font("Dialog", 2, 10));
        label.setForeground(Color.black);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 7;
        grid.setConstraints(label, con);
        label = new Label("Connection Timeout", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(label, con);
        label = new Label("(seconds)");
        label.setFont(new Font("Dialog", 2, 10));
        label.setForeground(Color.black);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 7;
        grid.setConstraints(label, con);
        this.smtpSend = new Checkbox("Use SMTP instead of POP3 to send messages");
        panel.add(this.smtpSend);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.smtpSend, con);
        this.smtpServer1 = new TextField();
        panel.add(this.smtpServer1);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 2;
        grid.setConstraints(this.smtpServer1, con);
        this.smtpServer2 = new TextField();
        panel.add(this.smtpServer2);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        con.gridwidth = 2;
        grid.setConstraints(this.smtpServer2, con);
        this.smtpPort1 = new TextField();
        panel.add(this.smtpPort1);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 3;
        grid.setConstraints(this.smtpPort1, con);
        this.smtpPort2 = new TextField();
        panel.add(this.smtpPort2);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(this.smtpPort2, con);
        this.smtpTimeout = new TextField();
        panel.add(this.smtpTimeout);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.smtpTimeout, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        rect.setPreferredSize(60, 30);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 9;
        con.gridheight = 9;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        return panel;
    }

    public void setupRetrievePage() {
        Panel panel = new Panel();
        this.tabPanel.add((Component)panel, "Retrieving");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{10, 20, 5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 170, 60, 5, 100, 5, 40, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.checkNewmail = new Checkbox("Retrieve new mail only");
        panel.add(this.checkNewmail);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.checkNewmail, con);
        this.textLastmessage = new TextField();
        this.textLastmessage.setEnabled(false);
        panel.add(this.textLastmessage);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 1;
        grid.setConstraints(this.textLastmessage, con);
        this.labelMsgnum = new Label("Last message number");
        this.labelMsgnum.setEnabled(false);
        panel.add(this.labelMsgnum);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 1;
        grid.setConstraints(this.labelMsgnum, con);
        this.checkUIDL = new Checkbox("Mail server supports the UIDL command");
        this.checkUIDL.addItemListener(this);
        this.checkUIDL.setEnabled(this.checkPop.getState());
        panel.add(this.checkUIDL);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.checkUIDL, con);
        this.checkDelmail = new Checkbox("Delete retrieved messages from server");
        panel.add(this.checkDelmail);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.checkDelmail, con);
        this.checkAutomail = new Checkbox("Retrieve mail automatically every ");
        panel.add(this.checkAutomail);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.checkAutomail, con);
        this.textAutominutes = new TextField();
        panel.add(this.textAutominutes);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 7;
        grid.setConstraints(this.textAutominutes, con);
        Label label = new Label("minutes");
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 7;
        grid.setConstraints(label, con);
        this.checkNotifysize = new Checkbox("Provide a warning for messages larger than ");
        panel.add(this.checkNotifysize);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        grid.setConstraints(this.checkNotifysize, con);
        this.textMsgsize = new TextField();
        panel.add(this.textMsgsize);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 9;
        grid.setConstraints(this.textMsgsize, con);
        label = new Label("kilobytes");
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 9;
        grid.setConstraints(label, con);
        this.checkTune = new Checkbox("Play an audio file when new mail is received");
        panel.add(this.checkTune);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        grid.setConstraints(this.checkTune, con);
        this.textTune = new TextField();
        panel.add(this.textTune);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 11;
        con.gridwidth = 3;
        grid.setConstraints(this.textTune, con);
        this.buttonTune = new Button("Find");
        this.buttonTune.addActionListener(this);
        panel.add(this.buttonTune);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 11;
        grid.setConstraints(this.buttonTune, con);
        panel.setLayout(grid);
        this.checkNewmail.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, RETRNEW, "false")));
        this.checkUIDL.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, UIDLCMD, "true")));
        this.checkDelmail.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, RETRDELETE, "true")));
        this.checkAutomail.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, RETRAUTO, "false")));
        this.checkNotifysize.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, NOTIFYLARGE, "false")));
        this.checkTune.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, PLAYTUNE, "false")));
        ((TextComponent)this.textLastmessage).setText(this.profile.ReadString(SAVEGENERAL, LASTMESSAGE, "0"));
        if (this.checkUIDL.isEnabled()) {
            this.textLastmessage.setEnabled(!this.checkUIDL.getState());
            this.labelMsgnum.setEnabled(!this.checkUIDL.getState());
        }
        ((TextComponent)this.textAutominutes).setText(this.profile.ReadString(SAVEGENERAL, AUTOMINUTES, "0"));
        ((TextComponent)this.textMsgsize).setText(this.profile.ReadString(SAVEGENERAL, NOTIFYBYTES, "0"));
        ((TextComponent)this.textTune).setText(this.profile.ReadString(SAVEGENERAL, TUNEFILE, ""));
    }

    private void setupMessagePage() {
        Panel panel = new Panel();
        this.tabPanel.add((Component)panel, "Messages");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{0, 20, 20, 20, 20, 5, 20, 20, 5, 20, 5, 20, 20, 5, 5};
        int[] columnWidths = new int[]{5, 300, 5, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.promptDelete = new Checkbox("Prompt before deleting messages");
        panel.add(this.promptDelete);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.promptDelete, con);
        this.promptAddr = new Checkbox("Prompt before permitting addresses without domains");
        panel.add(this.promptAddr);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.promptAddr, con);
        this.forwardHdrs = new Checkbox("Include message headers when forwarding");
        panel.add(this.forwardHdrs);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.forwardHdrs, con);
        this.wordwrapGroup = new CheckboxGroup();
        this.wordwrapOn = new Checkbox("Default word wrapping ON for all composed messages", this.wordwrapGroup, false);
        panel.add(this.wordwrapOn);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        grid.setConstraints(this.wordwrapOn, con);
        this.wordwrapOff = new Checkbox("Default word wrapping OFF for all composed messages", this.wordwrapGroup, false);
        panel.add(this.wordwrapOff);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.wordwrapOff, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setPreferredSize(200, 60);
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 3;
        con.gridheight = 4;
        grid.setConstraints(rect, con);
        this.encodeGroup = new CheckboxGroup();
        this.encodeMime = new Checkbox("Default MIME as the method of encoding attached files", this.encodeGroup, false);
        panel.add(this.encodeMime);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        grid.setConstraints(this.encodeMime, con);
        this.encodeUuencode = new Checkbox("Default UUENCODE as the method of encoding attached files", this.encodeGroup, false);
        panel.add(this.encodeUuencode);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 12;
        grid.setConstraints(this.encodeUuencode, con);
        rect = new JBevelPanel();
        rect.setPreferredSize(200, 60);
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 10;
        con.gridwidth = 3;
        con.gridheight = 4;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        this.promptDelete.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, PROMPTDELETE, "true")));
        this.promptAddr.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, PROMPTADDR, "true")));
        this.forwardHdrs.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, FORWARDHDRS, "false")));
        int wordwrap = Integer.valueOf(this.profile.ReadString(SAVEGENERAL, WORDWRAP, "1"));
        switch (wordwrap) {
            case 0: {
                this.wordwrapOff.setState(true);
                break;
            }
            default: {
                this.wordwrapOn.setState(true);
                break;
            }
        }
        int encode = Integer.valueOf(this.profile.ReadString(SAVEGENERAL, ENCODING, "1"));
        switch (encode) {
            case 0: {
                this.encodeUuencode.setState(true);
                break;
            }
            default: {
                this.encodeMime.setState(true);
                break;
            }
        }
    }

    public void setupCleanupPage() {
        Panel panel = new Panel();
        this.tabPanel.add((Component)panel, "Cleanup");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 250, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.checkCleanlog = new Checkbox("Maintain the Transaction Log");
        this.checkCleanlog.addItemListener(this);
        panel.add(this.checkCleanlog);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.checkCleanlog, con);
        this.logLabel = new Label("Maximum Number of Log Items", 2);
        panel.add(this.logLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.logLabel, con);
        this.logMax = new TextField("200");
        panel.add(this.logMax);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.logMax, con);
        this.checkCleantrash = new Checkbox("Maintain the Trash Folder");
        this.checkCleantrash.addItemListener(this);
        panel.add(this.checkCleantrash);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.checkCleantrash, con);
        this.trashLabel = new Label("Maximum Number of Trash Messages", 2);
        panel.add(this.trashLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.trashLabel, con);
        this.trashMax = new TextField("100");
        panel.add(this.trashMax);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.trashMax, con);
        this.checkTrash = new Checkbox("Do Not Copy Discarded Messages to the Trash Folder");
        panel.add(this.checkTrash);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        grid.setConstraints(this.checkTrash, con);
        panel.setLayout(grid);
        this.checkCleanlog.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, CLEANLOGSTYLE, "true")));
        ((TextComponent)this.logMax).setText(this.profile.ReadString(SAVEGENERAL, CLEANLOGMAX, "200"));
        this.logMax.setEnabled(this.checkCleanlog.getState());
        this.logLabel.setEnabled(this.checkCleanlog.getState());
        this.checkCleantrash.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, CLEANTRASHSTYLE, "true")));
        ((TextComponent)this.trashMax).setText(this.profile.ReadString(SAVEGENERAL, CLEANTRASHMAX, "100"));
        this.trashMax.setEnabled(this.checkCleantrash.getState());
        this.trashLabel.setEnabled(this.checkCleantrash.getState());
        this.checkTrash.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, USETRASH, "false")));
    }

    public void setupNewsPage() {
        Panel panel = new Panel();
        this.tabPanel.add((Component)panel, "News");
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 15, 5, 15, 15, 5};
        int[] columnWidths = new int[]{5, 80, 5, 60, 190, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("News Server", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.newsServer = new TextField("");
        panel.add(this.newsServer);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.newsServer, con);
        label = new Label("Port Number", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        this.newsPort = new TextField("119");
        panel.add(this.newsPort);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.newsPort, con);
        this.checkNewsGroups = new Checkbox("Interpret addresses containing a period(.) but no (@) as newsgroups", true);
        panel.add(this.checkNewsGroups);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        con.gridwidth = 2;
        grid.setConstraints(this.checkNewsGroups, con);
        label = new Label("(With this setting off, you will need to type NEWS: before any address");
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        label = new Label("you want interpreted as a newsgroup name)");
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 8;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        panel.setLayout(grid);
        ((TextComponent)this.newsServer).setText(this.profile.ReadString(SAVEGENERAL, NEWS_SERVER, ""));
        ((TextComponent)this.newsPort).setText(this.profile.ReadString(SAVEGENERAL, NEWS_PORT, "119"));
        this.checkNewsGroups.setState(Boolean.valueOf(this.profile.ReadString(SAVEGENERAL, NEWS_GROUPS, "true")));
    }

    public boolean saveGeneral() {
        MsgBox msg;
        boolean ret_code = true;
        if (this.checkImap.getState() && !this.smtpSend.getState()) {
            msg = new MsgBox(this.parent, "You must specify SMTP to send messages because IMAP4 does not support this function.");
            ret_code = false;
            this.smtpSend.requestFocus();
        }
        if (ret_code && this.smtpSend.getState() && this.smtpServer1.getText().trim().length() == 0) {
            this.tabPanel.setSelectedIndex(0);
            msg = new MsgBox(this.parent, "The SMTP server name may not be blank if SMTP send has been chosen.");
            this.smtpServer1.requestFocus();
            ret_code = false;
        } else {
            if (this.smtpSend.getState()) {
                if (this.smtpPort1.getText().trim().length() == 0) {
                    ((TextComponent)this.smtpPort1).setText("25");
                }
                if (this.smtpServer2.getText().trim().length() > 0 && this.smtpPort2.getText().trim().length() == 0) {
                    ((TextComponent)this.smtpPort2).setText("25");
                }
            }
            int mailstyle = 0;
            if (this.checkImap.getState()) {
                mailstyle = 1;
            }
            this.profile.WriteString(SAVEGENERAL, MAILSTYLE, String.valueOf("").concat(String.valueOf(mailstyle)));
            this.profile.WriteString(SAVEGENERAL, POPSERVER, this.popServer.getText());
            this.profile.WriteString(SAVEGENERAL, MAILFOLDER, this.mailFolder.getText());
            this.profile.WriteString(SAVEGENERAL, MAILBOXNAME, this.mailboxName.getText());
            this.profile.WriteString(SAVEGENERAL, POPUSERID, this.popUser.getText());
            this.profile.WriteString(SAVEGENERAL, POPPASSWORD, this.popPass.getText(), 2);
            this.profile.WriteString(SAVEGENERAL, POPPORT, this.popPort.getText());
            this.profile.WriteString(SAVEGENERAL, POPTIMEOUT, this.popTimeout.getText());
            this.profile.WriteString(SAVEGENERAL, SMTPSEND, new Boolean(this.smtpSend.getState()).toString());
            this.profile.WriteString(SAVEGENERAL, SMTPSERVER1, this.smtpServer1.getText());
            this.profile.WriteString(SAVEGENERAL, SMTPSERVER2, this.smtpServer2.getText());
            this.profile.WriteString(SAVEGENERAL, SMTPPORT1, this.smtpPort1.getText());
            this.profile.WriteString(SAVEGENERAL, SMTPPORT2, this.smtpPort2.getText());
            this.profile.WriteString(SAVEGENERAL, SMTPTIMEOUT, this.smtpTimeout.getText());
        }
        return ret_code;
    }

    public boolean saveMessage() {
        boolean ret_code = true;
        int wordwrap = 0;
        int encode = 0;
        if (ret_code) {
            this.profile.WriteString(SAVEGENERAL, PROMPTDELETE, String.valueOf("").concat(String.valueOf(this.promptDelete.getState())));
            this.profile.WriteString(SAVEGENERAL, PROMPTADDR, String.valueOf("").concat(String.valueOf(this.promptAddr.getState())));
            this.profile.WriteString(SAVEGENERAL, FORWARDHDRS, String.valueOf("").concat(String.valueOf(this.forwardHdrs.getState())));
            wordwrap = this.wordwrapOn.getState() ? 1 : 0;
            this.profile.WriteString(SAVEGENERAL, WORDWRAP, String.valueOf("").concat(String.valueOf(wordwrap)));
            encode = this.encodeUuencode.getState() ? 0 : 1;
            this.profile.WriteString(SAVEGENERAL, ENCODING, String.valueOf("").concat(String.valueOf(encode)));
        } else {
            this.tabPanel.setSelectedIndex(2);
        }
        return ret_code;
    }

    public boolean saveRetrieve() {
        MsgBox msg;
        MsgBox msg2;
        boolean ret_code = true;
        int autominutes = 0;
        int bytes = 0;
        try {
            autominutes = Integer.valueOf(this.textAutominutes.getText());
        }
        catch (NumberFormatException e) {
            ret_code = false;
            msg2 = new MsgBox(this.parent, "The number of minutes for the Automatic Refresh is invalid.");
            this.textAutominutes.requestFocus();
        }
        if (this.checkNotifysize.getState()) {
            try {
                bytes = Integer.valueOf(this.textMsgsize.getText());
            }
            catch (NumberFormatException e) {
                ret_code = false;
                msg2 = new MsgBox(this.parent, "The number of kilobytes for the warning is invalid.");
                this.textMsgsize.requestFocus();
            }
        }
        if (ret_code && this.checkAutomail.getState() && (autominutes < 1 || autominutes > 60)) {
            this.tabPanel.setSelectedIndex(1);
            msg = new MsgBox(this.parent, "The automatic refresh interval must be between 1 and 60 minutes.");
            this.textAutominutes.requestFocus();
            ret_code = false;
        }
        if (ret_code && this.checkTune.getState() && this.textTune.getText().trim().length() == 0) {
            msg = new MsgBox(this.parent, "Please specify an audio file.");
            this.textTune.requestFocus();
            ret_code = false;
        }
        if (ret_code) {
            this.profile.WriteString(SAVEGENERAL, LASTMESSAGE, this.textLastmessage.getText());
            this.profile.WriteString(SAVEGENERAL, AUTOMINUTES, this.textAutominutes.getText());
            this.profile.WriteString(SAVEGENERAL, NOTIFYBYTES, this.textMsgsize.getText());
            this.profile.WriteString(SAVEGENERAL, TUNEFILE, this.textTune.getText());
            this.profile.WriteString(SAVEGENERAL, RETRNEW, new Boolean(this.checkNewmail.getState()).toString());
            this.profile.WriteString(SAVEGENERAL, UIDLCMD, new Boolean(this.checkUIDL.getState()).toString());
            this.profile.WriteString(SAVEGENERAL, RETRDELETE, new Boolean(this.checkDelmail.getState()).toString());
            this.profile.WriteString(SAVEGENERAL, RETRAUTO, new Boolean(this.checkAutomail.getState()).toString());
            this.profile.WriteString(SAVEGENERAL, NOTIFYLARGE, new Boolean(this.checkNotifysize.getState()).toString());
            this.profile.WriteString(SAVEGENERAL, PLAYTUNE, new Boolean(this.checkTune.getState()).toString());
        } else {
            this.tabPanel.setSelectedIndex(1);
        }
        return ret_code;
    }

    public boolean saveCleanupPage() {
        MsgBox msg;
        boolean ret_code = true;
        int maxlog = Integer.valueOf(this.logMax.getText());
        int maxtrash = Integer.valueOf(this.trashMax.getText());
        if (this.checkCleanlog.getState() && maxlog < 1) {
            this.tabPanel.setSelectedIndex(4);
            msg = new MsgBox(this.parent, "The maximum log items must be greater than zero.");
            this.logMax.requestFocus();
            ret_code = false;
        }
        if (ret_code && this.checkCleantrash.getState() && maxtrash < 1) {
            this.tabPanel.setSelectedIndex(4);
            msg = new MsgBox(this.parent, "The maximum trash items must be greater than zero.");
            this.trashMax.requestFocus();
            ret_code = false;
        }
        if (ret_code) {
            this.profile.WriteString(SAVEGENERAL, CLEANLOGSTYLE, String.valueOf("").concat(String.valueOf(this.checkCleanlog.getState())));
            this.profile.WriteString(SAVEGENERAL, CLEANTRASHSTYLE, String.valueOf("").concat(String.valueOf(this.checkCleantrash.getState())));
            this.profile.WriteString(SAVEGENERAL, CLEANLOGMAX, String.valueOf("").concat(String.valueOf(maxlog)));
            this.profile.WriteString(SAVEGENERAL, CLEANTRASHMAX, String.valueOf("").concat(String.valueOf(maxtrash)));
            this.profile.WriteString(SAVEGENERAL, USETRASH, String.valueOf("").concat(String.valueOf(this.checkTrash.getState())));
        }
        return ret_code;
    }

    public boolean saveNews() {
        boolean ret_code = true;
        if (this.newsPort.getText().trim().length() == 0) {
            ((TextComponent)this.newsPort).setText("119");
        }
        this.profile.WriteString(SAVEGENERAL, NEWS_SERVER, this.newsServer.getText().trim());
        this.profile.WriteString(SAVEGENERAL, NEWS_PORT, this.newsPort.getText().trim());
        this.profile.WriteString(SAVEGENERAL, NEWS_GROUPS, String.valueOf("").concat(String.valueOf(this.checkNewsGroups.getState())));
        return ret_code;
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    public void processFocusEvent(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.popServer && this.isVisible()) {
            this.focusThread.setStop();
        }
    }

    private void resize() {
        this.setResizable(false);
        this.popPanel.validate();
        this.setResizable(true);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkPop) {
            ((TextComponent)this.popPort).setText("110");
            this.mailboxName.setEnabled(false);
            this.mailFolder.setEnabled(false);
            this.setupPopGrid(this.popPanel);
            this.checkUIDL.setEnabled(true);
            this.textLastmessage.setEnabled(!this.checkUIDL.getState());
            this.labelMsgnum.setEnabled(!this.checkUIDL.getState());
            this.resize();
        } else if (e.getSource() == this.checkImap) {
            ((TextComponent)this.popPort).setText("143");
            this.mailboxName.setEnabled(true);
            this.mailFolder.setEnabled(true);
            this.setupImapGrid(this.popPanel);
            this.checkUIDL.setEnabled(false);
            this.textLastmessage.setEnabled(false);
            this.labelMsgnum.setEnabled(false);
            this.resize();
        } else if (e.getSource() == this.checkCleanlog) {
            this.logMax.setEnabled(!this.logMax.isEnabled());
            this.logLabel.setEnabled(!this.logLabel.isEnabled());
        } else if (e.getSource() == this.checkCleantrash) {
            this.trashMax.setEnabled(!this.trashMax.isEnabled());
            this.trashLabel.setEnabled(!this.trashLabel.isEnabled());
        } else if (e.getSource() == this.checkUIDL) {
            this.textLastmessage.setEnabled(!this.checkUIDL.getState());
            this.labelMsgnum.setEnabled(!this.checkUIDL.getState());
        }
    }

    public static int getMailStyle(Profile profile) {
        int mailstyle = Integer.valueOf(profile.ReadString(SAVEGENERAL, MAILSTYLE, "0"));
        return mailstyle;
    }
}

