/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.PopFileReader;
import innoval.mailer.PopFileWriter;
import innoval.mailer.jstreet;
import java.io.File;
import java.util.Vector;

public class RemoteFolderIndex {
    private jstreet parent = null;
    private Vector folder = null;
    private File file = null;

    public RemoteFolderIndex(jstreet parent) {
        this.parent = parent;
        this.folder = new Vector();
        this.file = new File(parent.getAccountDir(), parent.getRemoteIndexName());
        this.readFile();
    }

    public int size() {
        return this.folder.size();
    }

    public String getFolder(int i) {
        String path = null;
        if (i < this.folder.size()) {
            path = (String)this.folder.elementAt(i);
        }
        return path;
    }

    public String getFolderName(int i) {
        String name = this.getFolder(i);
        int spot = name.lastIndexOf(File.separator);
        if (spot >= 0) {
            name = new String(name.substring(spot + 1));
        }
        return name;
    }

    public boolean add(File newfile) {
        boolean ret_code = true;
        this.folder.addElement(newfile.getAbsolutePath());
        ret_code = this.saveFile();
        return ret_code;
    }

    public boolean delete(File oldfile) {
        boolean ret_code = false;
        String path = null;
        for (int i = 0; i < this.folder.size(); ++i) {
            path = ((String)this.folder.elementAt(i)).toLowerCase();
            if (!path.equalsIgnoreCase(oldfile.getAbsolutePath())) continue;
            ret_code = true;
            this.folder.removeElementAt(i);
            break;
        }
        if (ret_code) {
            ret_code = this.saveFile();
        }
        return ret_code;
    }

    private void readFile() {
        PopFileReader in;
        String x = null;
        if (this.file.exists() && (in = new PopFileReader()).open(this.file)) {
            do {
                File f;
                if ((x = in.lineIn()) == null || !(f = new File(x)).exists()) continue;
                this.folder.addElement(x);
            } while (x != null);
            in.close();
        }
    }

    public boolean saveFile() {
        boolean ret_code = true;
        PopFileWriter out = new PopFileWriter();
        String line = null;
        if (out.open(this.file)) {
            for (int i = 0; i < this.folder.size(); ++i) {
                line = (String)this.folder.elementAt(i);
                out.lineOut(String.valueOf(line).concat(String.valueOf("\n")));
            }
            out.close();
            out = null;
        } else {
            ret_code = false;
        }
        return ret_code;
    }
}

