/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class PromptNewsServer
extends Dialog
implements KeyListener,
ActionListener {
    private jstreet parent;
    private Button okButton;
    private Button cancelButton;
    private String server = null;
    private int port = 119;
    private TextField serverField;
    private TextField portField;

    PromptNewsServer(jstreet parent) {
        super(parent, "Enter your NEWS Server", true);
        this.parent = parent;
        this.setupDialog();
        this.show();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 190, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("News Server", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.serverField = new TextField();
        this.add(this.serverField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.serverField, con);
        label = new Label("News Port", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        this.portField = new TextField("119");
        this.add(this.portField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.portField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
        this.enableEvents(64L);
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.checkFields()) {
                this.server = new String(this.serverField.getText().trim());
                try {
                    this.port = Integer.valueOf(this.portField.getText().trim());
                }
                catch (NumberFormatException ex) {
                    this.port = 119;
                }
                this.parent.getProfile().WriteString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NEWS_SERVER, this.server);
                this.parent.getProfile().WriteString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.NEWS_PORT, String.valueOf("").concat(String.valueOf(this.port)), true);
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private boolean checkFields() {
        boolean ret_code = true;
        if (this.serverField.getText().trim().length() == 0) {
            MsgBox msg = new MsgBox(this.parent, "Please enter your NEWS server name.");
            ret_code = false;
            this.serverField.requestFocus();
        } else {
            int num = 0;
            try {
                num = Integer.valueOf(this.portField.getText().trim());
            }
            catch (NumberFormatException e) {
                ret_code = false;
            }
            if (num < 1) {
                ret_code = false;
            }
            if (!ret_code) {
                MsgBox msg = new MsgBox(this.parent, "The port number must be a valid whole number.");
                ret_code = false;
                this.portField.requestFocus();
            }
        }
        return ret_code;
    }
}

