/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderItem;
import innoval.mailer.GenPopName;
import innoval.mailer.MsgBox;
import innoval.mailer.NewsPost;
import innoval.mailer.PopFilter;
import innoval.mailer.PostPpoMessages;
import innoval.mailer.Profile;
import innoval.mailer.SendItem;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.jstreet;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class PpoOut {
    private jstreet parent;
    private boolean active;
    private Profile profile;
    private NewsPost post;
    private FolderItem outbasket;
    private FolderItem trash;
    private String server1;
    private String server2;
    private int port1;
    private int port2;
    private File currentPopfile;
    private File outbox;
    private PostPpoMessages postppoMessages;
    private SendItem senditem;
    private Label text;
    private BufferedReader in;

    PpoOut(jstreet parent, Profile profile, FolderItem outbasket, FolderItem trash) {
        this.parent = parent;
        this.profile = profile;
        this.outbasket = outbasket;
        this.trash = trash;
        this.text = parent.text;
        this.outbox = new File(profile.ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.PPOOUTBOX, ""));
        this.active = true;
    }

    public void send(File popfile) {
        this.currentPopfile = popfile;
        this.postppoMessages = new PostPpoMessages(this);
        this.postppoMessages.start();
    }

    public void sendMessages() {
        boolean ret_code = true;
        boolean go = false;
        String[] names = new String[1];
        Vector addr = null;
        int num = 0;
        jstreet.runExitProgram(this.parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.SENDEXIT);
        if (this.outbox.isDirectory() || this.outbox.mkdirs()) {
            if (this.currentPopfile != null) {
                names[0] = new String(this.currentPopfile.getName());
            } else {
                names = this.outbasket.getPath().list(new PopFilter());
            }
            for (int i = 0; i < names.length; ++i) {
                num = i + 1;
                this.text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Sending message [").concat(String.valueOf(num))).concat(String.valueOf(" of "))).concat(String.valueOf(names.length))).concat(String.valueOf("]...")));
                File popfile = new File(this.outbasket.getPath(), names[i]);
                this.senditem = new SendItem(this.parent, popfile, this.outbasket, this.trash);
                this.senditem.setTextWindow(this.text);
                addr = this.senditem.getAddresses();
                go = true;
                if (addr.size() > 0 && !this.uploadMessage(this.senditem, popfile)) {
                    ret_code = false;
                    go = false;
                }
                if (go && this.senditem.isNewsItem()) {
                    this.post = new NewsPost(this.parent, this.senditem, popfile);
                    ret_code = this.post.uploadMessage();
                    this.post = null;
                }
                if (!ret_code) break;
                this.senditem.fileMessage();
            }
            if (ret_code) {
                if (names.length == 1) {
                    this.text.setText("Your message was sent successfully.");
                } else {
                    this.text.setText("Your messages were sent successfully.");
                }
            } else if (names.length == 1) {
                this.text.setText("Errors occurred sending your message.");
            } else {
                this.text.setText("Errors occurred sending your messages.");
            }
        } else {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf(String.valueOf(String.valueOf("The specified PPO outbox directory [").concat(String.valueOf(this.outbox.getAbsolutePath()))).concat(String.valueOf("] does not exist and "))).concat(String.valueOf(" could not be created.")));
        }
        this.active = false;
        jstreet.runExitProgram(this.parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.SENDFEXIT);
        this.parent.SendComplete();
    }

    public boolean active() {
        return this.active;
    }

    public void breakSend() {
        if (this.postppoMessages != null) {
            this.postppoMessages.stop();
            this.postppoMessages = null;
        }
    }

    public boolean uploadMessage(SendItem senditem, File popfile) {
        if (senditem.addrapproach == 0) {
            return this.uploadSingleMessage(senditem, popfile);
        }
        return this.uploadMultipleMessage(senditem, popfile);
    }

    private boolean uploadMultipleMessage(SendItem senditem, File popfile) {
        boolean ret_code = true;
        File pfile = null;
        Vector addr = senditem.getAddresses();
        for (int i = 0; i < addr.size(); ++i) {
            pfile = new File(new GenPopName(this.outbox.getAbsolutePath()).getName());
            try {
                FileOutputStream out = new FileOutputStream(pfile);
                senditem.setAddress((String)addr.elementAt(i));
                ret_code = senditem.uploadMessage(out, popfile, true, true, true);
                out.close();
                continue;
            }
            catch (IOException e) {
                MsgBox msgbox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
                ret_code = false;
            }
        }
        return ret_code;
    }

    private boolean uploadSingleMessage(SendItem SendItem2, File popfile) {
        boolean ret_code = true;
        File pfile = null;
        pfile = new File(new GenPopName(this.outbox.getAbsolutePath()).getName());
        try {
            FileOutputStream out = new FileOutputStream(pfile);
            ret_code = this.senditem.uploadMessage(out, popfile, true, true, true);
            out.close();
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return ret_code;
    }
}

