/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.NoteWinVBrowser;
import innoval.mailer.NoteWinVText;
import innoval.mailer.VirtualFolderList;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;

public class NoteWinVFolder
extends Panel
implements ClipboardOwner {
    private VirtualFolderList parent;
    private File popfile = null;
    private jstreet Jstreet;
    private int msgViewStyle = 0;
    private int headerState = 2;
    private int fontSize = 1;
    private int reloads = 0;
    private int bottomCnt = 0;
    private boolean clear = false;
    private boolean formatState = true;
    private boolean decodeState = true;
    private NoteWinVBrowser browser = null;
    private NoteWinVText textarea = null;

    NoteWinVFolder(VirtualFolderList frame, jstreet Jstreet) {
        super(new BorderLayout());
        this.Jstreet = Jstreet;
        this.parent = frame;
    }

    public void setViewStyle(int val, Label text) {
        this.setVisible(false);
        if (this.msgViewStyle == 1 && this.textarea != null) {
            this.remove(this.textarea);
        }
        if (this.msgViewStyle == 0 && this.browser != null) {
            this.remove(this.browser);
        }
        this.msgViewStyle = val;
        if (this.msgViewStyle == 1) {
            this.textarea = this.formatState ? new NoteWinVText(this.parent, this.Jstreet, this.formatState) : new NoteWinVText(this.parent, this.Jstreet);
            if (this.textarea != null) {
                if (this.browser != null) {
                    this.removeNotify();
                    this.addNotify();
                }
                this.add("Center", this.textarea);
                this.textarea.setHeaderState(this.headerState, text);
                this.textarea.setFontSize(this.fontSize);
                this.textarea.setDecodeState(this.decodeState, text);
                this.textarea.setFormatState(this.formatState, text);
                if (this.popfile != null) {
                    this.textarea.load(this.popfile, text);
                }
            } else {
                System.out.println("Error creating virtual folder message text window.");
            }
        } else {
            this.browser = new NoteWinVBrowser(this.parent, this.Jstreet);
            if (this.browser != null) {
                if (this.textarea != null) {
                    this.removeNotify();
                    this.addNotify();
                }
                this.add("Center", this.browser);
                this.browser.setHeaderState(this.headerState, text);
                this.browser.setFontSize(this.fontSize, text);
                this.browser.setDecodeState(this.decodeState, text);
                this.browser.setFormatState(this.formatState, text);
                if (this.popfile != null) {
                    this.browser.load(this.popfile, text);
                }
            } else {
                System.out.println("Error createing virtual folder browser window.");
            }
        }
        this.setVisible(true);
        this.validate();
        this.clear = false;
    }

    public void setHeaderState(int val, Label text) {
        this.headerState = val;
        if (this.msgViewStyle == 1) {
            this.textarea.setHeaderState(val, text);
        } else {
            this.browser.setHeaderState(val, text);
        }
    }

    public int getHeaderState() {
        return this.headerState;
    }

    public void setFontSize(int val, Label text) {
        this.fontSize = val;
        if (this.msgViewStyle == 1) {
            this.textarea.setFontSize(val);
        } else {
            this.browser.setFontSize(val, text);
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFormatState(boolean val, Label text) {
        this.formatState = val;
        if (this.msgViewStyle == 1) {
            this.setViewStyle(1, text);
        } else {
            this.browser.setFormatState(val, text);
        }
    }

    public boolean getFormatState() {
        return this.formatState;
    }

    public void setDecodeState(boolean val, Label text) {
        this.decodeState = val;
        if (this.msgViewStyle == 1) {
            this.textarea.setDecodeState(val, text);
        } else {
            this.browser.setDecodeState(val, text);
        }
    }

    public boolean getDecodeState() {
        return this.decodeState;
    }

    public File getFile() {
        return this.popfile;
    }

    public String getPopFile() {
        String pname = "";
        if (this.popfile != null) {
            pname = new String(this.popfile.getName());
        }
        return pname;
    }

    public void clear() {
        this.stopLoading();
        if (!this.clear) {
            this.clear = true;
            this.popfile = null;
            if (this.msgViewStyle == 1) {
                this.textarea.clear();
            } else {
                this.browser.clear();
            }
        }
    }

    public void stopLoading() {
        if (this.msgViewStyle == 1) {
            this.textarea.stopLoading();
        } else {
            this.browser.stopLoading();
        }
    }

    public synchronized void load(File file, Label text) {
        this.popfile = file;
        this.clear = false;
        if (this.msgViewStyle == 1) {
            this.textarea.stopLoading();
            this.textarea.load(file, text);
        } else {
            this.browser.stopLoading();
            this.browser.load(file, text);
        }
    }

    public void reload() {
        if (this.msgViewStyle == 1) {
            this.textarea.reload();
        } else {
            this.browser.reload();
        }
    }

    public void lostOwnership(Clipboard board, Transferable trans) {
    }

    public static void clearDirectory(File dir) {
        String[] file = dir.list();
        for (int i = 0; i < file.length; ++i) {
            File tfile = new File(dir.getPath(), file[i]);
            tfile.delete();
        }
    }

    public boolean copy() {
        boolean ret_code = false;
        String str = null;
        switch (this.msgViewStyle) {
            case 1: {
                str = this.textarea.getSelectedText();
                break;
            }
            case 0: {
                str = new String("");
                break;
            }
        }
        if (str != null) {
            StringSelection s = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            if (str.length() > 0) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public String getSelectedText() {
        String str = null;
        switch (this.msgViewStyle) {
            case 1: {
                str = this.textarea.getSelectedText();
                break;
            }
        }
        return str;
    }
}

