/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.DownLoadMail;
import innoval.mailer.MsgBox;
import java.awt.Frame;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class MailMsg {
    private String to;
    private String cc;
    private String bcc;
    private String from;
    private String subject;
    private String date;
    private String popfile;
    private String folder;
    private String inchar;
    private long bytes;
    private long msgnum;
    private BufferedReader in;
    private DataOutputStream out;
    private BufferedWriter bwrite;
    private boolean body;
    private boolean isLarge = false;
    private boolean headersOnly;
    private Frame frame;
    private Label textbox;
    private int maxBytes = 0;
    public DownLoadMail thread;

    public MailMsg(Frame parent, File file) {
        this.frame = parent;
        this.to = new String("");
        this.cc = new String("");
        this.bcc = new String("");
        this.from = new String("");
        this.subject = new String("");
        this.date = new String("");
        this.folder = new String("");
        this.popfile = new String(file.getAbsolutePath());
        this.ParsePopFile(file);
    }

    public MailMsg(Frame parent, BufferedReader iStream, DataOutputStream oStream, int num, boolean text) {
        this.in = iStream;
        this.out = oStream;
        this.body = text;
        this.msgnum = num;
        this.frame = parent;
        this.to = new String("");
        this.cc = new String("");
        this.bcc = new String("");
        this.from = new String("");
        this.subject = new String("");
        this.date = new String("");
        this.popfile = new String("");
        this.folder = new String("");
        this.ReadMessage();
    }

    public MailMsg(Frame parent, BufferedReader iStream, DataOutputStream oStream, int num, BufferedWriter write, Label tbox) {
        this.in = iStream;
        this.out = oStream;
        this.bwrite = write;
        this.msgnum = num;
        this.frame = parent;
        this.textbox = tbox;
        this.to = new String("");
        this.cc = new String("");
        this.bcc = new String("");
        this.from = new String("");
        this.subject = new String("");
        this.date = new String("");
        this.popfile = new String("");
        this.folder = new String("");
        this.ReadMessage();
    }

    public MailMsg() {
        this.to = new String("");
        this.cc = new String("");
        this.bcc = new String("");
        this.from = new String("");
        this.subject = new String("");
        this.date = new String("");
        this.popfile = new String("");
        this.folder = new String("");
    }

    public void setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    public void getMessage(Frame parent, BufferedReader iStream, DataOutputStream oStream, int num, BufferedWriter write, Label tbox, DownLoadMail thread) {
        this.in = iStream;
        this.out = oStream;
        this.bwrite = write;
        this.msgnum = num;
        this.frame = parent;
        this.textbox = tbox;
        this.thread = thread;
        this.ReadMessage();
    }

    public void setHeadersOnly(boolean val) {
        this.headersOnly = val;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFolder(String folder) {
        this.folder = new String(folder);
    }

    public String getFolder() {
        return this.folder;
    }

    public void setPopfile(String file) {
        int spot = file.lastIndexOf(File.separator);
        this.popfile = spot > 1 ? new String(file.substring(spot + 1)) : new String(file);
    }

    public String getPopfile() {
        return this.popfile;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public String getDate() {
        return this.date;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    private boolean ReadMessage() {
        boolean ret_code;
        block9: {
            String oldMsg = new String("");
            long read = 0L;
            ret_code = true;
            boolean largeNote = false;
            try {
                this.bytes = this.readBytes(this.msgnum);
                if (this.maxBytes > 0 && this.bytes >= (long)this.maxBytes) {
                    largeNote = true;
                }
                if (largeNote) {
                    this.out.writeBytes(String.valueOf(String.valueOf("TOP ").concat(String.valueOf(this.msgnum))).concat(String.valueOf(" 1\r\n")));
                } else {
                    this.out.writeBytes(String.valueOf(String.valueOf("RETR ").concat(String.valueOf(this.msgnum))).concat(String.valueOf("\r\n")));
                }
                this.inchar = this.in.readLine();
                if (this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                    if (this.bwrite != null) {
                        oldMsg = new String(this.textbox.getText());
                    }
                    read = this.readHeaders(oldMsg);
                    if (this.bwrite != null) {
                        read = this.readBody(oldMsg, read);
                    }
                    if (this.subject.length() == 0) {
                        this.subject = "no subject";
                    }
                    if (!largeNote || this.bwrite == null) break block9;
                    this.bwrite.write(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\n\n<html><body><hr>\n<center>ATTENTION: This notice was added by The J Street Mailer.</center>\n<center><hr width=200></center>\nThe remainder of this message has been left on your server because its \nsize [").concat(String.valueOf(this.bytes))).concat(String.valueOf(" bytes] exceeds the limit imposed in your General Settings ["))).concat(String.valueOf(this.maxBytes))).concat(String.valueOf(" \n"))).concat(String.valueOf("bytes]. Please use the \"Preview Mail\" option to view the mail remaining on "))).concat(String.valueOf("your message server.\n<hr>\n")));
                    this.isLarge = true;
                    break block9;
                }
                ret_code = false;
            }
            catch (IOException e) {
                MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
            }
        }
        return ret_code;
    }

    public boolean getLarge() {
        return this.isLarge;
    }

    private long readBytes(long num) {
        long bytes = 0L;
        try {
            this.out.writeBytes(String.valueOf(String.valueOf("LIST ").concat(String.valueOf(this.msgnum))).concat(String.valueOf("\r\n")));
            String text = this.in.readLine();
            if (text != null && text.length() > 0 && text.charAt(0) == '+') {
                bytes = Long.valueOf(text.substring(text.trim().lastIndexOf(32)).trim());
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long readHeaders(String oldMsg) {
        boolean toAddressOn = false;
        boolean ccAddressOn = false;
        boolean bccAddressOn = false;
        long read = 0L;
        int cnt = 0;
        try {
            do {
                this.inchar = this.in.readLine();
                if (this.inchar != null) {
                    int i;
                    read += (long)(this.inchar.length() + 2);
                    if (this.bwrite != null) {
                        if (cnt == 0 || cnt % 3 == 0) {
                            if (this.bytes == (long)0) {
                                this.textbox.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldMsg).concat(String.valueOf(" ("))).concat(String.valueOf(read))).concat(String.valueOf(" bytes) "))).concat(String.valueOf(this.from)));
                            } else if (read <= this.bytes) {
                                this.textbox.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldMsg).concat(String.valueOf(" ("))).concat(String.valueOf((int)((double)read / (double)this.bytes * (double)100)))).concat(String.valueOf("% of "))).concat(String.valueOf(this.bytes))).concat(String.valueOf(") "))).concat(String.valueOf(this.from)));
                            }
                        }
                        ++cnt;
                        this.bwrite.write(String.valueOf(this.inchar).concat(String.valueOf("\n")));
                    }
                    String text = this.inchar.toLowerCase();
                    if (toAddressOn && (text.startsWith(" ") || text.startsWith("\t"))) {
                        i = 0;
                        while (this.inchar.charAt(i) == ' ' || this.inchar.charAt(i) == '\t') {
                            ++i;
                        }
                        this.to = new String(String.valueOf(String.valueOf(this.to).concat(String.valueOf(" "))).concat(String.valueOf(this.inchar.substring(i))));
                    } else if (ccAddressOn && (text.startsWith(" ") || text.startsWith("\t"))) {
                        i = 0;
                        while (this.inchar.charAt(i) == ' ' || this.inchar.charAt(i) == '\t') {
                            ++i;
                        }
                        this.cc = new String(String.valueOf(String.valueOf(this.cc).concat(String.valueOf(" "))).concat(String.valueOf(this.inchar.substring(i))));
                    } else if (bccAddressOn && (text.startsWith(" ") || text.startsWith("\t"))) {
                        i = 0;
                        while (this.inchar.charAt(i) == ' ' || this.inchar.charAt(i) == '\t') {
                            ++i;
                        }
                        this.bcc = new String(String.valueOf(String.valueOf(this.bcc).concat(String.valueOf(" "))).concat(String.valueOf(this.inchar.substring(i))));
                    } else {
                        toAddressOn = false;
                        ccAddressOn = false;
                        bccAddressOn = false;
                        if (this.from.length() == 0 && text.startsWith("from:") && this.inchar.length() > 6) {
                            this.from = this.inchar.substring(6);
                        } else if (this.to.length() == 0 && text.startsWith("to:") && this.inchar.length() > 4) {
                            toAddressOn = true;
                            this.to = this.inchar.substring(4);
                        } else if (this.cc.length() == 0 && text.startsWith("cc:") && this.inchar.length() > 4) {
                            ccAddressOn = true;
                            this.cc = this.inchar.substring(4);
                        } else if (this.bcc.length() == 0 && text.startsWith("bcc:") && this.inchar.length() > 5) {
                            bccAddressOn = true;
                            this.bcc = this.inchar.substring(5);
                        } else if (this.subject.length() == 0 && text.startsWith("subject:") && this.inchar.length() > 9) {
                            this.subject = this.inchar.substring(9);
                        } else if (this.date.length() == 0 && text.startsWith("date:") && this.inchar.length() > 6) {
                            this.date = this.inchar.substring(6);
                        }
                    }
                }
                if (this.inchar == null || this.inchar.compareTo(".") == 0 || this.inchar.trim().length() <= 0) return read;
            } while (this.thread == null || !this.thread.stop);
            return read;
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return read;
    }

    private long readBody(String oldMsg, long read) {
        int buflen = 0;
        int cnt = 0;
        String note = "";
        String end = "";
        char[] buffer = new char[1024];
        try {
            do {
                if ((buflen = this.in.read(buffer, 0, buffer.length)) <= 0) continue;
                ++cnt;
                read += (long)buflen;
                if (this.bytes == (long)0) {
                    this.textbox.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldMsg).concat(String.valueOf(" ("))).concat(String.valueOf(read))).concat(String.valueOf(" bytes) "))).concat(String.valueOf(this.from)));
                } else if (read <= this.bytes) {
                    this.textbox.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldMsg).concat(String.valueOf(" ("))).concat(String.valueOf((long)((double)read / (double)this.bytes * 100.0)))).concat(String.valueOf("% of "))).concat(String.valueOf(this.bytes))).concat(String.valueOf(")-"))).concat(String.valueOf(this.from)));
                }
                note = new String(String.valueOf(note).concat(String.valueOf(new String(buffer, 0, buflen))));
                end = note.length() > 10 ? new String(note.substring(note.length() - 10)) : new String(String.valueOf(end).concat(String.valueOf(note)));
                if (note.length() <= 40000) continue;
                this.bwrite.write(MailMsg.fixMessage(note));
                note = null;
                note = new String("");
            } while (!end.endsWith("\n.\r\n") && !end.endsWith("\n.\n") && (cnt > 1 || !end.equals(".\r\n") && !end.equals(".\n")) && (this.thread == null || !this.thread.stop));
            this.bwrite.write(MailMsg.fixMessage(note));
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        note = null;
        return read;
    }

    public static String fixMessage(String text) {
        StringBuffer obuff = new StringBuffer(1024);
        char tchar = '\u0000';
        block4: for (int i = 0; i < text.length(); ++i) {
            tchar = text.charAt(i);
            switch (tchar) {
                case '\r': {
                    continue block4;
                }
                case '.': {
                    if (i == 0 || text.charAt(i - 1) == '\n') continue block4;
                }
                default: {
                    obuff.append(tchar);
                }
            }
        }
        return obuff.toString();
    }

    private void ParsePopFile(File file) {
        try {
            this.bytes = file.length();
            this.in = new BufferedReader(new FileReader(file.getAbsolutePath()));
            this.readHeaders("");
            this.in.close();
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.frame, String.valueOf("Error").concat(String.valueOf(e)));
        }
    }
}

