/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.PopFileReader;
import innoval.mailer.PopFileWriter;
import innoval.mailer.jstreet;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

public class Last15
implements ActionListener {
    private jstreet Jstreet;
    private File file;
    private TextComponent tofield;
    private Vector last15;
    private PopupMenu popup;

    Last15(jstreet Jstreet) {
        this.Jstreet = Jstreet;
        this.file = new File(Jstreet.getAccountDir(), jstreet.LAST15_FILE);
        this.last15 = new Vector();
        this.loadLast15();
    }

    public int size() {
        return this.last15.size();
    }

    public void show(TextComponent parent, TextComponent toField) {
        this.tofield = toField;
        if (this.size() > 0) {
            this.setupLast15Popup();
            parent.add(this.popup);
            this.popup.show(parent.getParent(), parent.getLocation().x, parent.getLocation().y);
        } else {
            this.Jstreet.getToolkit().beep();
        }
    }

    public void setupLast15Popup() {
        this.popup = null;
        this.popup = new PopupMenu();
        MenuItem menuitem = null;
        for (int i = 0; i < this.last15.size(); ++i) {
            menuitem = new MenuItem(((String)this.last15.elementAt(i)).trim());
            menuitem.addActionListener(this);
            menuitem.setActionCommand(String.valueOf("Address: ").concat(String.valueOf((String)this.last15.elementAt(i))));
            this.popup.add(menuitem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("Address: ")) {
            String text = this.tofield.getText().trim();
            String cmd = e.getActionCommand();
            String addr = cmd.substring(cmd.indexOf(32) + 1);
            if (text.length() > 0 && text.charAt(text.length() - 1) != ',') {
                text = new String(String.valueOf(text).concat(String.valueOf(",")));
            }
            text = new String(String.valueOf(text).concat(String.valueOf(addr)));
            this.tofield.setText(text);
            int spot = this.last15.indexOf(addr);
            if (spot >= 0) {
                this.last15.removeElementAt(spot);
                this.last15.insertElementAt(addr, 0);
                this.save();
            }
        }
    }

    private void loadLast15() {
        PopFileReader in = new PopFileReader();
        String text = "";
        if (this.size() > 0) {
            this.last15.removeAllElements();
        }
        if (this.file.exists() && in.open(this.file)) {
            do {
                if ((text = in.lineIn()) == null || this.size() >= 15) continue;
                this.last15.addElement(text.trim());
            } while (text != null && this.size() < 15);
            in.close();
        }
    }

    public void update(String text) {
        Vector addrVector = Last15.parseAddresses(text);
        int spot = 0;
        for (int i = 0; i < addrVector.size(); ++i) {
            String addr = (String)addrVector.elementAt(i);
            if ((addr.toLowerCase().startsWith("to:") || addr.toLowerCase().startsWith("cc:") || addr.toLowerCase().startsWith("bcc:") || addr.toLowerCase().startsWith("news:")) && (spot = addr.indexOf(58)) >= 0) {
                addr = new String(addr.substring(spot + 1).trim());
            }
            if (this.last15.indexOf(addr) >= 0) continue;
            this.last15.insertElementAt(addr.trim(), 0);
        }
        if (this.last15.size() > 15) {
            int tot = this.last15.size();
            for (int i = tot - 1; i > 14; --i) {
                this.last15.removeElementAt(i);
            }
        }
        this.save();
    }

    private void save() {
        PopFileWriter out = new PopFileWriter();
        if (this.file.exists()) {
            this.file.delete();
        }
        if (out.open(this.file)) {
            for (int i = 0; i < this.last15.size(); ++i) {
                out.lineOut(String.valueOf(((String)this.last15.elementAt(i)).trim()).concat(String.valueOf("\n")));
            }
            out.close();
        }
    }

    public static Vector parseAddresses(String text) {
        int spot = 0;
        Vector<String> vector = new Vector<String>();
        String chk = null;
        text = new String(text.replace('\r', ' ').replace('\n', ' ').replace('\t', ' '));
        while (text.length() > 0) {
            spot = Last15.locateComma(text);
            if (spot >= 0) {
                chk = text.substring(0, spot).trim();
                if (chk.length() > 0) {
                    vector.addElement(chk);
                }
                text = new String(text.substring(spot + 1));
                continue;
            }
            if (text.trim().length() > 0) {
                vector.addElement(text.trim());
            }
            text = new String("");
        }
        return vector;
    }

    public static int locateComma(String text) {
        int spot = 0;
        int spot1 = 0;
        if (text.charAt(0) != ',') {
            int begin = 0;
            boolean quit = false;
            while (!quit) {
                spot1 = text.indexOf(34, begin);
                spot = text.indexOf(44, begin);
                if (spot1 >= 0 && spot >= 0 && spot1 < spot) {
                    if ((spot1 = text.indexOf(34, spot1 + 1)) > 0) {
                        begin = spot1 + 1;
                        continue;
                    }
                    quit = true;
                    spot = -1;
                    continue;
                }
                quit = true;
            }
        }
        return spot;
    }
}

