/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.DownloadFile;
import innoval.mailer.InternetFileOptions;
import innoval.mailer.JBevelPanel;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class InternetDownload
extends Dialog
implements KeyListener,
ActionListener {
    static final int FTP = 1;
    static final int HTTP = 2;
    static final String SAVENAME = new String("InternetDownload");
    static final String FTPPORT = new String("FtpPort");
    static final String HTTPPORT = new String("HttpPort");
    static final String CONNECTTIME = new String("ConnectTime");
    static final String IDLETIME = new String("IdleTime");
    static final String USERID = new String("Userid");
    static final String PASSWORD = new String("Password");
    static final String REMPASSWORD = new String("RememberPassword");
    static final String PROTOCOL = new String("Protocol");
    private int ftpPort = 21;
    private int httpPort = 80;
    private int connectTime = 60;
    private int idleTime = 30;
    private jstreet Jstreet;
    private Profile profile;
    private Button okButton;
    private Button cancelButton;
    private Button optionsButton;
    private Button findButton;
    private boolean ret_code = false;
    private Label textLabel;
    private TextField serverField;
    private TextField hostfileField;
    private TextField localfileField;
    private TextField useridField;
    private TextField passwordField;
    private CheckboxGroup checkGroup;
    private DownloadFile download;
    private Checkbox checkFtp;
    private Checkbox checkHttp;
    private Checkbox rememberPassword;

    InternetDownload(jstreet Jstreet) {
        super(Jstreet, "Download an Internet File", false);
        this.Jstreet = Jstreet;
        this.profile = Jstreet.getProfile();
        this.setupDialog();
        this.readProfile();
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public void setFtpPort(int val) {
        if (val > 0) {
            this.ftpPort = val;
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int val) {
        if (val > 0) {
            this.httpPort = val;
        }
    }

    public int getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(int val) {
        if (val > 0) {
            this.connectTime = val;
        }
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(int val) {
        if (val > 0) {
            this.idleTime = val;
        }
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 10, 5, 20, 5, 20, 5, 20, 5, 20, 5, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 100, 5, 5, 100, 10, 100, 5, 80, 40, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Host Name:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.serverField = new TextField();
        this.add(this.serverField);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 1;
        con.gridwidth = 6;
        grid.setConstraints(this.serverField, con);
        label = new Label("Host Filename:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        this.hostfileField = new TextField();
        this.add(this.hostfileField);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 3;
        con.gridwidth = 6;
        grid.setConstraints(this.hostfileField, con);
        label = new Label("Local Filename:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(label, con);
        this.localfileField = new TextField();
        this.add(this.localfileField);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 5;
        con.gridwidth = 5;
        grid.setConstraints(this.localfileField, con);
        this.findButton = new Button("Find");
        this.findButton.addActionListener(this);
        this.findButton.addKeyListener(this);
        this.add(this.findButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 5;
        grid.setConstraints(this.findButton, con);
        label = new Label("Protocol:");
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 8;
        grid.setConstraints(label, con);
        this.checkGroup = new CheckboxGroup();
        this.checkFtp = new Checkbox("FTP", this.checkGroup, true);
        this.add(this.checkFtp);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 10;
        grid.setConstraints(this.checkFtp, con);
        this.checkHttp = new Checkbox("HTTP", this.checkGroup, false);
        this.add(this.checkHttp);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 12;
        grid.setConstraints(this.checkHttp, con);
        JBevelPanel frame = new JBevelPanel();
        frame.setBevelInner(2);
        frame.setBevelOuter(2);
        frame.setPreferredSize(60, 60);
        this.add(frame);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 7;
        con.gridwidth = 3;
        con.gridheight = 7;
        grid.setConstraints(frame, con);
        label = new Label("FTP Security:");
        this.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 8;
        grid.setConstraints(label, con);
        this.rememberPassword = new Checkbox("Remember Password");
        this.add(this.rememberPassword);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 8;
        con.gridwidth = 3;
        grid.setConstraints(this.rememberPassword, con);
        label = new Label("Userid", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 10;
        grid.setConstraints(label, con);
        this.useridField = new TextField();
        this.add(this.useridField);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 10;
        grid.setConstraints(this.useridField, con);
        label = new Label("Password", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 12;
        grid.setConstraints(label, con);
        this.passwordField = new TextField();
        this.passwordField.setEchoChar('*');
        this.add(this.passwordField);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 12;
        grid.setConstraints(this.passwordField, con);
        frame = new JBevelPanel();
        frame.setBevelInner(2);
        frame.setBevelOuter(2);
        frame.setPreferredSize(60, 60);
        this.add(frame);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        con.gridwidth = 7;
        con.gridheight = 7;
        grid.setConstraints(frame, con);
        this.textLabel = new Label("");
        this.add(this.textLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 15;
        con.gridwidth = 9;
        grid.setConstraints(this.textLabel, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 17;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 17;
        grid.setConstraints(this.cancelButton, con);
        this.optionsButton = new Button("Options");
        this.optionsButton.addActionListener(this);
        this.optionsButton.addKeyListener(this);
        this.add(this.optionsButton);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 17;
        grid.setConstraints(this.optionsButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.Jstreet);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.checkFields()) {
                this.enableDialog(false);
                this.download = new DownloadFile(this.Jstreet, this);
                this.download.setHost(this.serverField.getText().trim());
                this.download.setHostFile(this.hostfileField.getText().trim());
                this.download.setLocalFile(this.localfileField.getText().trim());
                this.download.setConnectTime(this.connectTime);
                this.download.setIdleTime(this.idleTime);
                this.download.setFtpPort(this.ftpPort);
                this.download.setHttpPort(this.httpPort);
                this.download.setTextLabel(this.textLabel);
                if (this.checkFtp.getState()) {
                    this.download.setFtp();
                    this.download.setFtpUserid(this.useridField.getText().trim());
                    this.download.setFtpPassword(this.passwordField.getText().trim());
                } else {
                    this.download.setHttp();
                }
                this.download.start();
            }
        } else if (e.getSource() == this.cancelButton) {
            if (this.download != null && this.download.isRunning()) {
                MsgBox msg = new MsgBox((Container)this.Jstreet, "Halt the internet file download?", 3);
                if (msg.ret_code == 0) {
                    this.download.halt();
                }
            } else {
                this.closeDialog();
            }
        } else if (e.getSource() == this.optionsButton) {
            InternetFileOptions options = new InternetFileOptions(this.Jstreet, this);
            options.show();
        } else if (e.getSource() == this.findButton) {
            FileDialog filedialog = new FileDialog((Frame)this.Jstreet, "Find a File", 0);
            filedialog.show();
            if (filedialog.getFile() != null) {
                File tfile = new File(filedialog.getDirectory(), filedialog.getFile());
                ((TextComponent)this.localfileField).setText(tfile.getAbsolutePath());
            }
        }
    }

    public void completed() {
        this.enableDialog(true);
        this.download = null;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.closeDialog();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void closeDialog() {
        this.saveProfile();
        this.profile.Save();
        this.dispose();
    }

    public void saveProfile() {
        int protocol = 0;
        String password = this.passwordField.getText().trim();
        protocol = this.checkFtp.getState() ? 1 : 2;
        this.profile.WriteString(SAVENAME, USERID, this.useridField.getText().trim());
        if (!this.rememberPassword.getState()) {
            password = new String("");
        }
        this.profile.WriteString(SAVENAME, PASSWORD, password, 2);
        this.profile.WriteString(SAVENAME, REMPASSWORD, String.valueOf("").concat(String.valueOf(this.rememberPassword.getState())));
        this.profile.WriteString(SAVENAME, FTPPORT, String.valueOf("").concat(String.valueOf(this.ftpPort)));
        this.profile.WriteString(SAVENAME, HTTPPORT, String.valueOf("").concat(String.valueOf(this.httpPort)));
        this.profile.WriteString(SAVENAME, CONNECTTIME, String.valueOf("").concat(String.valueOf(this.connectTime)));
        this.profile.WriteString(SAVENAME, IDLETIME, String.valueOf("").concat(String.valueOf(this.idleTime)));
        this.profile.WriteString(SAVENAME, PROTOCOL, String.valueOf("").concat(String.valueOf(protocol)));
    }

    public void readProfile() {
        int protocol = 1;
        this.rememberPassword.setState(InternetDownload.makeBoolean(this.profile.ReadString(SAVENAME, REMPASSWORD, "true")));
        ((TextComponent)this.useridField).setText(this.profile.ReadString(SAVENAME, USERID, ""));
        if (this.rememberPassword.getState()) {
            ((TextComponent)this.passwordField).setText(this.profile.ReadString(SAVENAME, PASSWORD, "", 1));
        }
        this.ftpPort = InternetDownload.makeInt(this.profile.ReadString(SAVENAME, FTPPORT, String.valueOf("").concat(String.valueOf(this.ftpPort))));
        this.httpPort = InternetDownload.makeInt(this.profile.ReadString(SAVENAME, HTTPPORT, String.valueOf("").concat(String.valueOf(this.httpPort))));
        this.connectTime = InternetDownload.makeInt(this.profile.ReadString(SAVENAME, CONNECTTIME, String.valueOf("").concat(String.valueOf(this.connectTime))));
        this.idleTime = InternetDownload.makeInt(this.profile.ReadString(SAVENAME, IDLETIME, String.valueOf("").concat(String.valueOf(this.idleTime))));
        protocol = InternetDownload.makeInt(this.profile.ReadString(SAVENAME, PROTOCOL, String.valueOf("").concat(String.valueOf(protocol))));
        if (protocol == 1) {
            this.checkFtp.setState(true);
        } else {
            this.checkHttp.setState(true);
        }
    }

    public static int makeInt(String text) {
        return Integer.valueOf(text);
    }

    public static boolean makeBoolean(String text) {
        return Boolean.valueOf(text);
    }

    public boolean checkFields() {
        MsgBox msg;
        boolean ret_code = true;
        if (this.hostfileField.getText().trim().length() == 0) {
            msg = new MsgBox(this.Jstreet, "Please enter a host filename.");
            this.hostfileField.requestFocus();
            ret_code = false;
        } else {
            String text = this.hostfileField.getText().trim().toLowerCase();
            if (text.startsWith("ftp:")) {
                this.checkFtp.setState(true);
                this.checkHttp.setState(false);
            } else if (text.startsWith("http:")) {
                this.checkFtp.setState(false);
                this.checkHttp.setState(true);
            }
        }
        if (ret_code) {
            if (this.localfileField.getText().trim().length() == 0) {
                ((TextComponent)this.localfileField).setText(this.buildLocalFileName());
            }
            if (this.localfileField.getText().trim().length() == 0) {
                msg = new MsgBox(this.Jstreet, "Please enter a local filename.");
                this.localfileField.requestFocus();
                ret_code = false;
            }
        }
        if (ret_code && this.checkFtp.getState() && this.useridField.getText().trim().length() == 0) {
            msg = new MsgBox(this.Jstreet, "Please enter an FTP userid.");
            this.useridField.requestFocus();
            ret_code = false;
        }
        return ret_code;
    }

    private String buildLocalFileName() {
        String text = this.hostfileField.getText();
        int spot = text.lastIndexOf(47);
        if (spot < 0) {
            spot = text.lastIndexOf(92);
        }
        if (spot >= 0) {
            text = new String(text.substring(spot + 1));
        }
        return text;
    }

    public void enableDialog(boolean val) {
        this.okButton.setEnabled(val);
        this.optionsButton.setEnabled(val);
        this.findButton.setEnabled(val);
        this.hostfileField.setEnabled(val);
        this.localfileField.setEnabled(val);
        this.useridField.setEnabled(val);
        this.passwordField.setEnabled(val);
        this.checkFtp.setEnabled(val);
        this.checkHttp.setEnabled(val);
        this.rememberPassword.setEnabled(val);
    }
}

