/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.NoteWinText;
import innoval.mailer.PreviewImapMail;
import java.awt.IllegalComponentStateException;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.event.MouseEvent;

public class ImapMessageTextarea
extends TextArea {
    private PopupMenu popup = null;
    private PreviewImapMail parent = null;
    private boolean loaded = false;
    private boolean formatState = false;
    private int fontSize = 1;

    ImapMessageTextarea(PreviewImapMail parent, int fontSize, PopupMenu popup) {
        this.parent = parent;
        this.popup = popup;
        this.fontSize = fontSize;
        this.initWindow();
    }

    ImapMessageTextarea(PreviewImapMail parent, int fontSize, boolean formatState, PopupMenu popup) {
        super(new String(""), 1, 1, 1);
        this.parent = parent;
        this.popup = popup;
        this.fontSize = fontSize;
        this.formatState = formatState;
        this.initWindow();
    }

    private void initWindow() {
        this.setEditable(false);
        this.enableEvents(16L);
        this.setFontSize(this.fontSize);
    }

    public void processMouseEvent(MouseEvent e) {
        String text;
        boolean ret_code = false;
        if (e.getID() == 501) {
            if (this.loaded && this.popup != null && e.getModifiers() == 4) {
                this.popup.show(this, e.getX(), e.getY());
                ret_code = true;
            }
        } else if (e.getID() == 500 && e.getClickCount() == 2 && NoteWinText.isUrl(text = this.getSelectedText())) {
            this.parent.runBrowser(text);
        }
        if (!ret_code) {
            super.processMouseEvent(e);
        }
    }

    public void setFormatState(boolean formatState) {
        this.formatState = formatState;
        this.setFontSize(this.fontSize);
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        NoteWinText.setupFont(this.formatState, fontSize, this);
    }

    public void clear() {
        this.setText("");
        this.loaded = false;
    }

    public void setText(String text) {
        this.setVisible(false);
        super.setText(text);
        try {
            this.setCaretPosition(0);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        this.setVisible(true);
        this.loaded = true;
        this.requestFocus();
    }
}

