/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.Compose;
import innoval.mailer.CreateFolder;
import innoval.mailer.Folder;
import innoval.mailer.FolderFilter;
import innoval.mailer.FolderItem;
import innoval.mailer.FolderListLoad;
import innoval.mailer.FolderSort;
import innoval.mailer.FolderVectorSort;
import innoval.mailer.MsgBox;
import innoval.mailer.RemoteFolderIndex;
import innoval.mailer.SortVector;
import innoval.mailer.jstreet;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.util.JCVector;

public class FolderList
extends JCOutliner
implements JCOutlinerListener,
MouseListener,
ActionListener {
    private File mainDir;
    private File inbasketDir;
    private File trashDir;
    private File outbasketDir;
    private File remoteindex;
    private boolean notify = false;
    private boolean loaded;
    private boolean rmbActive = true;
    private boolean compose;
    private jstreet parent;
    private FolderListLoad folderlistload;
    private FolderItem rootNode = null;
    private JCOutlinerNodeStyle defStyle = null;
    private JCOutlinerNodeStyle parentStyle = null;
    private Image closed;

    FolderList(jstreet frame, String mainDir) {
        this.parent = frame;
        this.mainDir = new File(mainDir);
        this.notify = true;
        this.setRootVisible(false);
        this.initList();
        this.initTree();
    }

    FolderList(jstreet frame, String mainDir, boolean notify) {
        this.parent = frame;
        this.mainDir = new File(mainDir);
        this.notify = notify;
        this.initList();
        this.initTree();
    }

    public void outlinerFolderStateChangeBegin(JCOutlinerEvent ev) {
        JCOutliner outliner;
        JCOutlinerFolderNode folder = (JCOutlinerFolderNode)ev.getNode();
        if (folder == (outliner = (JCOutliner)ev.getSource()).getRootNode()) {
            return;
        }
        outliner.folderChanged(folder);
    }

    public void outlinerFolderStateChangeEnd(JCOutlinerEvent ev) {
    }

    public void outlinerNodeSelectBegin(JCOutlinerEvent ev) {
    }

    public void outlinerNodeSelectEnd(JCOutlinerEvent ev) {
    }

    public void itemStateChanged(JCItemEvent ev) {
    }

    public void setRmbActive(boolean val) {
        this.rmbActive = val;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setCompose(boolean val) {
        this.compose = val;
    }

    private void initList() {
        this.inbasketDir = new File(this.mainDir, jstreet.INBOX);
        this.outbasketDir = new File(this.mainDir, jstreet.OUTBOX);
        this.trashDir = new File(this.mainDir, jstreet.TRASHBOX);
        this.remoteindex = new File(this.mainDir, this.parent.getRemoteIndexName());
        this.inbasketDir.mkdir();
        this.outbasketDir.mkdir();
        this.cleanTempFiles(this.outbasketDir);
        this.trashDir.mkdir();
        this.loaded = false;
        this.getViewport().addMouseListener(this);
    }

    private void cleanTempFiles(File dir) {
        String[] name = dir.list();
        if (name != null) {
            for (int i = 0; i < name.length; ++i) {
                if (name[i].indexOf("$$temp$$") <= 0) continue;
                File file = new File(dir, name[i]);
                file.delete();
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.calcItem(e.getY());
            if (this.rmbActive) {
                this.parent.folderPopup.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void calcItem(int y) {
        JCVector node = this.getVisibleNodes();
        int item = 0;
        JCOutlinerNode tnode = null;
        Rectangle rect = null;
        if (node != null && node.size() > 0) {
            do {
                tnode = (JCOutlinerNode)node.elementAt(item);
                rect = this.getBounds(tnode, null);
            } while (++item < node.size() && y > rect.getLocation().y + rect.getSize().height);
            if (tnode != this.getSelectedNode()) {
                this.selectNode(tnode, null);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        this.parent.actionPerformed(e);
    }

    private void initTree() {
        this.closed = this.parent.getToolkit().getImage(jstreet.FILE_CLOSED);
        this.setNumColumns(1);
        this.setColumnWidth(0, 200);
        this.setPreferredSize(400, 300);
        this.getDefaultNodeStyle().setShortcut(true);
        this.addItemListener(this);
        this.defStyle = this.getDefaultNodeStyle();
        this.defStyle.setShortcut(true);
        this.defStyle.setFolderOpenIcon(this.closed);
        this.defStyle.setFolderClosedIcon(this.closed);
        this.defStyle.setFolderOpenSelectedIcon(this.parent.getToolkit().getImage(jstreet.FILE_CLOSED_SEL));
        this.defStyle.setFolderClosedSelectedIcon(this.parent.getToolkit().getImage(jstreet.FILE_CLOSED_SEL));
        this.parentStyle = new JCOutlinerNodeStyle(this.defStyle);
        this.parentStyle.setFolderClosedIcon(this.parent.getToolkit().getImage(jstreet.FILES_CLOSED));
        this.parentStyle.setFolderClosedSelectedIcon(this.parent.getToolkit().getImage(jstreet.FILES_CLOSED_SEL));
        this.parentStyle.setFolderOpenIcon(this.parent.getToolkit().getImage(jstreet.FILES_OPEN));
        this.parentStyle.setFolderOpenSelectedIcon(this.parent.getToolkit().getImage(jstreet.FILES_OPEN_SEL));
    }

    public void changeDirectory(String mainDir) {
        this.mainDir = new File(mainDir);
        this.initList();
    }

    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(100, 100);
        return dim;
    }

    public void expandCollapse(boolean way) {
        int stat = 1;
        if (way) {
            stat = 5;
        }
        this.setVisible(false);
        this.setBatched(true);
        this.expandCollapse(this.rootNode, stat);
        this.rootNode.setState(5);
        this.setBatched(false);
        this.folderChanged(this.rootNode);
        this.setVisible(true);
        this.repaint();
    }

    public void expandCollapse(FolderItem node, int stat) {
        while (node != null) {
            this.expandChildren(node, stat);
            node = (FolderItem)this.getNextNode(node);
        }
    }

    public void expandChildren(FolderItem node, int stat) {
        JCVector child = node.getChildren();
        node.setState(stat);
        if (child != null) {
            for (int i = 0; i < child.size(); ++i) {
                this.expandChildren((FolderItem)child.elementAt(i), stat);
            }
        }
    }

    public void load() {
        if (this.folderlistload != null) {
            this.folderlistload.stop();
        }
        this.loaded = false;
        this.folderlistload = new FolderListLoad(this);
        this.folderlistload.start();
    }

    public void loadFolders() {
        if (!this.notify) {
            this.loadFromList();
        } else {
            this.loadFromDrive();
        }
    }

    public void loadFromList() {
        this.setVisible(false);
        this.setBatched(true);
        this.rootNode = new FolderItem(this.parent, "", "");
        this.setRootNode(this.rootNode);
        JCVector children = this.parent.folderlist.getRootNode().getChildren();
        FolderItem item = null;
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                item = (FolderItem)children.elementAt(i);
                this.loadFolderItem(item, this.rootNode);
            }
        }
        this.setBatched(false);
        this.repaint();
        this.selectFirst();
        this.setVisible(true);
        this.folderChanged(this.rootNode);
        this.loaded = true;
    }

    private void loadFolderItem(FolderItem item, FolderItem node) {
        if (!this.compose || !((String)item.getLabel()).equalsIgnoreCase(jstreet.OUTBOX)) {
            FolderItem newitem = new FolderItem(this.parent, item.getDir(), item.getName(), node);
            newitem.setLabel(item.getLabel());
            newitem.setCurrent(item.isCurrent());
            newitem.setState(1);
            JCVector children = item.getChildren();
            if (children != null && children.size() > 0) {
                newitem.setStyle(this.parentStyle);
                for (int i = 0; i < children.size(); ++i) {
                    FolderItem childItem = (FolderItem)children.elementAt(i);
                    this.loadFolderItem(childItem, newitem);
                }
            }
        }
    }

    public void loadFromDrive() {
        String[] names = new String[]{};
        Vector<Folder> vector = new Vector<Folder>();
        FolderFilter folderfilter = new FolderFilter();
        Folder fldr = null;
        int i = 0;
        FolderItem olditem = null;
        FolderItem selitem = null;
        FolderItem newitem = null;
        this.parent.text.setText("Loading folders...");
        this.parent.sayLine("Loading folders...");
        this.setVisible(false);
        this.setBatched(true);
        this.rootNode = new FolderItem(this.parent, new String(""), new String(""));
        this.setRootNode(this.rootNode);
        names = this.mainDir.list(folderfilter);
        for (i = 0; i < names.length; ++i) {
            vector.addElement(new Folder(this.mainDir.getAbsolutePath(), names[i]));
        }
        this.addRemoteFolders(vector);
        this.parent.sayLine("Sorting folder list...");
        SortVector sortvector = new SortVector(vector, new FolderVectorSort());
        this.editFolderList(vector);
        this.parent.sayLine("Adding folders to control...");
        for (i = 0; i < vector.size(); ++i) {
            fldr = (Folder)vector.elementAt(i);
            if (this.compose && fldr.getName().equalsIgnoreCase(jstreet.OUTBOX)) continue;
            newitem = new FolderItem(this.parent, fldr.getDir(), fldr.getName(), this.rootNode);
            if (fldr.getRemote()) {
                newitem.setLabel(String.valueOf(String.valueOf(String.valueOf(String.valueOf(fldr.getName()).concat(String.valueOf(" ("))).concat(String.valueOf(fldr.getDir()))).concat(String.valueOf(File.separator))).concat(String.valueOf(")")));
            }
            if (fldr.getName().equalsIgnoreCase(jstreet.INBOX)) {
                newitem.setInbox(true);
            } else if (fldr.getName().equalsIgnoreCase(jstreet.OUTBOX)) {
                newitem.setOutbox(true);
            } else if (fldr.getName().equalsIgnoreCase(jstreet.TRASHBOX)) {
                newitem.setTrash(true);
            }
            newitem.setState(1);
            if (this.loadChildren(newitem) > 0) {
                newitem.setStyle(this.parentStyle);
            }
            if (new String(fldr.getName().toLowerCase()).compareTo(jstreet.INBOX) == 0) {
                selitem = newitem;
            }
            if (olditem != null) {
                olditem.setNext(newitem);
            }
            olditem = newitem;
            this.folderChanged(newitem);
        }
        this.parent.sayLine("Folders loaded.  Repainting...");
        this.setBatched(false);
        this.repaint();
        if (this.notify) {
            this.setFocusNode(selitem, null);
        } else {
            this.selectFirst();
        }
        this.setVisible(true);
        this.folderChanged(this.rootNode);
        this.loaded = true;
        this.parent.sayLine("Folder load completed.");
        this.parent.text.setText("");
    }

    private void editFolderList(Vector vector) {
        int ibox = -1;
        int obox = -1;
        int tbox = -1;
        Folder folder = null;
        for (int i = 0; i < vector.size(); ++i) {
            folder = (Folder)vector.elementAt(i);
            if (folder.getName().equalsIgnoreCase(jstreet.INBOX)) {
                ibox = i;
                continue;
            }
            if (folder.getName().equalsIgnoreCase(jstreet.OUTBOX)) {
                obox = i;
                continue;
            }
            if (!folder.getName().equalsIgnoreCase(jstreet.TRASHBOX)) continue;
            tbox = i;
        }
        if (ibox > 0) {
            folder = (Folder)vector.elementAt(ibox);
            vector.removeElementAt(ibox);
            vector.insertElementAt(folder, 0);
        }
        if (obox > 0 && obox != 1) {
            folder = (Folder)vector.elementAt(obox);
            vector.removeElementAt(obox);
            vector.insertElementAt(folder, 1);
        }
        if (tbox > 0 && tbox != vector.size() - 1) {
            folder = (Folder)vector.elementAt(tbox);
            vector.removeElementAt(tbox);
            vector.addElement(folder);
        }
    }

    public int loadChildren(FolderItem item) {
        String[] names = new String[]{};
        FolderFilter folderfilter = new FolderFilter();
        FolderItem newitem = null;
        names = item.getPath().list(folderfilter);
        if (names != null) {
            FolderList.sortStringArray(names);
            for (int i = 0; i < names.length; ++i) {
                newitem = new FolderItem(this.parent, item.getPath().getAbsolutePath(), names[i], item);
                newitem.setState(1);
                if (this.loadChildren(newitem) <= 0) continue;
                newitem.setStyle(this.parentStyle);
            }
        }
        return names.length;
    }

    public static void sortStringArray(String[] array) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < array.length; ++i) {
            vector.addElement(array[i]);
        }
        SortVector sortvector = new SortVector(vector, new FolderSort());
        for (int j = 0; j < vector.size(); ++j) {
            array[j] = new String((String)vector.elementAt(j));
        }
    }

    public File getCurrentPath() {
        FolderItem item = this.getCurrent();
        File path = null;
        if (item != null) {
            path = item.getPath();
        }
        return path;
    }

    public FolderItem getCurrent() {
        JCOutlinerNode node = this.getSelectedNode();
        FolderItem current = null;
        if (node != null) {
            current = (FolderItem)node;
        }
        return current;
    }

    public FolderItem getTrashFolder() {
        FolderItem item = (FolderItem)this.getRootNode();
        FolderItem val = null;
        JCVector children = null;
        if (item != null && (children = item.getChildren()).size() > 0) {
            for (int i = 0; i < children.size() && (val = this.getTrashFolder((FolderItem)children.elementAt(i))) == null; ++i) {
            }
        }
        return val;
    }

    public FolderItem getTrashFolder(FolderItem val) {
        FolderItem found = null;
        JCVector children = null;
        if (val != null && val.isTrash()) {
            found = val;
        } else {
            children = val.getChildren();
            if (children != null && children.size() > 0) {
                for (int i = 0; i < children.size(); ++i) {
                    val = this.getTrashFolder((FolderItem)children.elementAt(i));
                    if (val == null) continue;
                    found = val;
                    break;
                }
            }
        }
        return found;
    }

    public void selectFirst() {
        FolderItem item = (FolderItem)this.rootNode.getChildren().getFirst();
        if (item != null) {
            this.selectNode(item, null);
        }
    }

    public FolderItem FindLeaf(String fpath) {
        FolderItem item = (FolderItem)this.getRootNode();
        FolderItem val = null;
        JCVector children = null;
        if (item != null && (children = item.getChildren()).size() > 0) {
            for (int i = 0; i < children.size() && (val = this.FindLeaf((FolderItem)children.elementAt(i), fpath)) == null; ++i) {
            }
        }
        return val;
    }

    public FolderItem FindLeaf(FolderItem val, String fpath) {
        FolderItem found = null;
        JCVector children = null;
        if (val != null && val.getPath().getAbsolutePath().equalsIgnoreCase(fpath)) {
            found = val;
        } else {
            children = val.getChildren();
            if (children != null && children.size() > 0) {
                for (int i = 0; i < children.size(); ++i) {
                    val = this.FindLeaf((FolderItem)children.elementAt(i), fpath);
                    if (val == null) continue;
                    found = val;
                    break;
                }
            }
        }
        return found;
    }

    public FolderItem getOutbasketFolder() {
        FolderItem current = this.FindLeaf(this.outbasketDir.getAbsolutePath());
        return current;
    }

    public FolderItem getInbasketFolder() {
        FolderItem current = this.FindLeaf(this.inbasketDir.getAbsolutePath());
        return current;
    }

    public FolderItem getFolderRootNode() {
        return this.rootNode;
    }

    public void createFolder(jstreet Jstreet) {
        CreateFolder createfolder = new CreateFolder(this.parent, this.mainDir, "Create a New Folder");
        createfolder.show();
        if (createfolder.ret_code) {
            if (Jstreet != null) {
                Jstreet.folderlist.createFolder(createfolder);
            }
            FolderItem newitem = new FolderItem(this.parent, createfolder.getFolderDir(), createfolder.getFolderName(), this.rootNode);
            if (createfolder.getRemote()) {
                newitem.setLabel(String.valueOf(String.valueOf(String.valueOf(String.valueOf(createfolder.getFolderName()).concat(String.valueOf(" ("))).concat(String.valueOf(createfolder.getDir()))).concat(String.valueOf(File.separator))).concat(String.valueOf(")")));
            }
            if (this.loadChildren(newitem) > 0) {
                newitem.setStyle(this.parentStyle);
            }
            newitem.setState(1);
            this.folderChanged(newitem);
            this.repaint();
            if (!this.notify) {
                this.setFocusNode(newitem, null);
            }
        }
    }

    public void createFolder(CreateFolder createfolder) {
        FolderItem newitem = new FolderItem(this.parent, createfolder.getFolderDir(), createfolder.getFolderName(), this.rootNode);
        if (createfolder.getRemote()) {
            newitem.setLabel(String.valueOf(String.valueOf(String.valueOf(String.valueOf(createfolder.getFolderName()).concat(String.valueOf(" ("))).concat(String.valueOf(createfolder.getDir()))).concat(String.valueOf(File.separator))).concat(String.valueOf(")")));
        }
        if (this.loadChildren(newitem) > 0) {
            newitem.setStyle(this.parentStyle);
        }
        newitem.setState(1);
        this.folderChanged(newitem);
        this.repaint();
    }

    public void createSubFolder(jstreet Jstreet) {
        FolderItem item = (FolderItem)this.getSelectedNode();
        if (item != null) {
            String name = new String(item.getName());
            String title = new String(String.valueOf(String.valueOf("Create a Subfolder Under [").concat(String.valueOf(item.getLabel()))).concat(String.valueOf("]")));
            CreateFolder createfolder = new CreateFolder(this.parent, item.getPath(), title);
            createfolder.show();
            if (createfolder.ret_code) {
                if (Jstreet != null) {
                    Jstreet.folderlist.createSubFolder(createfolder, item);
                }
                item.setState(5);
                FolderItem newitem = new FolderItem(this.parent, item.getPath().getAbsolutePath(), createfolder.getFolderName(), item);
                this.setBatched(true);
                newitem.setState(1);
                this.setBatched(false);
                item.setStyle(this.parentStyle);
                this.folderChanged(newitem);
                this.repaint();
                this.makeNodeVisible(newitem);
                if (!this.notify) {
                    this.setFocusNode(newitem, null);
                }
            }
        } else {
            MsgBox msgBox = new MsgBox(this.parent, "No folder is currently selected.");
        }
    }

    public void createSubFolder(CreateFolder createfolder, FolderItem item) {
        FolderItem fitem = this.FindLeaf(item.getPath().getAbsolutePath());
        if (fitem != null) {
            FolderItem newitem = new FolderItem(this.parent, createfolder.getFolderDir(), createfolder.getFolderName(), fitem);
            if (this.loadChildren(newitem) > 0) {
                newitem.setStyle(this.parentStyle);
            }
            newitem.setState(1);
            fitem.setStyle(this.parentStyle);
            this.folderChanged(newitem);
            this.repaint();
        }
    }

    public boolean deleteFolder(FolderItem folder) {
        boolean ret_code = false;
        FolderItem parent = (FolderItem)folder.getParent();
        this.setBatched(true);
        ret_code = folder.delete();
        if (ret_code && parent != null) {
            if (folder.isSpecial()) {
                folder.removeChildren();
                folder.setStyle(this.defStyle);
                this.parent.notelist.reload();
            } else {
                parent.removeChild(folder);
                folder = null;
                this.selectNode(null, null);
                if (parent.getChildren() == null || parent.getChildren().size() == 0) {
                    parent.setStyle(this.defStyle);
                }
                System.gc();
            }
        } else if (!ret_code) {
            MsgBox msgBox = new MsgBox(this.parent, "The folder could not be deleted.  Make sure that another process is not using this directory and try again.");
        }
        this.setBatched(false);
        this.repaint();
        return ret_code;
    }

    public void addRemoteFolders(Vector vector) {
        RemoteFolderIndex findex = new RemoteFolderIndex(this.parent);
        Folder fldr = null;
        String dir = null;
        for (int i = 0; i < findex.size(); ++i) {
            dir = findex.getFolder(i);
            fldr = new Folder(new File(findex.getFolder(i)), findex.getFolderName(i));
            fldr.setRemote(true);
            vector.addElement(fldr);
        }
    }

    public void loadRemoteFolders(FolderItem olditem) {
        RemoteFolderIndex findex = new RemoteFolderIndex(this.parent);
        for (int i = 0; i < findex.size(); ++i) {
            FolderItem newitem = new FolderItem(this.parent, new File(findex.getFolder(i)), findex.getFolderName(i), this.rootNode);
            newitem.setLabel(String.valueOf(findex.getFolderName(i)).concat(String.valueOf(" (remote)")));
            newitem.setState(1);
            if (this.loadChildren(newitem) <= 0) continue;
            newitem.setStyle(this.parentStyle);
        }
        findex = null;
    }

    public void uncatalogFolder(FolderItem folder) {
        folder.deleteSettings();
        RemoteFolderIndex findex = new RemoteFolderIndex(this.parent);
        findex.delete(folder.getPath());
        this.setBatched(true);
        folder.getParent().removeChild(folder);
        this.setBatched(false);
        this.repaint();
    }

    public String[] ReadAllLines(BufferedReader in) {
        String text = null;
        String[] recs = new String[]{};
        int lines = 0;
        try {
            in.mark(102400);
            do {
                if ((text = in.readLine()) == null) continue;
                ++lines;
            } while (text != null);
            in.reset();
            recs = new String[lines];
            for (int i = 0; i < lines; ++i) {
                recs[i] = in.readLine();
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return recs;
    }

    public void clear() {
        this.rootNode = new FolderItem(this.parent, new String(""), new String(""));
        this.setRootNode(this.rootNode);
    }

    public String genMonthFolder() {
        Calendar date = Calendar.getInstance();
        String fn = new String(String.valueOf(String.valueOf("").concat(String.valueOf(date.get(1)))).concat(String.valueOf(Compose.findMonth(date.get(2) + 1))));
        File dir = new File(String.valueOf(String.valueOf(this.parent.getAccountDir()).concat(String.valueOf(File.separator))).concat(String.valueOf(fn)));
        if (!dir.exists()) {
            dir.mkdir();
            this.setBatched(true);
            FolderItem newitem = new FolderItem(this.parent, this.parent.getAccountDir(), fn, (FolderItem)this.getRootNode());
            newitem.setState(1);
            this.setBatched(false);
            this.repaint();
        }
        return dir.getAbsolutePath();
    }

    public String genFolder(String path) {
        File dir = new File(path);
        String tpath = dir.getPath();
        int spot = tpath.lastIndexOf(File.separator);
        if (dir.exists() || dir.mkdir()) {
            this.setBatched(true);
            if (spot >= 0) {
                tpath = new String(tpath.substring(0, spot));
            }
            FolderItem newitem = new FolderItem(this.parent, tpath, dir.getName(), (FolderItem)this.getRootNode());
            newitem.setState(1);
            this.setBatched(false);
            this.repaint();
        }
        return dir.getAbsolutePath();
    }
}

