/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderIndexItem;
import innoval.mailer.PopFileFilter;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PopFileReader;
import innoval.mailer.PopFileWriter;
import innoval.mailer.jstreet;
import java.awt.Frame;
import java.io.File;
import java.util.Vector;

public class FolderIndex {
    static final int SUBJECT = 1;
    static final int FROM = 2;
    static final int TO = 3;
    static final int DATE = 4;
    static final int POPFILE = 5;
    static final int FILEFOLDER = 6;
    private File file;
    private File dir;
    boolean changed = false;
    boolean corrupted = false;
    boolean doorOpened = false;
    private Frame parent;
    Vector vPopName = new Vector();
    Vector vItem = new Vector();

    FolderIndex(Frame parent, String dir) {
        this.parent = parent;
        this.dir = new File(dir);
        this.file = new File(dir, jstreet.INDEXFILE);
    }

    public void setDirty(boolean val) {
        this.changed = val;
    }

    public File getDir() {
        return this.dir;
    }

    public File getIndex() {
        return this.file;
    }

    public void deleteIndex() {
        this.file.delete();
    }

    public String getPopName(int index) {
        if (index < this.vPopName.size()) {
            return (String)this.vPopName.elementAt(index);
        }
        return null;
    }

    public String getListString(int index, boolean vfolder) {
        String x = "";
        if (index >= 0 && index < this.vItem.size()) {
            FolderIndexItem item = (FolderIndexItem)this.vItem.elementAt(index);
            x = item.toString(vfolder);
        }
        return x;
    }

    public int loadIndex() {
        this.openDoor();
        FolderIndexItem item = null;
        this.clearIndex();
        String x = "";
        String pname = "";
        if (this.file.exists()) {
            PopFileReader inxIn = new PopFileReader();
            inxIn.open(this.file);
            block3: while (x != null) {
                x = inxIn.lineIn();
                if (x == null || x.length() <= 2) continue;
                switch (x.charAt(0)) {
                    case 'P': {
                        pname = new String(x.substring(2));
                        this.vPopName.addElement(pname);
                        item = new FolderIndexItem();
                        item.setPopName(pname);
                        this.vItem.addElement(item);
                        continue block3;
                    }
                }
                if (item == null) continue;
                this.corrupted = item.resolveValue(x.charAt(0), x.substring(2));
            }
            inxIn.close();
            if (this.corrupted) {
                this.clearIndex();
            }
        }
        this.takeInventory();
        this.saveIndex();
        this.closeDoor();
        return this.vItem.size();
    }

    public void saveIndex() {
        if (this.changed) {
            this.writeIndexFile();
            this.changed = false;
        }
    }

    public void writeIndexFile() {
        PopFileWriter inxOut = new PopFileWriter();
        FolderIndexItem item = null;
        inxOut.open(this.file);
        for (int i = 0; i < this.vItem.size(); ++i) {
            item = (FolderIndexItem)this.vItem.elementAt(i);
            inxOut.lineOut(item.writeString());
        }
        inxOut.close();
        inxOut = null;
    }

    public void appendToIndexFile(File popfile) {
        PopFileWriter inxOut = new PopFileWriter();
        FolderIndexItem item = null;
        PopFileProcedure pop = new PopFileProcedure();
        this.openDoor();
        this.changed = true;
        pop.readHeaders(popfile);
        item = new FolderIndexItem(pop);
        item.checked = true;
        item.setPopName(popfile.getName());
        inxOut.openAppend(this.file);
        inxOut.lineOut(item.writeString());
        inxOut.close();
        pop = null;
        item = null;
        inxOut = null;
        this.closeDoor();
    }

    public void appendToIndexFile(FolderIndexItem item) {
        PopFileWriter inxOut = new PopFileWriter();
        this.openDoor();
        this.changed = true;
        inxOut.openAppend(this.file);
        inxOut.lineOut(item.writeString());
        inxOut.close();
        inxOut = null;
        this.closeDoor();
    }

    public int getItemNumber(String popName) {
        return this.vPopName.indexOf(popName);
    }

    public void clearIndex() {
        this.vPopName.setSize(0);
        this.vItem.setSize(0);
    }

    private void takeInventory() {
        String[] filteredList = this.dir.list(new PopFileFilter());
        PopFileProcedure pop = null;
        FolderIndexItem item = null;
        for (int i = 0; i < filteredList.length; ++i) {
            int n = this.vPopName.indexOf(filteredList[i]);
            if (n >= 0) {
                item = (FolderIndexItem)this.vItem.elementAt(n);
                item.checked = true;
                continue;
            }
            pop = null;
            pop = new PopFileProcedure();
            pop.readHeaders(new File(this.dir, filteredList[i]));
            this.addToIndex(pop);
        }
        for (int j = this.vItem.size() - 1; j >= 0; --j) {
            item = (FolderIndexItem)this.vItem.elementAt(j);
            if (item.checked) continue;
            this.removeFromIndex(j);
        }
    }

    public void removeFromIndex(String popName) {
        this.openDoor();
        this.sayLine(String.valueOf("Removing from index: ").concat(String.valueOf(popName)));
        this.changed = true;
        int n = this.getItemNumber(popName);
        if (n >= 0) {
            this.removeFromIndex(n);
            this.sayLine("Item removed...");
        }
        this.closeDoor();
    }

    public void removeFromIndex(String popName, String dir) {
        this.sayLine(String.valueOf("Removing from index: ").concat(String.valueOf(popName)));
        int n = this.getItemIndex(popName, dir);
        this.openDoor();
        if (n >= 0) {
            this.removeFromIndex(n);
            this.sayLine("Item removed...");
            this.changed = true;
        }
        this.closeDoor();
    }

    public void removeFromIndex(int item) {
        this.vPopName.removeElementAt(item);
        this.vItem.removeElementAt(item);
    }

    public FolderIndexItem addToIndex(PopFileProcedure pop) {
        FolderIndexItem item = null;
        String pfile = pop.getPopFile().getName();
        if (pfile.length() > 12) {
            pfile = new String(pfile.substring(0, 12));
        }
        this.changed = true;
        this.vPopName.addElement(pfile);
        item = new FolderIndexItem(pop);
        item.checked = true;
        item.setPopName(pfile);
        this.vItem.addElement(item);
        return item;
    }

    public void addToIndex(FolderIndexItem item) {
        this.changed = true;
        this.vPopName.addElement(item.getPopName());
        this.vItem.addElement(item);
    }

    public void updateIndex(PopFileProcedure pop) {
        this.openDoor();
        int n = this.getItemNumber(pop.getPopFile().getName());
        if (n >= 0) {
            FolderIndexItem item = (FolderIndexItem)this.vItem.elementAt(n);
            this.changed = true;
            item.updateItem(pop);
        }
        this.closeDoor();
    }

    public void setOpened(String fname) {
        this.openDoor();
        int n = this.getItemNumber(fname);
        if (n >= 0) {
            this.changed = true;
            FolderIndexItem item = (FolderIndexItem)this.vItem.elementAt(n);
            item.opened = true;
        }
        this.closeDoor();
    }

    public void setOpened(int n) {
        this.openDoor();
        if (n >= 0) {
            this.changed = true;
            ((FolderIndexItem)this.vItem.elementAt((int)n)).opened = true;
        }
        this.closeDoor();
    }

    public void setOpened(int n, boolean open) {
        this.openDoor();
        if (n >= 0) {
            this.changed = true;
            ((FolderIndexItem)this.vItem.elementAt((int)n)).opened = open;
        }
        this.closeDoor();
    }

    public void setColorCode(int n, int code) {
        this.openDoor();
        if (n >= 0) {
            this.changed = true;
            ((FolderIndexItem)this.vItem.elementAt((int)n)).colorcode = code;
        }
        this.closeDoor();
    }

    public void sayLine(String text) {
    }

    public FolderIndexItem getIndexItem(String popname) {
        this.sayLine("Getting folder index item...");
        this.openDoor();
        int n = this.getItemNumber(popname);
        FolderIndexItem item = null;
        if (n >= 0 && n < this.vItem.size()) {
            item = (FolderIndexItem)this.vItem.elementAt(n);
        }
        this.closeDoor();
        this.sayLine("Got folder index item...");
        return item;
    }

    public FolderIndexItem getIndexItem(String popname, String dir) {
        this.openDoor();
        int n = -1;
        FolderIndexItem titem = null;
        FolderIndexItem item = null;
        while ((n = n < 0 ? this.vPopName.indexOf(popname) : this.vPopName.indexOf(popname, n + 1)) >= 0 && n < this.vItem.size()) {
            titem = (FolderIndexItem)this.vItem.elementAt(n);
            if (titem.getDirName().equals(dir)) {
                item = titem;
            }
            if (item == null) continue;
        }
        this.closeDoor();
        return item;
    }

    public int getItemIndex(String popname, String dir) {
        this.openDoor();
        int n = -1;
        FolderIndexItem titem = null;
        FolderIndexItem item = null;
        while ((n = n < 0 ? this.vPopName.indexOf(popname) : this.vPopName.indexOf(popname, n + 1)) >= 0 && n < this.vItem.size()) {
            titem = (FolderIndexItem)this.vItem.elementAt(n);
            if (titem.getDirName().equals(dir)) {
                item = titem;
            }
            if (item == null) continue;
        }
        this.closeDoor();
        if (item == null) {
            n = -1;
        }
        return n;
    }

    public FolderIndexItem getIndexItem(int n) {
        this.openDoor();
        FolderIndexItem item = null;
        if (n >= 0 && n < this.vItem.size()) {
            item = (FolderIndexItem)this.vItem.elementAt(n);
        }
        this.closeDoor();
        return item;
    }

    public boolean isOpened(int n) {
        this.openDoor();
        boolean ret_code = false;
        if (n >= 0 && n < this.vItem.size()) {
            ret_code = ((FolderIndexItem)this.vItem.elementAt((int)n)).opened;
        }
        this.closeDoor();
        return ret_code;
    }

    public void updateIndexItem(FolderIndexItem item) {
        FolderIndexItem nitem = this.getIndexItem(item.getPopName());
        if (nitem != null) {
            nitem.update(item);
        } else {
            this.vPopName.addElement(item.getPopName());
            this.vItem.addElement(item);
        }
    }

    public static int countMessages(File dir) {
        int count = 0;
        String[] filteredList = dir.list(new PopFileFilter());
        if (filteredList != null) {
            count = filteredList.length;
        }
        return count;
    }

    private synchronized void openDoor() {
        this.sayLine("Opening folder index door...");
        try {
            if (this.doorOpened) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            System.out.println(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        this.doorOpened = true;
        this.sayLine("Folder index door opened...");
    }

    private synchronized void closeDoor() {
        this.sayLine("Closing folder index door...");
        this.doorOpened = false;
        this.notifyAll();
        this.sayLine("Folder index door closed...");
    }
}

