/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.RemoteFolderIndex;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class CreateFolder
extends Dialog
implements KeyListener,
ActionListener {
    private String name;
    public boolean ret_code;
    public boolean remote;
    private jstreet parent;
    private Button okButton;
    private Button cancelButton;
    private String folderName;
    private String folderDir;
    private File maindir;
    private TextField nameField;
    private TextField dirField;

    CreateFolder(jstreet parent, File maindir, String title) {
        super(parent, title, true);
        this.parent = parent;
        this.maindir = maindir;
        this.ret_code = false;
        this.name = new String("");
        this.initDialog();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 15, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 150, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Folder Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.nameField = new TextField();
        this.nameField.addKeyListener(this);
        this.add(this.nameField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.nameField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
        this.enableEvents(64L);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getFolderDir() {
        return this.folderDir;
    }

    public String getDir() {
        String text = new String(this.folderDir);
        int spot = text.lastIndexOf(File.separator);
        if (spot >= 0) {
            text = new String(text.substring(0, spot));
        }
        return text;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            File file = null;
            MsgBox msgbox = null;
            this.name = new String(this.nameField.getText());
            if (this.name.length() == 0 || !this.validFolderName(this.name)) {
                msgbox = this.name.length() == 0 ? new MsgBox(this.parent, "Please specify a folder name.") : new MsgBox(this.parent, "The specified folder name is not valid.");
                this.nameField.requestFocus();
                this.ret_code = false;
            } else if (this.name.indexOf(File.separator) >= 0) {
                RemoteFolderIndex findex;
                file = new File(this.name);
                if (file.exists()) {
                    findex = new RemoteFolderIndex(this.parent);
                    this.remote = true;
                    this.ret_code = findex.add(file);
                } else {
                    msgbox = new MsgBox((Container)this.parent, "The specified folder directory does not exist.  Would you like to create this directory?", 2);
                    if (msgbox.ret_code == 0) {
                        if (file.mkdir()) {
                            findex = new RemoteFolderIndex(this.parent);
                            this.remote = true;
                            this.ret_code = findex.add(file);
                        } else {
                            msgbox = new MsgBox(this.parent, "The specified folder could not be created.");
                        }
                    }
                }
            } else {
                file = new File(this.maindir.getAbsolutePath(), this.name);
                if (file.isDirectory()) {
                    msgbox = new MsgBox(this.parent, "The specified folder already exists.");
                    this.nameField.requestFocus();
                    this.ret_code = false;
                } else if (file.mkdir()) {
                    this.ret_code = true;
                } else {
                    msgbox = new MsgBox(this.parent, "The specified folder could not be created.");
                }
            }
            if (this.ret_code) {
                String dir = new String(file.getAbsolutePath());
                String name = dir.substring(dir.lastIndexOf(File.separator) + 1);
                this.folderDir = new String(dir.substring(0, dir.lastIndexOf(File.separator)));
                this.folderName = new String(name);
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public boolean getRemote() {
        return this.remote;
    }

    public boolean validFolderName(String text) {
        boolean ret_code = true;
        if (this.parent.isFAT()) {
            String name = null;
            int spot = text.indexOf(File.separator);
            name = spot >= 0 ? text.substring(spot + 1) : text;
            if (name.length() > 8) {
                ret_code = false;
            }
        }
        return ret_code;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

