/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.Imap4;
import innoval.mail.Imap4Cmd;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class Imap4ResponseThread
extends Thread {
    private Imap4 imap;
    private BufferedReader in = null;
    private boolean quit = false;

    Imap4ResponseThread(Imap4 imap) {
        this.imap = imap;
    }

    public void run() {
        this.setPriority(5);
        if (this.setupIn()) {
            char[] buffer = new char[1024];
            int buflen = 0;
            StringBuffer sb = new StringBuffer(1024);
            try {
                while (!this.quit) {
                    buflen = this.in.read(buffer, 0, buffer.length);
                    if (buflen <= 0) continue;
                    sb.append(buffer, 0, buflen);
                    sb = this.examineText(sb);
                }
            }
            catch (IOException e) {
                this.imap.setException(e.toString());
            }
        }
    }

    private boolean setupIn() {
        boolean ret_code = false;
        try {
            this.in = new BufferedReader(new InputStreamReader(this.imap.getSocket().getInputStream()));
            ret_code = true;
        }
        catch (IOException e) {
            this.imap.setException(e.toString());
        }
        return ret_code;
    }

    private StringBuffer examineText(StringBuffer sb) {
        String text = sb.toString();
        String line = null;
        int start = 0;
        int spot = text.indexOf("\r\n");
        if (spot >= 0) {
            while (spot >= 0) {
                line = new String(text.substring(start, spot));
                this.imap.setDebugText(line);
                if (!this.commandText(line)) {
                    this.imap.hostCmds.addElement(line);
                }
                start = spot + 2;
                spot = text.indexOf("\r\n", start);
            }
            sb = null;
            sb = new StringBuffer(text.substring(start));
        }
        return sb;
    }

    private boolean commandText(String line) {
        boolean ret_code = true;
        if (this.imap.openCmds.size() > 0) {
            Imap4Cmd cmd = (Imap4Cmd)this.imap.openCmds.elementAt(0);
            cmd.add(line);
            if (cmd.getStatus() == 1) {
                this.imap.openCmds.removeElementAt(0);
            }
        } else {
            ret_code = false;
        }
        return ret_code;
    }
}

