/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.DocFrameInfo;
import ice.htmlbrowser.Document;
import java.util.Vector;

class DocFramesetInfo
extends DocFrameInfo {
    private int[] colValues;
    private int[] colTypes;
    private int[] rowValues;
    private int[] rowTypes;
    private Vector frames = new Vector();

    DocFramesetInfo(int[] colValues, int[] colTypes, int[] rowValues, int[] rowTypes) {
        this.colValues = colValues;
        this.colTypes = colTypes;
        this.rowValues = rowValues;
        this.rowTypes = rowTypes;
    }

    void addFrame(DocFrameInfo frame) {
        if (this.frames.size() < this.colValues.length * this.rowValues.length) {
            this.frames.addElement(frame);
        }
    }

    void doLayout(int x, int y, int w, int h) {
        int s;
        int i;
        int[] pix_cols = new int[this.colValues.length];
        int[] pix_rows = new int[this.rowValues.length];
        int rest_size = w;
        int relCount = 0;
        for (i = 0; i < this.colValues.length; ++i) {
            if (this.colTypes[i] == 1) {
                s = this.colValues[i] * w / 100;
                rest_size -= s;
                pix_cols[i] = s;
                continue;
            }
            if (this.colTypes[i] == 2) {
                relCount += this.colValues[i];
                pix_cols[i] = 0;
                continue;
            }
            rest_size -= this.colValues[i];
            pix_cols[i] = this.colValues[i];
        }
        if (rest_size > 0 && relCount > 0) {
            for (i = 0; i < this.colValues.length; ++i) {
                if (this.colTypes[i] != 2) continue;
                pix_cols[i] = rest_size * this.colValues[i] / relCount;
            }
        } else if (rest_size != 0) {
            for (i = 0; i < this.colValues.length; ++i) {
                int n = i;
                pix_cols[n] = pix_cols[n] + rest_size * pix_cols[i] / (w - rest_size);
            }
        }
        rest_size = h;
        relCount = 0;
        for (i = 0; i < this.rowValues.length; ++i) {
            if (this.rowTypes[i] == 1) {
                s = this.rowValues[i] * h / 100;
                rest_size -= s;
                pix_rows[i] = s;
                continue;
            }
            if (this.rowTypes[i] == 2) {
                relCount += this.rowValues[i];
                pix_rows[i] = 0;
                continue;
            }
            rest_size -= this.rowValues[i];
            pix_rows[i] = this.rowValues[i];
        }
        if (rest_size > 0 && relCount > 0) {
            for (i = 0; i < this.rowValues.length; ++i) {
                if (this.rowTypes[i] != 2) continue;
                pix_rows[i] = rest_size * this.rowValues[i] / relCount;
            }
        } else if (rest_size != 0) {
            for (i = 0; i < this.rowValues.length; ++i) {
                int n = i;
                pix_rows[n] = pix_rows[n] + rest_size * pix_rows[i] / (h - rest_size);
            }
        }
        int num_frames = this.frames.size();
        int col = 0;
        int row = 0;
        int ox = x;
        int oy = y;
        for (i = 0; i < num_frames; ++i) {
            DocFrameInfo f = (DocFrameInfo)this.frames.elementAt(i);
            f.doLayout(ox, oy, pix_cols[col], pix_rows[row]);
            ox += pix_cols[col];
            if (++col < pix_cols.length) continue;
            col = 0;
            ox = x;
            oy += pix_rows[row];
            ++row;
        }
    }

    void showDocument(Document parent) {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            ((DocFrameInfo)this.frames.elementAt(i)).showDocument(parent);
        }
    }

    void hideDocument() {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            ((DocFrameInfo)this.frames.elementAt(i)).hideDocument();
        }
    }

    DocFrameInfo findDocFrame(String targetFrame) {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            DocFrameInfo df = (DocFrameInfo)this.frames.elementAt(i);
            if ((df = df.findDocFrame(targetFrame)) == null) continue;
            return df;
        }
        return null;
    }

    boolean goBack(String targetFrame) {
        boolean flag = false;
        int n = this.frames.size();
        for (int i = 0; i < n && !flag; ++i) {
            DocFrameInfo df = (DocFrameInfo)this.frames.elementAt(i);
            flag = df.goBack(targetFrame);
        }
        return flag;
    }

    boolean goForward(String targetFrame) {
        boolean flag = false;
        int n = this.frames.size();
        for (int i = 0; i < n && !flag; ++i) {
            DocFrameInfo df = (DocFrameInfo)this.frames.elementAt(i);
            flag = df.goForward(targetFrame);
        }
        return flag;
    }
}

