/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.Document;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;

class BrowserDemo
extends Frame
implements ActionListener,
WindowListener {
    private Properties printProp = new Properties();
    private Browser bb;
    private String start_loc;

    public BrowserDemo() {
        this("http://");
    }

    public BrowserDemo(String loc) {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        m.add("Save");
        m.add("Load");
        m.add("Save doc");
        m.add("Load doc");
        m.add("Print");
        mb.add(m);
        this.setMenuBar(mb);
        m.addActionListener(this);
        this.start_loc = loc;
        this.setLayout(new BorderLayout());
        this.bb = new Browser();
        this.add("Center", this.bb);
        this.addWindowListener(this);
    }

    public void addNotify() {
        super.addNotify();
        if (this.start_loc != null) {
            this.bb.gotoLocation(this.start_loc);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("Save".equals(cmd)) {
            this.saveSer();
        } else if ("Load".equals(cmd)) {
            this.loadSer();
        } else if ("Save doc".equals(cmd)) {
            this.saveDocSer();
        } else if ("Load doc".equals(cmd)) {
            this.loadDocSer();
        } else if ("Print".equals(cmd)) {
            this.printDoc();
        }
    }

    private void printDoc() {
        PrintJob pj = this.getToolkit().getPrintJob(this, "ICE Browser", this.printProp);
        if (pj != null) {
            this.bb.printDoc(pj);
            pj.end();
        }
    }

    private void saveDocSer() {
        try {
            FileOutputStream fos = new FileOutputStream("Document.ser");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.bb.doc);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("BrowserControl : cannot serialize Document");
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
            ioe.printStackTrace();
        }
    }

    private void loadDocSer() {
        try {
            FileInputStream fis = new FileInputStream("Document.ser");
            ObjectInputStream ois = new ObjectInputStream(fis);
            Document newdoc = (Document)ois.readObject();
            ois.close();
            fis.close();
            this.bb.replaceDocument(newdoc);
        }
        catch (Exception ioe) {
            System.err.println("BrowserControl : cannot read serialized Document");
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
            ioe.printStackTrace();
            return;
        }
    }

    private void saveSer() {
        try {
            FileOutputStream fos = new FileOutputStream("Browser.ser");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.bb);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("BrowserControl : cannot serialize Browser");
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
            ioe.printStackTrace();
        }
    }

    private void loadSer() {
        Browser newbb;
        try {
            FileInputStream fis = new FileInputStream("Browser.ser");
            ObjectInputStream ois = new ObjectInputStream(fis);
            newbb = (Browser)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception ioe) {
            System.err.println("BrowserControl : cannot read serialized Browser");
            System.err.println(String.valueOf("          ").concat(String.valueOf(ioe.getMessage())));
            ioe.printStackTrace();
            return;
        }
        this.remove(this.bb);
        this.bb = newbb;
        this.add("Center", this.bb);
        this.validate();
    }

    public void windowClosing(WindowEvent e) {
        System.out.println("WindowClosing event received");
        System.exit(0);
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }
}

