/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.BoxTableCell;
import ice.htmlbrowser.CellInfo;
import ice.htmlbrowser.DocContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

class BoxTable
extends Box
implements ActiveBox {
    private Vector CellInfos;
    private int cur_row;
    private int cur_col;
    private int numRows;
    private int numCols;
    private BoxTableCell cur_cell;
    private int row_align = 0;
    private int row_valign = 2;
    private int table_width;
    private int border_size;
    private int cell_spacing = 3;
    private int cell_padding = 1;
    private int[] colCoord;
    private int[] rowCoord;
    private int[] colWidth;
    private int[] rowHeight;
    private CellInfo[] colMax;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final int ALIGN_MIDDLE = 2;

    BoxTable(DocContainer d, int t_width, int b_size) {
        super(d);
        this.table_width = t_width;
        this.border_size = b_size;
        this.cur_row = -1;
        this.cur_col = 0;
        this.numCols = 0;
        this.numRows = 0;
        this.cur_cell = null;
        this.CellInfos = new Vector();
    }

    void setRowAlign(int a) {
        this.row_align = a;
    }

    void setRowVAlign(int a) {
        this.row_valign = a;
    }

    void setCellNoWrap() {
        if (this.cur_cell != null) {
            int i = this.CellInfos.size() - 1;
            ((CellInfo)this.CellInfos.elementAt((int)i)).no_wrap = true;
        }
    }

    void setCellAlign(int a) {
        if (this.cur_cell != null) {
            BoxLineBreak b = new BoxLineBreak(this.doc);
            if (a == 2) {
                b.setAttrib(2);
            } else if (a == 1) {
                b.setAttrib(3);
            } else {
                b.setAttrib(1);
            }
            this.doc.addBox(b);
        }
    }

    void setCellVAlign(int a) {
        if (this.cur_cell != null) {
            int i = this.CellInfos.size() - 1;
            ((CellInfo)this.CellInfos.elementAt((int)i)).valign = a;
        }
    }

    void setCellColor(Color c) {
        if (this.cur_cell != null) {
            int i = this.CellInfos.size() - 1;
            ((CellInfo)this.CellInfos.elementAt((int)i)).color = c;
        }
    }

    void setCellSpacing(int s) {
        this.cell_spacing = s;
    }

    void setCellPadding(int p) {
        this.cell_padding = p;
    }

    void addTableRow() {
        ++this.cur_row;
        this.cur_col = 0;
        this.cur_cell = null;
        this.row_align = 0;
        this.row_valign = 2;
    }

    void addTableCell(int cspan, int rspan, int set_width) {
        CellInfo ci;
        if (this.cur_row < 0) {
            this.cur_row = 0;
        }
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            ci = (CellInfo)this.CellInfos.elementAt(i);
            if (ci.row >= this.cur_row || ci.row + ci.rowspan <= this.cur_row || ci.col < this.cur_col || this.cur_col + cspan <= ci.col) continue;
            this.cur_col = ci.col + ci.colspan;
        }
        this.cur_cell = new BoxTableCell();
        ci = new CellInfo(this.cur_cell, this.cur_col, this.cur_row, cspan, rspan, set_width);
        this.CellInfos.addElement(ci);
        this.setCellAlign(this.row_align);
        this.setCellVAlign(this.row_valign);
        this.numRows = this.cur_row + 1;
        if (this.cur_col + 1 > this.numCols) {
            this.numCols = this.cur_col + 1;
        }
        this.cur_col += cspan;
    }

    void finishTable() {
        this.colWidth = new int[this.numCols];
        this.rowHeight = new int[this.numRows];
        this.colCoord = new int[this.numCols];
        this.rowCoord = new int[this.numRows];
        this.colMax = new CellInfo[this.numCols];
    }

    void addBox(Box b) {
        if (this.cur_cell == null) {
            this.addTableCell(1, 1, -1);
        }
        this.cur_cell.addBox(b);
    }

    void layout(int visWidth, boolean firstOnLine) {
        int j;
        int i;
        if (firstOnLine) {
            return;
        }
        for (i = 0; i < this.numCols; ++i) {
            this.colMax[i] = null;
            this.colWidth[i] = 0;
            this.colCoord[i] = 0;
        }
        for (i = 0; i < this.numRows; ++i) {
            this.rowHeight[i] = 0;
            this.rowCoord[i] = 0;
        }
        if (this.table_width < 0) {
            visWidth = -visWidth * this.table_width / 100;
        } else if (this.table_width > 0) {
            visWidth = this.table_width + (this.cell_spacing + this.cell_padding) * 2;
        }
        int n = this.CellInfos.size();
        for (i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            int cell_width = 0;
            if (ci.set_width < 0) {
                cell_width = -ci.set_width * visWidth / 100;
                ci.cell.fakeLayout();
            } else if (ci.set_width > 0) {
                cell_width = ci.set_width;
                ci.cell.fakeLayout();
            } else {
                ci.cell.layout(0, 0);
                cell_width = ci.cell.size().width;
            }
            int temp = cell_width;
            temp = ci.col + ci.colspan >= this.numCols ? (temp /= this.numCols - ci.col) : (temp /= ci.colspan);
            for (int j2 = 0; j2 < ci.colspan && ci.col + j2 < this.numCols; ++j2) {
                if (this.colMax[ci.col + j2] == null) {
                    this.colMax[ci.col + j2] = ci;
                }
                if (temp > this.colWidth[ci.col + j2]) {
                    this.colWidth[ci.col + j2] = temp;
                    this.colMax[ci.col + j2] = ci;
                    continue;
                }
                if (this.colMax[ci.col + j2] == null || ci.set_width == 0) continue;
                CellInfo m = this.colMax[ci.col + j2];
                if (m.colspan <= 1) continue;
                this.colWidth[ci.col + j2] = temp;
                this.colMax[ci.col + j2] = ci;
            }
        }
        int rest_width = this.cell_spacing + this.border_size * 2;
        for (i = 0; i < this.numCols; ++i) {
            rest_width += this.colWidth[i] + this.cell_spacing + this.cell_padding * 2;
        }
        rest_width = visWidth - 1 - rest_width;
        int totalResizableWidth = 0;
        for (i = 0; i < this.numCols; ++i) {
            CellInfo ci = this.colMax[i];
            if (ci == null || ci.set_width != 0) continue;
            totalResizableWidth += ci.cell.size().width;
        }
        if (rest_width > 0 && totalResizableWidth > 0) {
            for (i = 0; i < this.numCols && totalResizableWidth > 0; ++i) {
                CellInfo ci = this.colMax[i];
                if (ci == null || ci.set_width != 0) continue;
                for (j = i - 1; j >= 0 && this.colMax[j] != ci; --j) {
                }
                if (j >= 0) continue;
                int prev_width = ci.cell.size().width;
                int new_width = prev_width + rest_width * prev_width / totalResizableWidth;
                if (this.table_width != 0) {
                    ci.cell.layout(new_width, new_width);
                } else {
                    ci.cell.layout(new_width, 0);
                }
                int delta = ci.cell.size().width - prev_width;
                if (delta <= 0) continue;
                rest_width -= delta + 1;
                int n2 = i;
                this.colWidth[n2] = this.colWidth[n2] + (delta + 1);
                totalResizableWidth -= prev_width;
            }
        }
        for (i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            int cell_width = 0;
            if (ci.set_width < 0) {
                cell_width = -ci.set_width * visWidth / 100;
            } else if (ci.set_width > 0) {
                cell_width = ci.set_width;
            } else {
                for (j = 0; j < ci.colspan && ci.col + j < this.numCols; ++j) {
                    cell_width += this.colWidth[ci.col + j];
                }
            }
            ci.cell.layout(cell_width, cell_width);
            int temp = ci.cell.size().height / ci.rowspan;
            for (j = 0; j < ci.rowspan && ci.row + j < this.numRows; ++j) {
                if (temp <= this.rowHeight[ci.row + j]) continue;
                this.rowHeight[ci.row + j] = temp;
            }
        }
        int w = this.border_size + this.cell_spacing;
        int h = this.border_size + this.cell_spacing;
        for (i = 0; i < this.numCols; ++i) {
            this.colCoord[i] = w;
            int n3 = i;
            this.colWidth[n3] = this.colWidth[n3] + (this.cell_spacing + this.cell_padding * 2);
            w += this.colWidth[i];
        }
        for (i = 0; i < this.numRows; ++i) {
            this.rowCoord[i] = h;
            int n4 = i;
            this.rowHeight[n4] = this.rowHeight[n4] + (this.cell_spacing + this.cell_padding * 2);
            h += this.rowHeight[i];
        }
        this.resize(w += this.border_size, h += this.border_size);
    }

    void move(int x, int y) {
        super.move(x, y);
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            int dx = this.colCoord[ci.col] + x + this.cell_padding;
            int dy = this.rowCoord[ci.row] + y + this.cell_padding;
            ci.cell.translate(dx, dy);
        }
    }

    private int findFirstVisCell(int startIdx, int endIdx, int check_y) {
        while (endIdx - startIdx > 2) {
            int idx = (startIdx + endIdx) / 2;
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(idx);
            int y = this.rowCoord[ci.row] - this.cell_spacing;
            for (int j = 0; j < ci.rowspan && ci.row + j < this.numRows; ++j) {
                y += this.rowHeight[ci.row + j];
            }
            if (y < check_y) {
                startIdx = idx;
                continue;
            }
            endIdx = idx;
        }
        return startIdx;
    }

    void paint(Graphics g) {
        int i;
        Rectangle bounds = g.getClipBounds();
        g.setColor(this.color);
        int n = this.CellInfos.size();
        for (i = 0; i < this.border_size; ++i) {
            g.draw3DRect(i, i, this.width - i * 2 - 1, this.height - i * 2 - 1, true);
        }
        for (i = 0; i < n; ++i) {
            int j;
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            int x = this.colCoord[ci.col];
            int y = this.rowCoord[ci.row];
            int w = -this.cell_spacing;
            int h = -this.cell_spacing;
            for (j = 0; j < ci.colspan && ci.col + j < this.numCols; ++j) {
                w += this.colWidth[ci.col + j];
            }
            for (j = 0; j < ci.rowspan && ci.row + j < this.numRows; ++j) {
                h += this.rowHeight[ci.row + j];
            }
            if (bounds.x > x + w || bounds.y > y + h || x > bounds.x + bounds.width || y > bounds.y + bounds.height) continue;
            if (ci.color != null) {
                g.setColor(ci.color);
                g.fillRect(x, y, w, h);
            }
            g.setColor(this.color);
            if (this.border_size > 0) {
                g.draw3DRect(x - 1, y - 1, w + 1, h + 1, false);
            }
            w -= this.cell_padding * 2;
            int cell_h = ci.cell.size().height;
            ci.add_y = ci.valign == 2 ? (h - cell_h) / 2 : (ci.valign == 1 ? (h -= this.cell_padding * 2) - cell_h : 0);
            g.translate(x += this.cell_padding, (y += this.cell_padding) + ci.add_y);
            ci.cell.paint(g);
            g.translate(-x, -y - ci.add_y);
        }
    }

    Box mouseClicked(int mx, int my) {
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            int x = this.colCoord[ci.col] + this.cell_padding;
            int y = this.rowCoord[ci.row] + this.cell_padding + ci.add_y;
            int w = ci.cell.size().width;
            int h = ci.cell.size().height;
            if (mx < x || mx >= x + w || my < y || my >= y + h) continue;
            return ci.cell.mouseClicked(mx - x, my - y);
        }
        return null;
    }

    Box mouseMoved(int mx, int my) {
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            int x = this.colCoord[ci.col] + this.cell_padding;
            int y = this.rowCoord[ci.row] + this.cell_padding + ci.add_y;
            int w = ci.cell.size().width;
            int h = ci.cell.size().height;
            if (mx < x || mx >= x + w || my < y || my >= y + h) continue;
            return ci.cell.mouseMoved(mx - x, my - y);
        }
        return null;
    }

    public void activeShow() {
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            ci.cell.activeShow();
        }
    }

    public void activeHide() {
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            ci.cell.activeHide();
        }
    }

    public void activeInterrupt() {
        int n = this.CellInfos.size();
        for (int i = 0; i < n; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            ci.cell.activeInterrupt();
        }
    }

    void setColor(Color c) {
        if (c.equals(Color.white)) {
            c = c.darker().darker();
        }
        if (c.equals(Color.black)) {
            c = Color.white;
        }
        super.setColor(c);
    }

    Box getAnchorBox(String anchor) {
        Box theBox = super.getAnchorBox(anchor);
        if (theBox != null) {
            return theBox;
        }
        int n = this.CellInfos.size();
        for (int i = 0; i < n && theBox == null; ++i) {
            CellInfo ci = (CellInfo)this.CellInfos.elementAt(i);
            theBox = ci.cell.getAnchorBox(anchor);
        }
        return theBox;
    }
}

