/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.FormEntry;
import ice.htmlbrowser.FormInfo;
import ice.htmlbrowser.Queue;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.List;
import java.util.Vector;

class BoxSelect
extends Box
implements FormEntry {
    private String curOptionValue = null;
    private boolean curSelected = false;
    protected FormInfo form;
    private Component comp;
    private String name;
    private int defaultSelected = 0;
    private Vector optionValues = new Vector();
    private Thread addItemsThread;
    private Queue optionItems = new Queue();

    BoxSelect(DocContainer d, FormInfo form, String name, int visSize, boolean multiple) {
        super(d);
        this.form = form;
        this.name = name;
        this.comp = visSize > 1 ? new List(visSize, multiple) : new Choice();
        this.doc.setAWTComponent(this, this.comp);
    }

    void addOption(String value, boolean selected) {
        this.curOptionValue = value;
        this.curSelected = selected;
    }

    void addOptionText(String str) {
        if (this.curOptionValue == null) {
            this.curOptionValue = str;
        }
        this.optionValues.addElement(this.curOptionValue);
        if (this.curSelected) {
            this.defaultSelected = this.optionValues.size() - 1;
        }
        this.curOptionValue = null;
        this.curSelected = false;
        if (this.comp instanceof List) {
            List l = (List)this.comp;
            l.add(str);
            if (l.getItemCount() == this.defaultSelected + 1) {
                l.select(this.defaultSelected);
            }
        } else if (this.comp instanceof Choice) {
            Choice c = (Choice)this.comp;
            c.add(str);
            if (c.getItemCount() == this.defaultSelected + 1) {
                c.select(this.defaultSelected);
            }
        }
    }

    void finishSelect() {
    }

    void layout(int visWidth, boolean firstOnLine) {
        Dimension dim = this.comp.getPreferredSize();
        this.resize(dim.width, dim.height);
        this.comp.setSize(dim.width, dim.height);
    }

    int getBaseLine() {
        return this.height - 4;
    }

    public int getNumValues() {
        return 1;
    }

    public String getName(int idx) {
        return this.name;
    }

    public String getValue(int idx) {
        int selected = -1;
        if (this.comp instanceof List) {
            List l = (List)this.comp;
            selected = l.getSelectedIndex();
        } else if (this.comp instanceof Choice) {
            Choice c = (Choice)this.comp;
            selected = c.getSelectedIndex();
        }
        if (selected < 0 || selected >= this.optionValues.size()) {
            return null;
        }
        return (String)this.optionValues.elementAt(selected);
    }

    public void reset() {
        if (this.comp instanceof List) {
            ((List)this.comp).select(this.defaultSelected);
        } else if (this.comp instanceof Choice) {
            ((Choice)this.comp).select(this.defaultSelected);
        }
    }
}

