/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnAware;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.view.FieldView;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.SelectableItemPainter;
import borland.jbcl.view.TextItemEditor;
import borland.jbcl.view.TextItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;

public class FieldControl
extends FieldView
implements NavigationListener,
DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public FieldControl() {
        this.setDefaultLayout();
    }

    public synchronized String getText() {
        Object object = this.get();
        return object != null ? object.toString() : "";
    }

    public synchronized void setText(String string) {
        if (this.canSet(true)) {
            this.set(string);
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(77));
        }
        super.setModel(singletonModel);
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                this.safeEndEdit(false);
                this.setDefaultLayout();
                break;
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setDefaultLayout();
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(this.dataSet, this, dataSetException);
                this.setDefaultLayout();
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void bindDataSet() {
        Column column;
        this.safeEndEdit(false);
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            SingletonDataSetManager singletonDataSetManager = new SingletonDataSetManager(this.dataSet, column, this);
            this.setModel(singletonDataSetManager);
            this.setViewManager(singletonDataSetManager);
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        int n = column.getAlignment();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            ((Component)this).setFont(font);
        }
        if (n != 0) {
            this.setAlignment(n);
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.safeEndEdit(false);
        this.repaint();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.endEdit();
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        super.processKeyPressed(keyEvent);
        if (keyEvent.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (keyEvent.getKeyCode()) {
                case 155: {
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (keyEvent.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    private void setDefaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter(this.getAlignment()))), new TextItemEditor(this.getAlignment())));
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean bl) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(bl) : false;
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }
}

