/*
 * Decompiled with CFR 0.152.
 */
package InnoBarBean;

import InnoBarBean.InnoBar;
import InnoBarBean.InnoBarChangeButton;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;

public class InnoBarCustomize
extends Dialog
implements ActionListener,
ItemListener,
KeyListener,
MouseListener {
    private InnoBar toolbar = new InnoBar();
    private int[] buttonList;
    private BorderLayout borderLayout1 = new BorderLayout();
    private Panel listPanel = new Panel();
    private Panel buttonPanel = new Panel();
    private Label toolbarAttr = new Label(" ", 1);
    private Label buttonAttr = new Label(" ", 1);
    private List buttonListBox = new List();
    private Button upButton = new Button();
    private Button downButton = new Button();
    private Button disableButton = new Button();
    private Button hideButton = new Button();
    private Button changeButton = new Button();
    private Button defaultButton = new Button();
    private Button closeButton = new Button();
    private Label buttonText = new Label();
    private Choice buttonBorder = new Choice();
    private Label mouseText = new Label();
    private Choice mouseBorder = new Choice();
    private Label lastText = new Label();
    private Choice lastBorder = new Choice();
    private Checkbox allowMove = new Checkbox();
    private Checkbox helpEnabled = new Checkbox();

    public InnoBarCustomize(InnoBar toolbar) {
        super(toolbar.getParentFrame(), "ToolBar Customization", true);
        this.toolbar = toolbar;
        this.buttonList = new int[toolbar.getInnoBarSize()];
        try {
            this.jbInit();
            this.enableEvents(64L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(505, 365));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation(screenSize.width - frameSize.width - 10, screenSize.height - frameSize.height - 10);
        Font thisFont = this.getFont();
        this.toolbarAttr.setText("ToolBar Attributes");
        this.toolbarAttr.setFont(new Font(thisFont.getName(), 1, (int)((double)thisFont.getSize() * 1.5)));
        this.buttonAttr.setText("Button Attributes");
        this.buttonAttr.setFont(new Font(thisFont.getName(), 1, (int)((double)thisFont.getSize() * 1.5)));
        this.upButton.setLabel("Up");
        this.downButton.setLabel("Down");
        this.disableButton.setLabel("Disable");
        this.hideButton.setLabel("Hide");
        this.changeButton.setLabel("Change");
        this.buttonText.setText("Button Border:");
        this.mouseText.setText("Mouse-Over Border:");
        this.lastText.setText("Last-Clicked Style:");
        this.allowMove.setLabel("Allow Drag-Drop Button Moves");
        this.helpEnabled.setLabel("Enable Button Bubble Help");
        this.defaultButton.setLabel("Restore Defaults");
        this.closeButton.setLabel("Close");
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.disableButton.setEnabled(false);
        this.hideButton.setEnabled(false);
        this.changeButton.setEnabled(false);
        String[] borderStyles = new String[]{"None", "Single", "Double", "Triple"};
        for (int i = 0; i < borderStyles.length; ++i) {
            this.buttonBorder.addItem(borderStyles[i]);
            this.mouseBorder.addItem(borderStyles[i]);
        }
        this.lastBorder.addItem("None");
        this.lastBorder.addItem("Dashed Frame");
        this.lastBorder.addItem("Solid Frame");
        this.lastBorder.addItem("Corner Frame");
        this.add((Component)this.buttonPanel, "West");
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setBounds(0, 0, 280, 365);
        this.buttonPanel.setBackground(Color.lightGray);
        this.toolbarAttr.setBounds(0, 5, 280, 40);
        this.buttonText.setBounds(10, 65, 120, 24);
        this.buttonBorder.setBounds(135, 65, 120, 24);
        this.mouseText.setBounds(10, 100, 120, 24);
        this.mouseBorder.setBounds(135, 100, 120, 24);
        this.lastText.setBounds(10, 135, 120, 24);
        this.lastBorder.setBounds(135, 135, 120, 24);
        this.defaultButton.setBounds(120, 307, 120, 27);
        this.closeButton.setBounds(10, 307, 80, 27);
        this.allowMove.setBounds(10, 205, 220, 24);
        this.helpEnabled.setBounds(10, 240, 220, 24);
        this.add((Component)this.listPanel, "East");
        this.listPanel.setLayout(null);
        this.listPanel.setBounds(281, 0, 225, 365);
        this.listPanel.setBackground(Color.lightGray);
        this.buttonAttr.setBounds(0, 5, 225, 40);
        this.buttonListBox.setBounds(15, 50, 200, 214);
        this.upButton.setBounds(48, 275, 60, 24);
        this.downButton.setBounds(118, 275, 60, 24);
        this.disableButton.setBounds(15, 310, 60, 24);
        this.hideButton.setBounds(85, 310, 60, 24);
        this.changeButton.setBounds(155, 310, 60, 24);
        this.listPanel.add(this.buttonAttr);
        this.listPanel.add(this.buttonListBox);
        this.listPanel.add(this.upButton);
        this.listPanel.add(this.downButton);
        this.listPanel.add(this.disableButton);
        this.listPanel.add(this.hideButton);
        this.listPanel.add(this.changeButton);
        this.setValues();
        this.buttonPanel.add(this.toolbarAttr);
        this.buttonPanel.add(this.buttonText);
        this.buttonPanel.add(this.buttonBorder);
        this.buttonPanel.add(this.mouseText);
        this.buttonPanel.add(this.mouseBorder);
        this.buttonPanel.add(this.lastText);
        this.buttonPanel.add(this.lastBorder);
        this.buttonPanel.add(this.allowMove);
        this.buttonPanel.add(this.helpEnabled);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.defaultButton);
        this.upButton.addActionListener(this);
        this.upButton.addKeyListener(this);
        this.downButton.addActionListener(this);
        this.downButton.addKeyListener(this);
        this.disableButton.addActionListener(this);
        this.disableButton.addKeyListener(this);
        this.hideButton.addActionListener(this);
        this.hideButton.addKeyListener(this);
        this.changeButton.addActionListener(this);
        this.changeButton.addKeyListener(this);
        this.defaultButton.addActionListener(this);
        this.defaultButton.addKeyListener(this);
        this.closeButton.addActionListener(this);
        this.closeButton.addKeyListener(this);
        this.buttonListBox.addMouseListener(this);
        this.buttonListBox.addKeyListener(this);
        this.buttonBorder.addItemListener(this);
        this.mouseBorder.addItemListener(this);
        this.lastBorder.addItemListener(this);
        this.allowMove.addItemListener(this);
        this.helpEnabled.addItemListener(this);
    }

    private void setValues() {
        this.buttonBorder.select(this.toolbar.getButtonBorder());
        this.mouseBorder.select(this.toolbar.getMouseOverBorder());
        this.lastBorder.select(this.toolbar.getLastClickedBorderStyle());
        this.allowMove.setState(this.toolbar.isUserButtonMoveEnabled());
        this.helpEnabled.setState(this.toolbar.isBubbleHelpEnabled());
        this.loadButtonList();
    }

    private void loadButtonList() {
        String buttonName = null;
        int i = 0;
        int j = 0;
        this.buttonListBox.setVisible(false);
        this.buttonListBox.removeAll();
        for (i = 0; i < this.toolbar.getInnoBarSize(); ++i) {
            this.buttonList[j] = i;
            if (this.toolbar.isButtonHiddenLocked(i)) continue;
            this.buttonList[j] = i;
            ++j;
            buttonName = this.toolbar.getButtonTag(i);
            if (buttonName == null) {
                buttonName = String.valueOf("Button ").concat(String.valueOf(i));
            }
            this.buttonListBox.addItem(buttonName);
        }
        this.buttonListBox.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        int i = 0;
        int button = 0;
        i = this.buttonListBox.getSelectedIndex();
        if (i >= 0) {
            button = this.buttonList[i];
        }
        if (e.getSource() == this.disableButton) {
            if (this.disableButton.getLabel().equals("Disable")) {
                this.toolbar.setDisabled(button, true);
            } else {
                this.toolbar.setDisabled(button, false);
            }
        } else if (e.getSource() == this.hideButton) {
            if (this.hideButton.getLabel().equals("Hide")) {
                this.toolbar.setHidden(button, true);
            } else {
                this.toolbar.setHidden(button, false);
            }
        } else if (e.getSource() == this.changeButton) {
            int index = this.buttonListBox.getSelectedIndex();
            InnoBarChangeButton change = new InnoBarChangeButton(this.toolbar.getParentFrame(), this.buttonListBox.getSelectedItem());
            String newTag = change.getNewTag();
            if (newTag != null) {
                this.toolbar.setButtonTag(button, newTag);
                this.loadButtonList();
                this.buttonListBox.select(index);
            }
        } else if (e.getSource() == this.defaultButton) {
            this.toolbar.restoreDefaults();
            this.setValues();
        } else if (e.getSource() == this.closeButton) {
            this.dispose();
        } else if (e.getSource() == this.upButton) {
            int index = this.buttonListBox.getSelectedIndex();
            String item = this.buttonListBox.getSelectedItem();
            if (this.buttonListBox.getItemCount() > 1 && index > 0) {
                this.toolbar.moveButtonOnePosition(this.buttonList[index], -1);
                this.toolbar.paint(this.toolbar.getGraphics());
                this.loadButtonList();
                if (!this.buttonListBox.getItem(index - 1).equals(item)) {
                    ++index;
                }
                this.buttonListBox.select(index - 1);
            }
        } else if (e.getSource() == this.downButton) {
            int index = this.buttonListBox.getSelectedIndex();
            String item = this.buttonListBox.getSelectedItem();
            if (this.buttonListBox.getItemCount() > 1 && index < this.buttonListBox.getItemCount() - 1) {
                this.toolbar.moveButtonOnePosition(this.buttonList[index], 1);
                this.toolbar.paint(this.toolbar.getGraphics());
                this.loadButtonList();
                if (!this.buttonListBox.getItem(index + 1).equals(item)) {
                    --index;
                }
                this.buttonListBox.select(index + 1);
            }
        } else if (e.getSource() == this.buttonListBox) {
            ActionEvent AE = new ActionEvent(this.disableButton, 1001, "OK");
            this.actionPerformed(AE);
        }
        this.setButtons();
    }

    public void itemStateChanged(ItemEvent e) {
        int i = 0;
        if (e.getSource() == this.buttonBorder) {
            i = this.buttonBorder.getSelectedIndex();
            if (i >= 0) {
                this.toolbar.setButtonBorder(i);
            }
        } else if (e.getSource() == this.mouseBorder) {
            i = this.mouseBorder.getSelectedIndex();
            if (i >= 0) {
                this.toolbar.setMouseOverBorder(i);
            }
        } else if (e.getSource() == this.lastBorder) {
            i = this.lastBorder.getSelectedIndex();
            if (i >= 0) {
                this.toolbar.setLastClickedBorderStyle(i);
            }
        } else if (e.getSource() == this.allowMove) {
            this.toolbar.setUserButtonMoveEnabled(this.allowMove.getState());
        } else if (e.getSource() == this.helpEnabled) {
            this.toolbar.setBubbleHelpEnabled(this.helpEnabled.getState());
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = 0;
        keyCode = e.getKeyCode();
        if (keyCode == 10) {
            ActionEvent AE = new ActionEvent(e.getSource(), 1001, "OK");
            this.actionPerformed(AE);
        } else if (e.getSource() == this.buttonListBox && (keyCode == 38 || keyCode == 40 || keyCode == 37 || keyCode == 39)) {
            this.setButtons();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    private void setButtons() {
        String text = new String();
        int i = this.buttonListBox.getSelectedIndex();
        if (i >= 0) {
            text = this.toolbar.isButtonDisabled(i = this.buttonList[i]) ? "Enable" : "Disable";
            this.disableButton.setLabel(text);
            if (this.toolbar.isButtonHidden(i)) {
                this.disableButton.setEnabled(false);
            } else {
                this.disableButton.setEnabled(true);
            }
            text = this.toolbar.isButtonHidden(i) ? "Unhide" : "Hide";
            this.hideButton.setLabel(text);
            this.hideButton.setEnabled(true);
            this.changeButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        }
    }

    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(e);
        }
    }
}

