/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.html.AttributeList;
import sunw.html.ContentModel;
import sunw.html.DTDConstants;
import sunw.html.DTDParser;
import sunw.html.Element;
import sunw.html.Entity;
import sunw.html.PublicMapping;

public class DTD
implements DTDConstants {
    String name;
    Vector elements = new Vector();
    Hashtable elementHash = new Hashtable();
    Hashtable entityHash = new Hashtable();
    public final Element pcdata = this.getElement("#pcdata");
    public final Element html = this.getElement("html");
    public final Element meta = this.getElement("meta");
    public final Element base = this.getElement("base");
    public final Element isindex = this.getElement("isindex");
    public final Element head = this.getElement("head");
    public final Element body = this.getElement("body");
    public final Element applet = this.getElement("applet");
    public final Element param = this.getElement("param");
    public final Element p = this.getElement("p");
    public final Element title = this.getElement("title");
    static Hashtable dtdHash = new Hashtable();
    static PublicMapping mapping;

    protected DTD(String string) {
        this.name = string;
        this.defEntity("#RE", 65536, 13);
        this.defEntity("#RS", 65536, 10);
        this.defEntity("#SPACE", 65536, 32);
    }

    public String getName() {
        return this.name;
    }

    public Entity getEntity(String string) {
        return (Entity)this.entityHash.get(string);
    }

    public Entity getEntity(int n) {
        return (Entity)this.entityHash.get(new Integer(n));
    }

    boolean elementExists(String string) {
        Element element = (Element)this.elementHash.get(string);
        return element != null;
    }

    public Element getElement(String string) {
        Element element = (Element)this.elementHash.get(string);
        if (element == null) {
            element = new Element(string, this.elements.size());
            this.elements.addElement(element);
            this.elementHash.put(string, element);
        }
        return element;
    }

    public Element getElement(int n) {
        return (Element)this.elements.elementAt(n);
    }

    protected Entity defineEntity(String string, int n, char[] cArray) {
        Entity entity = (Entity)this.entityHash.get(string);
        if (entity == null) {
            entity = new Entity(string, n, cArray);
            this.entityHash.put(string, entity);
            if ((n & 0x10000) != 0 && cArray.length == 1) {
                switch (n & 0xFFFEFFFF) {
                    case 1: 
                    case 11: {
                        this.entityHash.put(new Integer(cArray[0]), entity);
                        break;
                    }
                }
            }
        }
        return entity;
    }

    protected Element defineElement(String string, int n, boolean bl, boolean bl2, ContentModel contentModel, BitSet bitSet, BitSet bitSet2, AttributeList attributeList) {
        Element element = this.getElement(string);
        element.type = n;
        element.oStart = bl;
        element.oEnd = bl2;
        element.content = contentModel;
        element.exclusions = bitSet;
        element.inclusions = bitSet2;
        element.atts = attributeList;
        return element;
    }

    protected void defineAttributes(String string, AttributeList attributeList) {
        Element element = this.getElement(string);
        element.atts = attributeList;
    }

    protected Entity defEntity(String string, int n, int n2) {
        char[] cArray = new char[]{(char)n2};
        return this.defineEntity(string, n, cArray);
    }

    protected Entity defEntity(String string, int n, String string2) {
        int n2 = string2.length();
        char[] cArray = new char[n2];
        string2.getChars(0, n2, cArray, 0);
        return this.defineEntity(string, n, cArray);
    }

    protected Element defElement(String string, int n, boolean bl, boolean bl2, ContentModel contentModel, String string2, String string3, AttributeList attributeList) {
        Object object;
        Object object2;
        BitSet bitSet = null;
        if (string2 != null) {
            bitSet = new BitSet();
            object2 = new StringTokenizer(string2, "|");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (((String)object).length() <= 0) continue;
                bitSet.set(this.getElement((String)object).getIndex());
            }
        }
        object2 = null;
        if (string3 != null) {
            object2 = new BitSet();
            object = new StringTokenizer(string3, "|");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                if (string4.length() <= 0) continue;
                ((BitSet)object2).set(this.getElement(string4).getIndex());
            }
        }
        return this.defineElement(string, n, bl, bl2, contentModel, bitSet, (BitSet)object2, attributeList);
    }

    protected AttributeList defAttributeList(String string, int n, int n2, String string2, String string3, AttributeList attributeList) {
        Vector<String> vector = null;
        if (string3 != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.length() <= 0) continue;
                vector.addElement(string4);
            }
        }
        return new AttributeList(string, n, n2, string2, vector, attributeList);
    }

    protected ContentModel defContentModel(int n, Object object, ContentModel contentModel) {
        return new ContentModel(n, object, contentModel);
    }

    public String toString() {
        return this.name;
    }

    public void print() {
        System.out.println("<!DOCTYPE " + this.name + " [");
        System.out.println();
        Enumeration enumeration = this.entityHash.elements();
        while (enumeration.hasMoreElements()) {
            ((Entity)enumeration.nextElement()).print();
        }
        System.out.println();
        Enumeration enumeration2 = this.elements.elements();
        while (enumeration2.hasMoreElements()) {
            ((Element)enumeration2.nextElement()).print();
        }
        System.out.println("]>");
    }

    public static DTD getDTD(String string) throws IOException {
        DTD dTD = (DTD)dtdHash.get(string = string.toLowerCase());
        if (dTD == null) {
            URL uRL;
            try {
                long l = System.currentTimeMillis();
                Class<?> clazz = Class.forName("sunw.html.dtds." + string);
                if (clazz != null) {
                    dTD = (DTD)clazz.newInstance();
                    dtdHash.put(string, dTD);
                    l = System.currentTimeMillis() - l;
                    System.err.println("[Loaded DTD " + dTD + " in " + l + "ms]");
                    return dTD;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (mapping == null) {
                mapping = new PublicMapping(new URL(System.getProperty("public.map")));
            }
            if ((uRL = mapping.get(string)) == null) {
                throw new FileNotFoundException("DTD not found: " + string);
            }
            dTD = new DTD(string);
            new DTDParser().parse(uRL.openStream(), dTD);
            dtdHash.put(string, dTD);
        }
        return dTD;
    }

    void save(PrintStream printStream, String string) {
        printStream.println("/**");
        printStream.println(" * Generated: " + new Date());
        printStream.println(" */");
        printStream.println("package sunw.html.dtds;");
        printStream.println("import sunw.html.*;");
        printStream.println();
        printStream.println("public final class " + string + " extends DTD {");
        printStream.println("    public " + string + "() {");
        printStream.println("\tsuper(\"" + this.getName() + "\");");
        Enumeration enumeration = this.entityHash.elements();
        while (enumeration.hasMoreElements()) {
            this.saveEntity(printStream, (Entity)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.elements.elements();
        while (enumeration2.hasMoreElements()) {
            this.saveElement(printStream, (Element)enumeration2.nextElement());
        }
        printStream.println("    }");
        printStream.println("}");
    }

    void saveEntity(PrintStream printStream, Entity entity) {
        if (entity.isGeneral()) {
            char[] cArray = entity.getData();
            printStream.print("\tdefEntity(\"" + entity.getName() + "\"," + (entity.getType() | 0x10000) + ",");
            if (cArray.length == 1) {
                printStream.print((int)cArray[0]);
            } else {
                printStream.print("\"" + entity.getString() + "\"");
            }
            printStream.println(");");
        }
    }

    public void saveElement(PrintStream printStream, Element element) {
        Object object;
        int n;
        printStream.print("\tdefElement(\"" + element.getName() + "\"," + element.getType() + ",");
        printStream.print(String.valueOf(element.omitStart()) + "," + element.omitEnd() + ",");
        this.saveContentModel(printStream, element.getContent());
        printStream.print(",");
        if (element.exclusions != null) {
            printStream.print("\"");
            n = 0;
            while (n < element.exclusions.size()) {
                if (element.exclusions.get(n)) {
                    printStream.print(String.valueOf(this.getElement(n).getName()) + "|");
                }
                ++n;
            }
            printStream.print("\",");
        } else {
            printStream.print("null,");
        }
        if (element.inclusions != null) {
            printStream.print("\"");
            n = 0;
            while (n < element.inclusions.size()) {
                if (element.inclusions.get(n)) {
                    printStream.print(String.valueOf(this.getElement(n).getName()) + "|");
                }
                ++n;
            }
            printStream.print("\",");
        } else {
            printStream.print("null,");
        }
        AttributeList attributeList = element.getAttributes();
        while (attributeList != null) {
            printStream.print("defAttributeList(\"" + attributeList.getName() + "\",");
            printStream.print(String.valueOf(attributeList.getType()) + ",");
            printStream.print(String.valueOf(attributeList.getModifier()) + ",");
            if (attributeList.getValue() != null) {
                printStream.print("\"" + attributeList.getValue() + "\",");
            } else {
                printStream.print("null,");
            }
            object = attributeList.getValues();
            if (object != null) {
                printStream.print("\"");
                do {
                    printStream.print(String.valueOf(object.nextElement()) + "|");
                } while (object.hasMoreElements());
                printStream.print("\",");
            } else {
                printStream.print("null,");
            }
            attributeList = attributeList.getNext();
        }
        printStream.print("null");
        object = element.getAttributes();
        while (object != null) {
            printStream.print(")");
            object = ((AttributeList)object).getNext();
        }
        printStream.println(");");
    }

    public void saveContentModel(PrintStream printStream, ContentModel contentModel) {
        if (contentModel != null) {
            printStream.print("defContentModel(" + contentModel.type + ",");
            if (contentModel.content instanceof ContentModel) {
                this.saveContentModel(printStream, (ContentModel)contentModel.content);
                printStream.print(",");
            } else if (contentModel.content instanceof Element) {
                printStream.print("getElement(\"" + ((Element)contentModel.content).getName() + "\"),");
            } else {
                printStream.print("null,");
            }
            this.saveContentModel(printStream, contentModel.next);
            printStream.print(")");
            return;
        }
        printStream.print("null");
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties(System.getProperties());
        String string = System.getProperty("hotjava.home");
        if (string == null) {
            System.err.println("Must set property 'hotjava.home'");
            return;
        }
        try {
            properties.load(new FileInputStream(String.valueOf(string) + "/lib/hotjava.properties"));
        }
        catch (IOException iOException) {
            System.err.println("No system properties file");
            iOException.printStackTrace(System.err);
            return;
        }
        System.setProperties(properties);
        DTD dTD = null;
        try {
            dTD = DTD.getDTD(stringArray[0]);
        }
        catch (IOException iOException) {
            System.err.println("Could not open DTD file " + stringArray[0]);
            iOException.printStackTrace(System.err);
        }
        dTD.save(System.out, stringArray[0]);
    }
}

