/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.misc.Globals;

public final class DocFont
extends Font {
    int hash;
    int index;
    boolean forPrinting;
    DocFont typewriter;
    DocFont bold;
    DocFont italic;
    DocFont underline;
    FontMetrics metrics;
    DocFont[] sizes;
    int[] sizeMap;
    private static int[][] sharedSizeMaps = new int[2][];
    static final Hashtable fontHash = new Hashtable();

    private static synchronized int[] initSharedSizeMap(int n, boolean bl) {
        if (sharedSizeMaps[n] == null) {
            int[] nArray = new int[32];
            String string = bl ? "printfonts.sizes" : "fonts.sizes";
            StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty(string), ", \t\n");
            int n2 = 0;
            while (n2 < nArray.length && stringTokenizer.hasMoreTokens()) {
                nArray[n2++] = Integer.valueOf(stringTokenizer.nextToken());
            }
            DocFont.sharedSizeMaps[n] = new int[n2];
            System.arraycopy(nArray, 0, sharedSizeMaps[n], 0, n2);
        }
        return sharedSizeMaps[n];
    }

    private static int getInitialSize(int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        int[] nArray = sharedSizeMaps[n2] != null ? sharedSizeMaps[n2] : DocFont.initSharedSizeMap(n2, bl);
        return nArray[n];
    }

    private static DocFont internFont(DocFont docFont) {
        Hashtable hashtable = fontHash;
        synchronized (hashtable) {
            Object v = fontHash.get(docFont);
            if (v == null) {
                fontHash.put(docFont, docFont);
                DocFont docFont2 = docFont;
                Object var3_5 = null;
                return docFont2;
            }
            DocFont docFont3 = (DocFont)v;
            Object var3_6 = null;
            return docFont3;
        }
    }

    public static DocFont findFont(boolean bl, int n, int n2) {
        String string = bl ? "hotjava.printfont" : "hotjava.docfont";
        String string2 = Globals.localProps.handleGetString(string);
        return DocFont.internFont(new DocFont(string2, n, n2, bl));
    }

    private DocFont(String string, int n, int n2, boolean bl) {
        super(string, n, DocFont.getInitialSize(n2, bl));
        this.forPrinting = bl;
        this.index = n2;
        int n3 = bl ? 1 : 0;
        this.sizeMap = sharedSizeMaps[n3];
        this.sizes = new DocFont[this.sizeMap.length];
        this.hash = string.hashCode() ^ n * 31 ^ n2 * 61 ^ (bl ? 67 : 0);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object == this) {
                return true;
            }
            if (object instanceof DocFont) {
                DocFont docFont = (DocFont)object;
                return this.hash == docFont.hash && this.index == docFont.index && this.style == docFont.style && this.name.equals(docFont.name) && this.forPrinting == docFont.forPrinting;
            }
        }
        return false;
    }

    public DocFont getName(String string) {
        return DocFont.internFont(new DocFont(string, this.style, this.index, this.forPrinting));
    }

    public DocFont getBold() {
        if (this.bold == null) {
            this.bold = DocFont.internFont(new DocFont(this.name, this.style | 1, this.index, this.forPrinting));
        }
        return this.bold;
    }

    public DocFont getItalic() {
        if (this.italic == null) {
            this.italic = DocFont.internFont(new DocFont(this.name, this.style | 2, this.index, this.forPrinting));
        }
        return this.italic;
    }

    public DocFont getTypewriter() {
        if (this.typewriter == null) {
            this.typewriter = DocFont.internFont(new DocFont("Monospaced", this.style, this.index, this.forPrinting));
        }
        return this.typewriter;
    }

    public DocFont getIndex(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.sizeMap.length) {
            n = this.sizeMap.length - 1;
        }
        if (this.sizes[n] == null) {
            this.sizes[n] = DocFont.internFont(new DocFont(this.name, this.style, n, this.forPrinting));
        }
        return this.sizes[n];
    }

    public DocFont getBigger(int n) {
        return this.getIndex(this.index + n);
    }

    public DocFont getSmaller(int n) {
        return this.getIndex(this.index - n);
    }

    public int getIndex() {
        return this.index;
    }

    public FontMetrics getFontMetrics(DocStyle docStyle) {
        if (docStyle != null && docStyle.nonScreenGraphics != null) {
            return docStyle.nonScreenGraphics.getFontMetrics(this);
        }
        if (this.metrics == null) {
            this.metrics = Globals.getFontMetrics(this);
        }
        return this.metrics;
    }
}

