/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import java.util.Observer;
import java.util.Vector;
import sunw.hotjava.bean.SystemPropertiesEditor;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.ui.ConfirmDialog;

public class PropertiesEditorPanel
extends ScrollPane {
    Hashtable values;
    private Observer notifyMeOnChange;
    Panel mainPanel;
    private SystemPropertiesEditor sysPropEditor;

    public PropertiesEditorPanel(Hashtable hashtable, Hashtable hashtable2, Vector vector, Observer observer, SystemPropertiesEditor systemPropertiesEditor) {
        this.sysPropEditor = systemPropertiesEditor;
        this.values = hashtable;
        this.notifyMeOnChange = observer;
        this.mainPanel = new Panel();
        this.add(this.mainPanel);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)new Label("PROPERTY NAME"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new Label("PROPERTY VALUE"), gridBagConstraints);
        if (hashtable2 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)new Label("DEFAULT VALUE"), gridBagConstraints);
        }
        int n = 0;
        while (n < vector.size()) {
            Object object;
            Field field = (Field)vector.elementAt(n);
            gridBagConstraints = new GridBagConstraints();
            String string = this.getConvertedValue(hashtable, field);
            boolean bl = string != null;
            string = bl ? string : "";
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.anchor = 13;
            this.mainPanel.add((Component)new Label(String.valueOf(field.name) + ":  "), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n + 1;
            TextField textField = new TextField(string, 30);
            this.mainPanel.add((Component)textField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n + 1;
            String string2 = Globals.localProps.handleGetString("bean.edit.props.set");
            Checkbox checkbox = new Checkbox(string2, bl);
            this.mainPanel.add((Component)checkbox, gridBagConstraints);
            if (hashtable2 != null) {
                object = this.getConvertedValue(hashtable2, field);
                object = object == null ? "" : "(" + (String)object + ")";
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = n + 1;
                gridBagConstraints.anchor = 17;
                this.mainPanel.add((Component)new Label((String)object), gridBagConstraints);
            }
            object = new ValueChanged(field, textField, checkbox);
            textField.addActionListener((ActionListener)object);
            textField.addFocusListener((FocusListener)object);
            textField.addTextListener((TextListener)object);
            checkbox.addItemListener((ItemListener)object);
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.mainPanel.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (n < this.getVScrollbarWidth()) {
            n += this.getVScrollbarWidth();
        }
        if (n2 > this.getHScrollbarHeight()) {
            n2 -= this.getHScrollbarHeight();
        }
        dimension.width = Math.min(dimension2.width - 30, dimension.width + n);
        dimension.height = Math.min(dimension2.height - 70, dimension.height + n2);
        return dimension;
    }

    public String getConvertedValue(Hashtable hashtable, Field field) {
        if (field.converter != null) {
            return field.converter.get(hashtable, field.name);
        }
        return (String)hashtable.get(field.name);
    }

    public String putConvertedValue(Hashtable hashtable, Field field, String string) {
        String string2;
        if (field.constraint != null && (string2 = field.constraint.check(field.name, string)) != null) {
            ConfirmDialog confirmDialog = new ConfirmDialog("bean.edit.put.error", this.getEnclosingFrame(), 1);
            confirmDialog.setPrompt(string2);
            try {
                Thread.sleep(100L);
                EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                while (eventQueue.peekEvent() != null) {
                    eventQueue.getNextEvent();
                }
            }
            catch (Exception exception) {}
            confirmDialog.show();
            return this.getConvertedValue(hashtable, field);
        }
        if (field.converter != null) {
            field.converter.set(hashtable, field.name, string);
        } else if (string == null) {
            hashtable.remove(field.name);
        } else {
            hashtable.put(field.name, string);
        }
        return string;
    }

    private Frame getEnclosingFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    void notifyPropertyChange() {
        if (this.notifyMeOnChange != null) {
            this.notifyMeOnChange.update(null, this.values);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void removeNotify() {
        this.sysPropEditor.editorPanelFinished();
    }

    public static class Field {
        String name;
        Constraint constraint;
        Converter converter;

        public Field(String string, Constraint constraint, Converter converter) {
            this.name = string;
            this.constraint = constraint;
            this.converter = converter;
        }

        public Field(String string, Constraint constraint) {
            this(string, constraint, null);
        }

        public Field(String string) {
            this(string, null, null);
        }
    }

    public interface Constraint {
        public String check(String var1, String var2);
    }

    public interface Converter {
        public String get(Hashtable var1, String var2);

        public void set(Hashtable var1, String var2, String var3);
    }

    private class ValueChanged
    implements ActionListener,
    FocusListener,
    TextListener,
    ItemListener {
        private Field field;
        TextField textField;
        Checkbox checkbox;
        private boolean ignore = false;

        ValueChanged(Field field, TextField textField, Checkbox checkbox) {
            PropertiesEditorPanel.this = PropertiesEditorPanel.this;
            this.field = field;
            this.textField = textField;
            this.checkbox = checkbox;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.ignore) {
                return;
            }
            try {
                this.ignore = true;
                String string = this.checkbox.getState() ? PropertiesEditorPanel.this.putConvertedValue(PropertiesEditorPanel.this.values, this.field, this.textField.getText()) : PropertiesEditorPanel.this.putConvertedValue(PropertiesEditorPanel.this.values, this.field, null);
                this.setWidgetsForState(string);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.ignore = false;
                throw throwable;
            }
            Object var3_3 = null;
            this.ignore = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateFromTextField();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.updateFromTextField();
        }

        public void textValueChanged(TextEvent textEvent) {
            String string = this.textField.getText();
            if (string.length() > 0) {
                this.checkbox.setState(true);
                return;
            }
            this.checkbox.setState(PropertiesEditorPanel.this.getConvertedValue(PropertiesEditorPanel.this.values, this.field) != null);
        }

        private void updateFromTextField() {
            if (this.ignore) {
                return;
            }
            try {
                this.ignore = true;
                String string = this.textField.getText();
                if (string.length() > 0) {
                    this.checkbox.setState(true);
                    string = PropertiesEditorPanel.this.putConvertedValue(PropertiesEditorPanel.this.values, this.field, string);
                } else {
                    string = this.checkbox.getState() ? PropertiesEditorPanel.this.putConvertedValue(PropertiesEditorPanel.this.values, this.field, string) : PropertiesEditorPanel.this.putConvertedValue(PropertiesEditorPanel.this.values, this.field, null);
                }
                this.setWidgetsForState(string);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.ignore = false;
                throw throwable;
            }
            Object var2_2 = null;
            this.ignore = false;
        }

        private void setWidgetsForState(String string) {
            if (string == null) {
                this.checkbox.setState(false);
                ((TextComponent)this.textField).setText("");
            } else {
                this.checkbox.setState(true);
                ((TextComponent)this.textField).setText(string);
            }
            PropertiesEditorPanel.this.notifyPropertyChange();
        }
    }
}

