/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import java.text.DateFormat;

import javax.swing.JTable;

import jnpad.util.Utilities;

/**
 * The Class DateTableCellRenderer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class DateTableCellRenderer extends LabelTableCellRenderer {
  private DateFormat        formatter;

  /** UID */
  private static final long serialVersionUID = -281665486322948710L;

  /**
   * Instantiates a new date table cell renderer.
   */
  public DateTableCellRenderer() {
    super();
  }

  /**
   * Instantiates a new date table cell renderer.
   *
   * @param halignment int
   */
  public DateTableCellRenderer(int halignment) {
    super(halignment);
  }

  /**
   * Instantiates a new date table cell renderer.
   *
   * @param halignment int
   * @param valignment int
   */
  public DateTableCellRenderer(int halignment, int valignment) {
    super(halignment, valignment);
  }

  /**
   * Instantiates a new date table cell renderer.
   *
   * @param tooltipEnabled boolean
   */
  public DateTableCellRenderer(boolean tooltipEnabled) {
    super(tooltipEnabled);
  }

  /**
   * Instantiates a new date table cell renderer.
   *
   * @param halignment int
   * @param tooltipEnabled boolean
   */
  public DateTableCellRenderer(int halignment, boolean tooltipEnabled) {
    super(halignment, tooltipEnabled);
  }

  /**
   * Instantiates a new date table cell renderer.
   *
   * @param halignment int
   * @param valignment int
   * @param tooltipEnabled boolean
   */
  public DateTableCellRenderer(int halignment, int valignment, boolean tooltipEnabled) {
    super(halignment, valignment, tooltipEnabled);
  }

  /**
   * Sets the value.
   *
   * @param table the table
   * @param value the value
   * @param row the row
   * @param column the column
   * @see jnpad.ui.table.LabelTableCellRenderer#setValue(javax.swing.JTable, java.lang.Object, int, int)
   */
  @Override
  protected void setValue(JTable table, Object value, int row, int column) {
    if (formatter == null) {
      formatter = DateFormat.getDateInstance();
    }
    String s = (value == null) ? Utilities.EMPTY_STRING : formatter.format(value);
    setText(s);
    if (isTooltipEnabled()) {
      if (s.length() > 0)
        setToolTipText(s);
      else
        setToolTipText(null);
    }
  }

}
