/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.tab;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

import jnpad.GUIUtilities;
import jnpad.JNPadBundle;

/**
 * The Class CloseButtonTabComponent.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class CloseButtonTabComponent extends JPanel {
  private final AbstractTabbedPane tabbedPane;

  /** UID */
  private static final long serialVersionUID = -1881405193929636495L;
  
  /**
   * Instantiates a new button tab component.
   *
   * @param tabbedPane the pane
   */
  public CloseButtonTabComponent(final AbstractTabbedPane tabbedPane) {
    super(new FlowLayout(FlowLayout.LEFT, 0, 0));

    this.tabbedPane = tabbedPane;
    
    setOpaque(false);

    @SuppressWarnings("serial")
    JLabel label = new JLabel() {
      @Override public String getText() {
        int idx = tabbedPane.indexOfTabComponent(CloseButtonTabComponent.this);
        if (idx != -1) {
          return tabbedPane.getTitleAt(idx);
        }
        return null;
      }

      @Override public Icon getIcon() {
        int idx = tabbedPane.indexOfTabComponent(CloseButtonTabComponent.this);
        if (idx != -1) {
          return tabbedPane.getIconAt(idx);
        }
        return null;
      }
    };
    label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));

    add(label);
    add(new CloseTabButton());
  }

  ////////////////////////////////////////////////////////////////////////////// 
  private class CloseTabButton extends JButton {
    /** UID */
    private static final long serialVersionUID = 2127903096547704654L;

    /**
     * Instantiates a new close tab button.
     */
    CloseTabButton() {
      setPreferredSize(new Dimension(16, 16));
      setToolTipText(JNPadBundle.getString("CloseTabButton.close")); //$NON-NLS-1$

      //Make the button looks the same for all Laf's
      setUI(new BasicButtonUI());

      //Make it transparent
      setContentAreaFilled(false);
      
      //No need to be focusable
      setFocusable(false);
      setBorderPainted(false);
      setRolloverEnabled(true);
      
      //Close the proper tab by clicking the button
      addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(final ActionEvent e) {
          int i = tabbedPane.indexOfTabComponent(CloseButtonTabComponent.this);
          if (i != -1) {
            tabbedPane.close(i);
          }
        }
      });
    }
    
    /**
     * Update ui.
     *
     * @see javax.swing.JButton#updateUI()
     */
    @Override
    public void updateUI() {
      //we don't want to update UI for this button
    }

    /**
     * Paint component.
     *
     * @param g Graphics
     * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
     */
    @Override
    protected void paintComponent(Graphics g) {
      super.paintComponent(g);

      Graphics2D g2D = (Graphics2D) g;

      final Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
      g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

      if (getModel().isRollover()) {
        GUIUtilities.paintCross(g, Color.BLACK, 8, 8, 6, 2);
      }
      else {
        GUIUtilities.paintCross(g, Color.GRAY, 8, 8, 6, 1);
      }

      g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
    }
  }
  ////////////////////////////////////////////////////////////////////////////// 

}
