/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

/**
 * The Class EscapableDialog.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class EscapableDialog extends JDialog {
  /** The Constant ESCAPE_KEY. */
  private static final String ESCAPE_KEY       = "Escape";            //$NON-NLS-1$

  /** UID. */
  private static final long   serialVersionUID = 6836108229131796549L;

  /**
   * Instantiates a new escapable dialog.
   */
  public EscapableDialog() {
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   */
  public EscapableDialog(Frame owner) {
    super(owner);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   */
  public EscapableDialog(Dialog owner) {
    super(owner);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   */
  public EscapableDialog(Window owner) {
    super(owner);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param modal the modal
   */
  public EscapableDialog(Frame owner, boolean modal) {
    super(owner, modal);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   */
  public EscapableDialog(Frame owner, String title) {
    super(owner, title);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param modal the modal
   */
  public EscapableDialog(Dialog owner, boolean modal) {
    super(owner, modal);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   */
  public EscapableDialog(Dialog owner, String title) {
    super(owner, title);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param modalityType the modality type
   */
  public EscapableDialog(Window owner, ModalityType modalityType) {
    super(owner, modalityType);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   */
  public EscapableDialog(Window owner, String title) {
    super(owner, title);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   * @param modal the modal
   */
  public EscapableDialog(Frame owner, String title, boolean modal) {
    super(owner, title, modal);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   * @param modal the modal
   */
  public EscapableDialog(Dialog owner, String title, boolean modal) {
    super(owner, title, modal);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   * @param modalityType the modality type
   */
  public EscapableDialog(Window owner, String title, ModalityType modalityType) {
    super(owner, title, modalityType);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   * @param modal the modal
   * @param gc the gc
   */
  public EscapableDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
    super(owner, title, modal, gc);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   * @param modal the modal
   * @param gc the gc
   */
  public EscapableDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
    super(owner, title, modal, gc);
    setEscapeClosesDialog(true);
  }

  /**
   * Instantiates a new escapable dialog.
   * 
   * @param owner the owner
   * @param title the title
   * @param modalityType the modality type
   * @param gc the gc
   */
  public EscapableDialog(Window owner, String title, ModalityType modalityType, GraphicsConfiguration gc) {
    super(owner, title, modalityType, gc);
    setEscapeClosesDialog(true);
  }

  /**
   * Escape pressed.
   */
  protected void escapePressed() {
    setVisible(false);
  }

  /**
   * Sets the escape closes dialog.
   * 
   * @param closes the new escape closes dialog
   */
  public void setEscapeClosesDialog(boolean closes) {
    JRootPane rootPane = getRootPane();
    InputMap im = rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
    ActionMap am = rootPane.getActionMap();
    KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);

    if (closes) {
      im.put(ks, ESCAPE_KEY);
      am.put(ESCAPE_KEY, new AbstractAction() {
        private static final long serialVersionUID = -7743556146255524749L;
        public void actionPerformed(final ActionEvent e) {
          escapePressed();
        }
      });
    }
    else {
      im.remove(ks);
      am.remove(ESCAPE_KEY);
    }
  }

}
