/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text.highlighter;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

import jnpad.config.Config;

/**
 * The Class BracketHighlightPainter.
 *
 * @version 0.3
 * @since jNPad 0.1
 * @see IHighlightPainter
 */
public class BracketHighlightPainter implements IHighlightPainter {
  private Color _color;

  /**
   * Instantiates a new bracket highlight painter.
   */
  public BracketHighlightPainter() {
    configure(CFG_COLOR);
  }

  /**
   * Configure.
   *
   * @param cfg the cfg
   * @see jnpad.config.Configurable#configure(int)
   */
  @Override
  public void configure(final int cfg) {
    if ((cfg & CFG_COLOR) != 0) {
      setColor(Config.BRACKET_HIGHLIGHTER_COLOR.getValue());
    }
  }

  /**
   * Sets the color.
   *
   * @param color the new color
   */
  public void setColor(Color color) {
    if (color != null) {
      _color = color;
    }
  }

  /**
   * Gets the color.
   *
   * @return the color
   */
  public Color getColor() {
    return _color;
  }

  /**
   * Paint.
   *
   * @param g the Graphics
   * @param offs0 the offs0
   * @param offs1 the offs1
   * @param bounds the bounds
   * @param c the JTextComponent
   * @see javax.swing.text.Highlighter.HighlightPainter#paint(java.awt.Graphics, int, int, java.awt.Shape, javax.swing.text.JTextComponent)
   */
  @Override
  public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
    if (c.getSelectionStart() != c.getSelectionEnd())
      return;
    if (offs0 == offs1)
      return;
    Rectangle r;
    Document doc = c.getDocument();
    FontMetrics fm = g.getFontMetrics();
    Segment segment = new Segment();
    try {
      r = c.modelToView(offs0);
      doc.getText(offs0, 1, segment);
      r.width = fm.charWidth(segment.array[segment.offset]);
    }
    catch (BadLocationException aoException) {
      // can't render
      return;
    }
    g.setColor(getColor());
    g.fillRect(r.x, r.y, r.width, r.height);
  }

}
