/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Class PropChangeEvent.
 *
 * @param <V> the value type
 * @version 0.3
 * @since   jNPad v0.1
 */
public class PropChangeEvent<V> extends java.util.EventObject {
  private V                 newValue;
  private V                 oldValue;

  /** UID */
  private static final long serialVersionUID = 5986245568277901385L;

  /**
   * Instantiates a new prop change event.
   *
   * @param prop the prop
   * @param oldValue the old value
   * @param newValue the new value
   */
  public PropChangeEvent(Prop<V> prop, V oldValue, V newValue) {
    super(prop);
    this.oldValue = oldValue;
    this.newValue = newValue;
  }

  /**
   * Gets the new value.
   *
   * @return the new value
   */
  public V getNewValue() {
    return newValue;
  }

  /**
   * Gets the old value.
   *
   * @return the old value
   */
  public V getOldValue() {
    return oldValue;
  }

}
