/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_TO_LOWER_CASE;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.Action;
import javax.swing.text.DefaultEditorKit;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.ui.status.StatusDisplayable.StatusType;

/**
 * The Class ToLowerCaseAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class ToLowerCaseAction extends JNPadAction implements IEditAction/*, ISelectionAction*/ {
  /** Logger */
  private static final Logger LOGGER           = Logger.getLogger(ToLowerCaseAction.class.getName());

  /** UID */
  private static final long   serialVersionUID = 6398730622031499399L;

  /**
   * Instantiates a new to lower case action.
   *
   * @param jNPad the jNPad's frame
   */
  public ToLowerCaseAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_TO_LOWER_CASE,
          Group.FORMAT,
          Accelerators.TO_LOWER, "to-lower-case.png"); //$NON-NLS-1$
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    Buffer buffer = jNPad.getActiveBuffer();
    if (buffer != null) {
      try {
        buffer.beginCompoundEdit();
        
        JNPadTextArea textArea = buffer.getSelectedTextArea();
        
        final int pos = textArea.getCaretPosition();

        if(!textArea.hasSelection()) {
          EditPane editPane = buffer.getSelectedEditPane();
          Action action = editPane.getActions().get(DefaultEditorKit.selectWordAction);
          if (action != null) {
            action.actionPerformed(new ActionEvent(editPane.getTextArea(),
                                                   ActionEvent.ACTION_PERFORMED,
                                                   (String) action.getValue(Action.NAME),
                                                   EventQueue.getMostRecentEventTime(),
                                                   getCurrentEventModifiers()));
          }
        }
        
        textArea.toLowerCase();
        
        textArea.setCaretPosition(pos);
      }
      catch (Exception ex) {
        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        jNPad.setStatus(StatusType.ERROR, "Error - ".concat(getLabel())); //$NON-NLS-1$
      }
      finally {
        buffer.endCompoundEdit();
      }
    }
  }

}
